/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class EAF22Parser
extends Parser {
    private static boolean verbose = false;
    private final SAXParser saxParser;
    private final HashMap tiers = new HashMap();
    private final ArrayList tierNames = new ArrayList();
    private final HashMap tierAttributes = new HashMap();
    private final ArrayList linguisticTypes = new ArrayList();
    private final ArrayList locales = new ArrayList();
    private final HashMap timeSlots = new HashMap();
    private final HashMap controlledVocabularies = new HashMap();
    private final ArrayList timeOrder = new ArrayList();
    private String mediaFile;
    private ArrayList mediaDescriptors = new ArrayList();
    private String svgFile;
    private String author;
    private String currentTierId;
    private String currentAnnotationId;
    private String currentCVId;
    private CVEntryRecord currentEntryRecord;
    private String content = "";
    private String lastParsed = "";
    private String currentFileName;
    private boolean parseError;

    public EAF22Parser() {
        this.saxParser = new SAXParser();
        try {
            this.saxParser.setFeature("http://xml.org/sax/features/validation", true);
            this.saxParser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.saxParser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)"http://www.mpi.nl/tools/elan/EAFv2.2.xsd");
            this.saxParser.setContentHandler((ContentHandler)new EAFContentHandler());
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return this.mediaFile;
    }

    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.mediaDescriptors;
    }

    public String getSVGFile(String fileName) {
        this.parse(fileName);
        return this.svgFile;
    }

    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.author;
    }

    public ArrayList getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    public HashMap getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlots;
    }

    public HashMap getControlledVocabularies(String fileName) {
        this.parse(fileName);
        return this.controlledVocabularies;
    }

    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        String part = "";
        if (((HashMap)this.tierAttributes.get(tierName)).get("PARTICIPANT") != null) {
            part = (String)((HashMap)this.tierAttributes.get(tierName)).get("PARTICIPANT");
        }
        return part;
    }

    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        String lType = "";
        if (((HashMap)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF") != null) {
            lType = (String)((HashMap)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF");
        }
        return lType;
    }

    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        Locale resultLoc = null;
        String localeId = (String)((HashMap)this.tierAttributes.get(tierName)).get("DEFAULT_LOCALE");
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return (String)((HashMap)this.tierAttributes.get(tierName)).get("PARENT_REF");
    }

    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        ArrayList annotationList = new ArrayList();
        HashMap annotations = (HashMap)this.tiers.get(tierName);
        for (Object key : annotations.keySet()) {
            annotationList.add(annotations.get(key));
        }
        return annotationList;
    }

    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.tiers.clear();
        this.tierNames.clear();
        this.tierAttributes.clear();
        this.mediaFile = "";
        this.linguisticTypes.clear();
        this.locales.clear();
        this.timeSlots.clear();
        this.timeOrder.clear();
        this.mediaDescriptors.clear();
        this.controlledVocabularies.clear();
        this.lastParsed = fileName;
        this.currentFileName = fileName;
        try {
            this.saxParser.parse(fileName);
        }
        catch (SAXException e) {
            System.out.println("Parsing error: " + e.getMessage());
            File f = new File(fileName);
            if (f.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.saxParser.parse(source);
                }
                catch (Exception ee) {
                    System.out.println("Parsing retry error: " + ee.getMessage());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage());
        }
    }

    private void println(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
        System.out.println("Tier id " + this.currentTierId);
        System.out.println("Annotation id " + this.currentAnnotationId);
    }

    class EAFContentHandler
    implements ContentHandler {
        private Locator locator;

        EAFContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startDocument() throws SAXException {
            EAF22Parser.this.parseError = false;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAF22Parser.this.content = "";
            if (name.equals("ANNOTATION_DOCUMENT")) {
                EAF22Parser.this.author = attributes.getValue("AUTHOR");
            } else if (name.equals("HEADER")) {
                EAF22Parser.this.mediaFile = attributes.getValue("MEDIA_FILE");
                EAF22Parser.this.svgFile = attributes.getValue("SVG_FILE");
            } else if (name.equals("MEDIA_DESCRIPTOR")) {
                String mediaURL = attributes.getValue("MEDIA_URL");
                String mimeType = attributes.getValue("MIME_TYPE");
                MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
                long timeOrigin = 0L;
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    md.timeOrigin = timeOrigin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                }
                String extractedFrom = "";
                if (attributes.getValue("EXTRACTED_FROM") != null) {
                    md.extractedFrom = extractedFrom = attributes.getValue("EXTRACTED_FROM");
                }
                EAF22Parser.this.mediaDescriptors.add(md);
            } else if (!name.equals("TIME_ORDER")) {
                if (name.equals("TIME_SLOT")) {
                    String timeValue = String.valueOf(-1);
                    if (attributes.getValue("TIME_VALUE") != null) {
                        timeValue = attributes.getValue("TIME_VALUE");
                    }
                    EAF22Parser.this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                    EAF22Parser.this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
                } else if (name.equals("TIER")) {
                    EAF22Parser.this.currentTierId = attributes.getValue("TIER_ID");
                    if (!EAF22Parser.this.tiers.containsKey(EAF22Parser.this.currentTierId)) {
                        EAF22Parser.this.tiers.put(EAF22Parser.this.currentTierId, new HashMap());
                        EAF22Parser.this.tierAttributes.put(EAF22Parser.this.currentTierId, new HashMap());
                        EAF22Parser.this.tierNames.add(EAF22Parser.this.currentTierId);
                    }
                    HashMap attrHash = (HashMap)EAF22Parser.this.tierAttributes.get(EAF22Parser.this.currentTierId);
                    if (attributes.getValue("PARTICIPANT") != null) {
                        attrHash.put("PARTICIPANT", attributes.getValue("PARTICIPANT"));
                    }
                    attrHash.put("LINGUISTIC_TYPE_REF", attributes.getValue("LINGUISTIC_TYPE_REF"));
                    if (attributes.getValue("DEFAULT_LOCALE") != null) {
                        attrHash.put("DEFAULT_LOCALE", attributes.getValue("DEFAULT_LOCALE"));
                    } else {
                        attrHash.put("DEFAULT_LOCALE", "en");
                    }
                    if (attributes.getValue("PARENT_REF") != null) {
                        attrHash.put("PARENT_REF", attributes.getValue("PARENT_REF"));
                    }
                } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                    EAF22Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    AnnotationRecord record = new AnnotationRecord();
                    record.setAnnotationId(EAF22Parser.this.currentAnnotationId);
                    String svg_ref = attributes.getValue("SVG_REF");
                    if (svg_ref != null) {
                        record.setAnnotationType("alignable_svg");
                        record.setSvgReference(svg_ref);
                    } else {
                        record.setAnnotationType("alignable");
                    }
                    record.setBeginTimeSlotId(attributes.getValue("TIME_SLOT_REF1"));
                    record.setEndTimeSlotId(attributes.getValue("TIME_SLOT_REF2"));
                    ((HashMap)EAF22Parser.this.tiers.get(EAF22Parser.this.currentTierId)).put(EAF22Parser.this.currentAnnotationId, record);
                } else if (name.equals("REF_ANNOTATION")) {
                    EAF22Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    AnnotationRecord record = new AnnotationRecord();
                    record.setAnnotationId(EAF22Parser.this.currentAnnotationId);
                    record.setAnnotationType("reference");
                    record.setReferredAnnotId(attributes.getValue("ANNOTATION_REF"));
                    if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                        record.setPreviousAnnotId(attributes.getValue("PREVIOUS_ANNOTATION"));
                    } else {
                        record.setPreviousAnnotId("");
                    }
                    ((HashMap)EAF22Parser.this.tiers.get(EAF22Parser.this.currentTierId)).put(EAF22Parser.this.currentAnnotationId, record);
                } else if (name.equals("LINGUISTIC_TYPE")) {
                    LingTypeRecord ltr = new LingTypeRecord();
                    ltr.setLingTypeId(attributes.getValue("LINGUISTIC_TYPE_ID"));
                    String timeAlignable = "true";
                    if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                        timeAlignable = "false";
                    }
                    ltr.setTimeAlignable(timeAlignable);
                    String graphicReferences = "false";
                    if (attributes.getValue("GRAPHIC_REFERENCES") != null && attributes.getValue("GRAPHIC_REFERENCES").equals("true")) {
                        graphicReferences = "true";
                    }
                    ltr.setGraphicReferences(graphicReferences);
                    String stereotype = attributes.getValue("CONSTRAINTS");
                    ltr.setStereoType(stereotype);
                    ltr.setControlledVocabulary(attributes.getValue("CONTROLLED_VOCABULARY_REF"));
                    EAF22Parser.this.linguisticTypes.add(ltr);
                } else if (name.equals("LOCALE")) {
                    String variant;
                    String langCode = attributes.getValue("LANGUAGE_CODE");
                    String countryCode = attributes.getValue("COUNTRY_CODE");
                    if (countryCode == null) {
                        countryCode = "";
                    }
                    if ((variant = attributes.getValue("VARIANT")) == null) {
                        variant = "";
                    }
                    Locale l = new Locale(langCode, countryCode, variant);
                    EAF22Parser.this.locales.add(l);
                } else if (name.equals("CONTROLLED_VOCABULARY")) {
                    EAF22Parser.this.currentCVId = attributes.getValue("CV_ID");
                    ArrayList<String> cv = new ArrayList<String>();
                    String desc = attributes.getValue("DESCRIPTION");
                    if (desc != null) {
                        cv.add(desc);
                    }
                    EAF22Parser.this.controlledVocabularies.put(EAF22Parser.this.currentCVId, cv);
                } else if (name.equals("CV_ENTRY")) {
                    EAF22Parser.this.currentEntryRecord = new CVEntryRecord();
                    EAF22Parser.this.currentEntryRecord.setDescription(attributes.getValue("DESCRIPTION"));
                    ((ArrayList)EAF22Parser.this.controlledVocabularies.get(EAF22Parser.this.currentCVId)).add(EAF22Parser.this.currentEntryRecord);
                }
            }
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("ANNOTATION_VALUE")) {
                ((AnnotationRecord)((HashMap)EAF22Parser.this.tiers.get(EAF22Parser.this.currentTierId)).get(EAF22Parser.this.currentAnnotationId)).setValue(EAF22Parser.this.content);
            } else if (name.equals("CV_ENTRY")) {
                EAF22Parser.this.currentEntryRecord.setValue(EAF22Parser.this.content);
            }
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            EAF22Parser.this.content = EAF22Parser.this.content + new String(ch, start, end);
        }
    }
}

