/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF23;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF23Encoder
implements AnnotationDocEncoder {
    public static final String VERSION = "2.3";
    private static final Logger LOG = Logger.getLogger(EAF23Encoder.class.getName());
    public static boolean debug = false;

    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path) {
        Element documentElement = EAF23Encoder.createDOM(theTranscription, tierOrder);
        EAF23Encoder.save(documentElement, path);
    }

    public void encodeAsTemplateAndSave(Transcription theTranscription, List tierOrder, String path) {
        Element documentElement = EAF23Encoder.createTemplateDOM(theTranscription, tierOrder);
        EAF23Encoder.save(documentElement, path);
    }

    public static Element createDOM(Transcription theTranscription, List tierOrder) {
        Vector vector;
        long beginTime = System.currentTimeMillis();
        if (debug) {
            System.out.println("Encoder creating DOM...");
        }
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<TimeSlot, String> timeSlotIds = new Hashtable<TimeSlot, String>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            LOG.warning("[[ASSERTION FAILED]] ACM23TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF23 eafFactory = null;
        try {
            eafFactory = new EAF23();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF23Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        for (MediaDescriptor md : attisTr.getMediaDescriptors()) {
            String origin = null;
            if (md.timeOrigin != 0L) {
                origin = String.valueOf(md.timeOrigin);
            }
            String extrFrom = null;
            if (md.extractedFrom != null && md.extractedFrom != "") {
                extrFrom = md.extractedFrom;
            }
            Element mdElement = eafFactory.newMediaDescriptor(md.mediaURL, md.mimeType, origin, extrFrom);
            header.appendChild(mdElement);
        }
        for (LinkedFileDescriptor lfd : attisTr.getLinkedFileDescriptors()) {
            String origin = null;
            if (lfd.timeOrigin != 0L) {
                origin = String.valueOf(lfd.timeOrigin);
            }
            Element lfdElement = eafFactory.newLinkedFileDescriptor(lfd.linkURL, lfd.mimeType, origin, lfd.associatedWith);
            header.appendChild(lfdElement);
        }
        if (debug) {
            System.out.println("Header creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Enumeration tsElements = timeOrder.elements();
        while (tsElements.hasMoreElements()) {
            TimeSlot ts = (TimeSlot)tsElements.nextElement();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, tsId);
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        if (debug) {
            System.out.println("TimeSlots creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        int svgIndex = 1;
        int annIndex = 1;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String string = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(string, participant, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                annotationIds.put(ann, "a" + annIndex);
                ++annIndex;
            }
        }
        for (TierImpl tierImpl : storeOrder) {
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                Element annElement = eafFactory.newAnnotation();
                ((Element)tierElements.get(tierImpl.getName())).appendChild(annElement);
                Node annSubElement = null;
                String annId = (String)annotationIds.get(ann);
                if (ann instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getBegin());
                    String endTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getEnd());
                    if (ann instanceof SVGAlignableAnnotation) {
                        if (((SVGAlignableAnnotation)ann).getShape() != null) {
                            String svgId = "ga" + svgIndex;
                            ((SVGAlignableAnnotation)ann).setSVGElementID(svgId);
                            ++svgIndex;
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, svgId);
                        } else {
                            ((SVGAlignableAnnotation)ann).setSVGElementID(null);
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null);
                        }
                    } else {
                        annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null);
                    }
                } else if (ann instanceof RefAnnotation) {
                    String refId = null;
                    String prevId = null;
                    Vector refs = ((RefAnnotation)ann).getReferences();
                    RefAnnotation prev = ((RefAnnotation)ann).getPrevious();
                    if (refs.size() > 0) {
                        refId = (String)annotationIds.get((Annotation)refs.firstElement());
                    }
                    if (prev != null) {
                        prevId = (String)annotationIds.get(prev);
                    }
                    annSubElement = eafFactory.newRefAnnotation(annId, refId, prevId);
                }
                annElement.appendChild(annSubElement);
                Element valueElement = eafFactory.newAnnotationValue(ann.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        if (debug) {
            System.out.println("Tiers and Annotations creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((vector = attisTr.getLinguisticTypes()) != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype, lt.getControlledVocabylaryName());
                annotDocument.appendChild(typeElement);
            }
        }
        if (debug) {
            System.out.println("Linguistic Types creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        Vector conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            for (int i = 0; i < conVocs.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)conVocs.get(i);
                Element cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription());
                    cvElement.appendChild(entryElement);
                }
                annotDocument.appendChild(cvElement);
            }
        }
        if (debug) {
            System.out.println("Constraints and CV's creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        return eafFactory.getDocumentElement();
    }

    public static Element createTemplateDOM(Transcription theTranscription, List tierOrder) {
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            LOG.warning("[[ASSERTION FAILED]] ACM22TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF23 eafFactory = null;
        try {
            eafFactory = new EAF23();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm z");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        String author = attisTr.getAuthor();
        author = "";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        boolean annIndex = true;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String id = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
        }
        Vector vector = attisTr.getLinguisticTypes();
        if (vector != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype, lt.getControlledVocabylaryName());
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        Vector conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            for (int i = 0; i < conVocs.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)conVocs.get(i);
                Element cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription());
                    cvElement.appendChild(entryElement);
                }
                annotDocument.appendChild(cvElement);
            }
        }
        return eafFactory.getDocumentElement();
    }

    private static String correctDate(String strIn) {
        String strResult = new String(strIn);
        try {
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            String strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = strOffset + "0";
            }
            strOffset = strOffset + offsetGMT + ":00";
            int indexSpace = (strResult = strResult + strOffset).indexOf(" ");
            if (indexSpace != -1) {
                String strEnd = strResult.substring(indexSpace + 1);
                strResult = strResult.substring(0, indexSpace);
                strResult = strResult + "T";
                strResult = strResult + strEnd;
            }
            strResult = strResult.replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }

    private static void save(Element documentElement, String path) {
        LOG.info(path + " <----XML output\n");
        try {
            if (("" + documentElement).length() == 0) {
                String txt = "Sorry: unable to save this file (zero length).";
                JOptionPane.showMessageDialog(null, txt, txt, 0);
                return;
            }
            long beginTime = System.currentTimeMillis();
            IoUtil.writeEncodedEAFFile("UTF-8", path, documentElement);
            if (debug) {
                System.out.println("Saving file took: " + (System.currentTimeMillis() - beginTime) + " ms");
            }
        }
        catch (Exception eee) {
            String txt = "Sorry: unable to save this file. (" + eee.getMessage() + ")";
            JOptionPane.showMessageDialog(null, txt, txt, 0);
        }
    }
}

