/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV01;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECV01Encoder {
    public static final String VERSION = "0.1";

    public void encodeAndSave(ExternalCV cv, String path, String extRefId) throws IOException {
        Element documentElement = this.createDOM(cv);
        Object extRef = cv.getExternalRef();
        if (extRef instanceof ExternalReference) {
            this.save(documentElement, path, ((ExternalReference)extRef).getValue());
        }
    }

    public void encodeAndSave(List<ExternalCV> cvs, String path, ExternalReference extRef) throws IOException {
        Element documentElement = this.createDOM(cvs);
        this.save(documentElement, path, extRef.getValue());
    }

    private void save(Element documentElement, String cachePath, String urlString) throws IOException {
        String savePath = cachePath;
        String fileName = "";
        try {
            URL url = new URL(urlString);
            String urlHost = url.getHost();
            if (urlHost.equals("")) {
                urlHost = "localfile_system";
            }
            savePath = savePath + File.separator + urlHost;
            String[] pathElements = url.getPath().substring(1).split("/");
            for (int i = 0; i < pathElements.length - 1; ++i) {
                savePath = savePath + File.separator + pathElements[i];
            }
            fileName = pathElements[pathElements.length - 1];
        }
        catch (MalformedURLException e) {
            ServerLogger.LOG.warning("Could not create a cache directory structure: " + e.getMessage());
            int index = urlString.lastIndexOf(File.separator);
            fileName = index > -1 && index < urlString.length() - 2 ? urlString.substring(index + 1) : ((index = urlString.lastIndexOf("/")) > -1 && index < urlString.length() - 2 ? urlString.substring(index + 1) : urlString);
        }
        File dir = new File(savePath);
        if (dir.exists() || dir.mkdirs()) {
            savePath = savePath + File.separator + fileName;
            try {
                if (("" + documentElement).length() == 0) {
                    throw new IOException("Unable to save this file (zero length).");
                }
                IoUtil.writeEncodedFile("UTF-8", savePath, documentElement);
            }
            catch (Exception eee) {
                ServerLogger.LOG.severe("Could not save the cache file: " + eee.getMessage());
            }
        }
    }

    private Element createDOM(ExternalCV cv) {
        ECV01 ecvFactory = null;
        String extRefId = null;
        try {
            ecvFactory = new ECV01();
        }
        catch (Exception ex) {
            ServerLogger.LOG.severe("Could not create a document builder: " + ex.getMessage());
        }
        HashMap<String, Object> extRefIds = new HashMap<String, Object>();
        ArrayList<String> extRefList = new ArrayList<String>();
        int extRefIndex = 1;
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = ECV01Encoder.correctDate(dateString);
        Element ecvDocument = ecvFactory.newExternalCVDocument(dateString, "", VERSION);
        ecvFactory.appendChild(ecvDocument);
        Element cvElement = ecvFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
        CVEntry[] entries = cv.getEntries();
        for (int j = 0; j < entries.length; ++j) {
            CVEntry entry = entries[j];
            if (entry.getExternalRef() != null) {
                if (entry.getExternalRef() instanceof String && ((String)entry.getExternalRef()).length() == 0) {
                    extRefId = null;
                } else if (!extRefIds.containsValue(entry.getExternalRef())) {
                    extRefId = "er" + extRefIndex++;
                    extRefIds.put(extRefId, entry.getExternalRef());
                    extRefList.add(extRefId);
                } else {
                    for (int k = 0; k < extRefList.size(); ++k) {
                        if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                        extRefId = (String)extRefList.get(k);
                        break;
                    }
                }
            } else {
                extRefId = null;
            }
            String entryId = null;
            if (entry instanceof ExternalCVEntry) {
                entryId = ((ExternalCVEntry)entry).getId();
            }
            Element entryElement = ecvFactory.newCVEntry(entryId, entry.getValue(), entry.getDescription(), extRefId);
            cvElement.appendChild(entryElement);
        }
        ecvDocument.appendChild(cvElement);
        ArrayList<String> types = new ArrayList<String>();
        types.add("undefined");
        types.add("reference_group");
        types.add("iso12620");
        types.add("resource_url");
        types.add("external_cv");
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = ecvFactory.newExternalReference(id, (String)types.get(eri.getReferenceType()), eri.getValue());
            ecvDocument.appendChild(erElement);
        }
        return ecvFactory.getDocumentElement();
    }

    private Element createDOM(List<ExternalCV> cvs) {
        ECV01 ecvFactory = null;
        String extRefId = null;
        try {
            ecvFactory = new ECV01();
        }
        catch (Exception ex) {
            ServerLogger.LOG.severe("Could not create a document builder: " + ex.getMessage());
        }
        HashMap<String, Object> extRefIds = new HashMap<String, Object>();
        ArrayList<String> extRefList = new ArrayList<String>();
        int extRefIndex = 1;
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = ECV01Encoder.correctDate(dateString);
        Element ecvDocument = ecvFactory.newExternalCVDocument(dateString, "", VERSION);
        ecvFactory.appendChild(ecvDocument);
        if (cvs != null && cvs.size() > 0) {
            for (int i = 0; i < cvs.size(); ++i) {
                ExternalCV cv = cvs.get(i);
                Element cvElement = ecvFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    if (entry.getExternalRef() != null) {
                        if (entry.getExternalRef() instanceof String && ((String)entry.getExternalRef()).length() == 0) {
                            extRefId = null;
                        } else if (!extRefIds.containsValue(entry.getExternalRef())) {
                            extRefId = "er" + extRefIndex++;
                            extRefIds.put(extRefId, entry.getExternalRef());
                            extRefList.add(extRefId);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId = null;
                    }
                    String entryId = null;
                    if (entry instanceof ExternalCVEntry) {
                        entryId = ((ExternalCVEntry)entry).getId();
                    }
                    Element entryElement = ecvFactory.newCVEntry(entryId, entry.getValue(), entry.getDescription(), extRefId);
                    cvElement.appendChild(entryElement);
                }
                ecvDocument.appendChild(cvElement);
            }
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("undefined");
        types.add("reference_group");
        types.add("iso12620");
        types.add("resource_url");
        types.add("external_cv");
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = ecvFactory.newExternalReference(id, (String)types.get(eri.getReferenceType()), eri.getValue());
            ecvDocument.appendChild(erElement);
        }
        return ecvFactory.getDocumentElement();
    }

    private static String correctDate(String strIn) {
        String strResult = new String(strIn);
        try {
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            String strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = strOffset + "0";
            }
            strOffset = strOffset + offsetGMT + ":00";
            int indexSpace = (strResult = strResult + strOffset).indexOf(" ");
            if (indexSpace != -1) {
                String strEnd = strResult.substring(indexSpace + 1);
                strResult = strResult.substring(0, indexSpace);
                strResult = strResult + "T";
                strResult = strResult + strEnd;
            }
            strResult = strResult.replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }
}

