/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECV01Parser {
    private XMLReader reader;
    private String url;
    private final ArrayList<ControlledVocabulary> cvList = new ArrayList();
    private final HashMap<String, ExternalReference> extReferences = new HashMap();
    private final HashMap<CVEntry, String> cvEntryExtRef = new HashMap();
    private String currentCVId;
    private ControlledVocabulary currentCV;
    private String currentEntryDesc;
    private String currentEntryExtRef;
    private String content = "";
    private boolean parseError;
    private String author;
    public String currentEntryId;

    public ECV01Parser(String url) throws ParseException {
        this(url, false);
    }

    public ECV01Parser(String url, boolean strict) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResource(ACMTranscriptionStore.getCurrentEAFSchemaLocal()).openStream());
            this.reader.setContentHandler(new ECV01Handler());
            if (strict) {
                this.reader.setErrorHandler(new ECV01ErrorHandler());
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void parse() throws ParseException {
        block10: {
            try {
                this.reader.parse(this.url);
                this.createObjects();
            }
            catch (SAXException sax) {
                System.out.println("Parsing error: " + sax.getMessage());
                if (this.url.toLowerCase().startsWith("file:")) {
                    File f = new File(this.url);
                    if (!f.exists()) break block10;
                    try {
                        FileInputStream fis = new FileInputStream(f);
                        InputSource source = new InputSource(fis);
                        this.reader.parse(source);
                    }
                    catch (Exception ee) {
                        System.out.println("Parsing retry error: " + ee.getMessage());
                        throw new ParseException(ee.getMessage(), ee.getCause());
                    }
                }
                throw new ParseException(sax.getMessage(), sax.getCause());
            }
            catch (IOException ioe) {
                System.out.println("IO error: " + ioe.getMessage());
                if (this.url.toLowerCase().startsWith("file:")) {
                    File f = new File(this.url);
                    if (!f.exists()) break block10;
                    try {
                        FileInputStream fis = new FileInputStream(f);
                        InputSource source = new InputSource(fis);
                        this.reader.parse(source);
                    }
                    catch (Exception ee) {
                        System.out.println("Parsing retry error: " + ee.getMessage());
                        throw new ParseException(ee.getMessage(), ee.getCause());
                    }
                }
                throw new ParseException(ioe.getMessage(), ioe.getCause());
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage(), e.getCause());
            }
        }
    }

    private void createObjects() {
        if (this.cvEntryExtRef.size() > 0) {
            for (CVEntry entry : this.cvEntryExtRef.keySet()) {
                String erId = this.cvEntryExtRef.get(entry);
                ExternalReferenceImpl eri = (ExternalReferenceImpl)this.extReferences.get(erId);
                if (eri == null) continue;
                try {
                    entry.setExternalRef(eri.clone());
                }
                catch (CloneNotSupportedException cnse) {
                    System.out.println("Could not set the external reference: " + cnse.getMessage());
                }
            }
        }
    }

    public ArrayList<ControlledVocabulary> getControlledVocabularies() {
        return this.cvList;
    }

    public Map<String, ExternalReference> getExternalReferences() {
        return this.extReferences;
    }

    public class ECV01Handler
    implements ContentHandler {
        private Locator locator;

        public void characters(char[] ch, int start, int end) throws SAXException {
            ECV01Parser.this.content = ECV01Parser.this.content + new String(ch, start, end);
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("CV_ENTRY")) {
                ExternalCVEntry entry = new ExternalCVEntry(ECV01Parser.this.content, ECV01Parser.this.currentEntryDesc, ECV01Parser.this.currentEntryId);
                ECV01Parser.this.currentCV.addEntry(entry);
                if (ECV01Parser.this.currentEntryExtRef != null) {
                    ECV01Parser.this.cvEntryExtRef.put(entry, ECV01Parser.this.currentEntryExtRef);
                }
            }
        }

        public void endPrefixMapping(String arg0) throws SAXException {
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void startDocument() throws SAXException {
            ECV01Parser.this.parseError = false;
        }

        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            ECV01Parser.this.content = "";
            if (name.equals("CV_RESOURCE")) {
                ECV01Parser.this.author = attributes.getValue("AUTHOR");
            } else if (name.equals("CONTROLLED_VOCABULARY")) {
                ExternalReferenceImpl eri;
                String extRefId;
                ECV01Parser.this.currentCVId = attributes.getValue("CV_ID");
                ECV01Parser.this.currentCV = new ExternalCV(ECV01Parser.this.currentCVId);
                String desc = attributes.getValue("DESCRIPTION");
                if (desc != null) {
                    ECV01Parser.this.currentCV.setDescription(desc);
                }
                if ((extRefId = attributes.getValue("EXT_REF")) != null && (eri = (ExternalReferenceImpl)ECV01Parser.this.extReferences.get(extRefId)) != null) {
                    try {
                        ((ExternalCV)ECV01Parser.this.currentCV).setExternalRef(eri.clone());
                    }
                    catch (CloneNotSupportedException cnse) {
                        // empty catch block
                    }
                }
                ECV01Parser.this.cvList.add(ECV01Parser.this.currentCV);
            } else if (name.equals("CV_ENTRY")) {
                ECV01Parser.this.currentEntryDesc = attributes.getValue("DESCRIPTION");
                ECV01Parser.this.currentEntryExtRef = attributes.getValue("EXT_REF");
                ECV01Parser.this.currentEntryId = attributes.getValue("CVE_ID");
            } else if (name.equals("EXTERNAL_REF")) {
                String value = attributes.getValue("VALUE");
                String type = attributes.getValue("TYPE");
                String refId = attributes.getValue("EXT_REF_ID");
                if (value != null) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(value, 0);
                    if (type != null) {
                        if (type.equals("iso12620")) {
                            eri.setReferenceType(2);
                        } else if (type.equals("resource_url")) {
                            eri.setReferenceType(3);
                        } else if (type.equals("ecv")) {
                            eri.setReferenceType(4);
                        } else if (type.equals("cve_id")) {
                            eri.setReferenceType(5);
                        } else if (type.equals("lexen_id")) {
                            eri.setReferenceType(6);
                        }
                    }
                    ECV01Parser.this.extReferences.put(refId, eri);
                }
            }
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }

    class ECV01ErrorHandler
    implements ErrorHandler {
        ECV01ErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("System id: " + exception.getSystemId());
            System.out.println("Public id: " + exception.getPublicId());
            System.out.println("Line: " + exception.getLineNumber());
            System.out.println("Column: " + exception.getColumnNumber());
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }
}

