/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV01Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV01Parser;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECVStore {
    public void loadExternalCV(ExternalCV cv, String url) throws ParseException {
        ECV01Parser ecvParser = null;
        try {
            ecvParser = new ECV01Parser(url);
            ecvParser.parse();
        }
        catch (ParseException pe) {
            System.out.println("Parse failed " + url);
            throw pe;
        }
        Map<String, ExternalReference> extReferences = ecvParser.getExternalReferences();
        ArrayList<ControlledVocabulary> allCVs = ecvParser.getControlledVocabularies();
        ExternalCV cvFromUrl = null;
        for (int i = 0; i < allCVs.size(); ++i) {
            cvFromUrl = (ExternalCV)allCVs.get(i);
            if (!cvFromUrl.getName().equals(cv.getName())) continue;
            cv.addAll(cvFromUrl.getEntries());
        }
    }

    public void loadExternalCVS(List<ExternalCV> ecvList, String url) throws ParseException {
        if (ecvList == null || ecvList.size() == 0) {
            return;
        }
        ECV01Parser ecvParser = null;
        try {
            ecvParser = new ECV01Parser(url);
            ecvParser.parse();
        }
        catch (ParseException pe) {
            ServerLogger.LOG.severe("Parse failed " + url);
            throw pe;
        }
        Map<String, ExternalReference> extReferences = ecvParser.getExternalReferences();
        ArrayList<ControlledVocabulary> allCVs = ecvParser.getControlledVocabularies();
        ExternalCV cvFromUrl = null;
        ExternalCV cvFromList = null;
        block2: for (int j = 0; j < ecvList.size(); ++j) {
            cvFromList = ecvList.get(j);
            for (int i = 0; i < allCVs.size(); ++i) {
                cvFromUrl = (ExternalCV)allCVs.get(i);
                if (!cvFromUrl.getName().equals(cvFromList.getName())) continue;
                cvFromList.addAll(cvFromUrl.getEntries());
                continue block2;
            }
        }
    }

    public void storeExternalCV(ExternalCV cv, String cachePath, String urlString) {
        if (cv == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no external CV provided.");
            return;
        }
        ArrayList<ExternalCV> list = new ArrayList<ExternalCV>(1);
        this.storeExternalCVS(list, cachePath, urlString);
    }

    public void storeExternalCVS(List<ExternalCV> ecvList, String cachePath, String urlString) {
        if (ecvList == null || ecvList.size() == 0) {
            ServerLogger.LOG.warning("Could not create a cached version: no external CV's provided.");
            return;
        }
        if (cachePath == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no cache folder specified.");
            return;
        }
        if (cachePath == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no source URL specified.");
            return;
        }
        ExternalReferenceImpl eri = new ExternalReferenceImpl(urlString, 4);
        try {
            ECV01Encoder encoder = new ECV01Encoder();
            encoder.encodeAndSave(ecvList, cachePath, eri);
        }
        catch (Throwable thr) {
            ServerLogger.LOG.severe("Could not create a cached version: " + thr.getMessage());
        }
    }
}

