/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.util.ArrayList;
import java.util.StringTokenizer;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxLine;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxWord;

public class InterlinearToolboxLine
implements ToolboxLine {
    private static final String blockSep = "\n\t\n";
    private static final int BLOCK_INDEX = 1000000;
    private ToolboxLine parent;
    private String marker = "";
    private String line = "";
    private ArrayList<ToolboxWord> indexedWords;
    private int[] startIndices;
    private boolean correctForMultipleByteChars = true;

    public InterlinearToolboxLine(String marker, String line) {
        this.marker = marker;
        this.line = line;
    }

    public String getMarkerName() {
        return this.marker;
    }

    public ToolboxLine getParent() {
        return this.parent;
    }

    public void setCorrectForMultipleByteChars(boolean correct) {
        this.correctForMultipleByteChars = correct;
    }

    public void setParent(ToolboxLine parent) {
        this.parent = parent;
    }

    public void appendLine(String appLine) {
        if (appLine != null) {
            this.line = this.line + blockSep + appLine;
        }
    }

    public ToolboxWord getWordAtIndex(int index, int calcLength) {
        ToolboxWord tw = null;
        ToolboxWord countTw = null;
        for (int i = 0; i < this.indexedWords.size(); ++i) {
            countTw = this.indexedWords.get(i);
            if (countTw.calcX == index) {
                return countTw;
            }
            if (countTw.calcX > index) {
                if (tw != null) {
                    if (index + calcLength <= tw.calcX + tw.calcW) {
                        return tw;
                    }
                    int overlap1 = tw.calcX + tw.calcW - index;
                    int overlap2 = index + calcLength - countTw.calcX;
                    if (overlap1 > overlap2) {
                        return tw;
                    }
                    if (overlap1 < overlap2) {
                        return countTw;
                    }
                    if (index - tw.calcX < countTw.calcX - index) {
                        return countTw;
                    }
                    if (index - tw.calcX > countTw.calcX - index) {
                        return tw;
                    }
                    return tw;
                }
                return countTw;
            }
            tw = countTw;
        }
        return tw;
    }

    public int[] getStartIndices() {
        if (this.startIndices == null) {
            this.startIndices = new int[1];
            this.startIndices[0] = 0;
        }
        return this.startIndices;
    }

    public int getPositionOfWord(ToolboxWord tw) {
        if (this.indexedWords == null || tw == null) {
            return -1;
        }
        return this.indexedWords.indexOf(tw);
    }

    public int getNumberOfWords() {
        if (this.startIndices != null) {
            return this.startIndices.length;
        }
        return 0;
    }

    public void createIndices() {
        String[] lines = this.line.split(blockSep);
        this.indexedWords = new ArrayList();
        int b = 0;
        boolean e = false;
        int cb = 0;
        int numNS = 0;
        boolean inword = false;
        for (int i = 0; i < lines.length; ++i) {
            b = 0;
            numNS = 0;
            char[] chars = lines[i].toCharArray();
            for (int j = 0; j < chars.length; ++j) {
                ToolboxWord tw;
                if (!this.isSpace(chars[j])) {
                    if (!inword) {
                        inword = true;
                        b = j;
                        cb = b - numNS;
                        if (j > 0 && this.indexedWords.size() == 0) {
                            tw = new ToolboxWord(this.marker, new String(""));
                            tw.calcX = tw.realX = i * 1000000;
                            tw.realW = tw.calcW = j - 1;
                        }
                    }
                    if (!this.isNonSpacing(chars[j])) continue;
                    ++numNS;
                    continue;
                }
                if (!inword) continue;
                tw = new ToolboxWord(this.marker, new String(chars, b, j - b));
                tw.realX = b + i * 1000000;
                tw.calcX = cb + i * 1000000;
                if (this.indexedWords.size() > 0) {
                    ToolboxWord prev = this.indexedWords.get(this.indexedWords.size() - 1);
                    prev.realW = tw.realX - prev.realX;
                    prev.calcW = prev.realW - (prev.realX - prev.calcX);
                }
                this.indexedWords.add(tw);
                inword = false;
            }
        }
        this.createStartIndices();
    }

    public void createIndices2() {
        String[] lines = this.line.split(blockSep);
        StringTokenizer tokenizer = null;
        this.indexedWords = new ArrayList();
        int b = 0;
        int numNS = 0;
        for (int i = 0; i < lines.length; ++i) {
            b = 0;
            numNS = 0;
            tokenizer = new StringTokenizer(lines[i]);
            int numToks = tokenizer.countTokens();
            for (int j = 0; j < numToks; ++j) {
                int index;
                String nextToken = tokenizer.nextToken();
                b = index = lines[i].indexOf(nextToken, b);
                ToolboxWord tw = new ToolboxWord(this.marker, nextToken);
                tw.realX = b + i * 1000000;
                tw.calcX = tw.realX - numNS;
                if (this.indexedWords.size() > 0) {
                    ToolboxWord prev = this.indexedWords.get(this.indexedWords.size() - 1);
                    prev.realW = tw.realX - prev.realX;
                    prev.calcW = tw.calcX - prev.calcX;
                }
                this.indexedWords.add(tw);
                char[] chars = nextToken.toCharArray();
                for (int k = 0; k < chars.length; ++k) {
                    if (this.isNonSpacing(chars[k])) {
                        ++numNS;
                        continue;
                    }
                    if (!this.correctForMultipleByteChars) continue;
                    numNS -= this.getNumExtraBytes(chars[k]);
                }
                if (i == lines.length - 1 && j == numToks - 1) {
                    tw.calcW = tw.realW = nextToken.length();
                }
                b += nextToken.length();
            }
        }
        this.createStartIndices();
    }

    public boolean conditionallyInsertWord(int begin, int end) {
        ToolboxWord tw = null;
        for (int i = 0; i < this.indexedWords.size(); ++i) {
            tw = this.indexedWords.get(i);
            if (tw.calcX >= begin || end >= tw.calcX + tw.calcW || begin <= tw.calcX + tw.word.length()) continue;
            ToolboxWord nextWord = new ToolboxWord(this.marker, "");
            nextWord.calcX = begin;
            nextWord.calcW = end - begin;
            nextWord.realX = nextWord.calcX;
            nextWord.realW = nextWord.calcW;
            if (i < this.indexedWords.size() - 1) {
                ToolboxWord afterWord = this.indexedWords.get(i + 1);
                if (nextWord.calcX + nextWord.calcW < afterWord.calcX) {
                    nextWord.calcW = afterWord.calcX - begin;
                }
            }
            tw.calcW = begin - tw.calcX;
            this.indexedWords.add(i + 1, nextWord);
            this.createStartIndices();
            return true;
        }
        return false;
    }

    private void createStartIndices() {
        if (this.indexedWords == null || this.indexedWords.size() == 0) {
            return;
        }
        this.startIndices = new int[this.indexedWords.size()];
        ToolboxWord tw = null;
        for (int i = 0; i < this.indexedWords.size(); ++i) {
            tw = this.indexedWords.get(i);
            this.startIndices[i] = tw.calcX;
        }
    }

    private boolean isSpace(char c) {
        return c == '\t' || c == '\n' || c == ' ';
    }

    private boolean isNonSpacing(char c) {
        int type = Character.getType(c);
        return type == 6 || type == 7 || type == 8;
    }

    private int getNumExtraBytes(char c) {
        if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
            return 1;
        }
        if (c >= '\u0800' && c <= '\uffff') {
            return 2;
        }
        return 0;
    }

    public String toString() {
        return this.marker + ": " + this.line;
    }
}

