/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AnnotationWrapperTag;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.AnnotationUtil;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ShoeboxTier
extends TierImpl {
    public ShoeboxTier(String name, String participant, Transcription parent, LinguisticType theType) {
        super(name, participant, parent, theType);
        if (parent != null) {
            parent.addTier(this);
        }
    }

    public ShoeboxTier(Tier parenttier, String name, String participant, Transcription parent, LinguisticType theType) {
        super(parenttier, name, participant, parent, theType);
        if (parent != null) {
            parent.addTier(this);
        }
    }

    public final Annotation addAlignableAnnotation(long t0, long t1, String val) {
        TimeSlotImpl tt0 = new TimeSlotImpl(t0, ((Transcription)this.parent).getTimeOrder());
        TimeSlotImpl tt1 = new TimeSlotImpl(t1, ((Transcription)this.parent).getTimeOrder());
        ((Transcription)this.parent).getTimeOrder().insertTimeSlot(tt0);
        ((Transcription)this.parent).getTimeOrder().insertTimeSlot(tt1);
        AlignableAnnotation result = new AlignableAnnotation(tt0, tt1, this);
        result.setValue(val);
        this.insertAnnotation(result);
        return result;
    }

    public final Annotation addRefAnnotation(Annotation dad, String val) {
        RefAnnotation result = new RefAnnotation(dad, this);
        result.setValue(val);
        RefAnnotation brother = AnnotationUtil.getLastKid(dad, this);
        if (brother != null && brother != result) {
            brother.setNext(result);
        }
        this.insertAnnotation(result);
        return result;
    }

    public final String getNameNoSpeaker() {
        String result = this.getName();
        return result.substring(0, result.indexOf(64));
    }

    public Vector getTags() {
        Vector<AnnotationWrapperTag> result = new Vector<AnnotationWrapperTag>();
        int index = 0;
        for (Annotation annot : this.annotations) {
            AnnotationWrapperTag tag = new AnnotationWrapperTag(annot.getBeginTimeBoundary(), annot.getEndTimeBoundary(), this, index, annot);
            tag.addValue(annot.getValue());
            result.add(tag);
            ++index;
        }
        return result;
    }
}

