/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxMarker;
import mpi.eudico.server.corpora.util.ServerLogger;

public class ToolboxTypFile {
    private String typFileName = "";
    private String databaseType = "";
    private String recordMarker = null;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Root");
    private List<String> includedMarkers = new ArrayList<String>();
    private List<String> interlinearMarkers;
    private HashMap<String, String> parentMap = null;
    private String participantMarker = null;

    public ToolboxTypFile(File typFile) {
        if (typFile == null) {
            throw new IllegalArgumentException("No .typ file specified");
        }
        if (!typFile.exists() || !typFile.canRead()) {
            throw new IllegalArgumentException("The .typ file does not exist or is inaccessible");
        }
        this.typFileName = typFile.getAbsolutePath();
        this.readTypFile(typFile);
    }

    public ToolboxTypFile(List markers) {
        if (markers == null) {
            throw new IllegalArgumentException("No markers specified");
        }
        this.initializeFromMarkerRecords(markers);
    }

    public String getRecordMarker() {
        return this.recordMarker;
    }

    public DefaultMutableTreeNode getMarkerTree() {
        return this.rootNode;
    }

    public boolean isIncluded(String marker) {
        return this.includedMarkers.contains(marker);
    }

    public boolean isSubdivision(String marker) {
        if (marker == null) {
            return false;
        }
        ToolboxMarker curMark = null;
        DefaultMutableTreeNode node = null;
        Enumeration<TreeNode> markEn = this.rootNode.breadthFirstEnumeration();
        while (markEn.hasMoreElements()) {
            node = (DefaultMutableTreeNode)markEn.nextElement();
            if (!(node.getUserObject() instanceof ToolboxMarker) || !(curMark = (ToolboxMarker)node.getUserObject()).getMarker().equals(marker)) continue;
            int stereo = curMark.getStereoType();
            return stereo == 3 || stereo == 0 || stereo == 1;
        }
        return false;
    }

    public boolean isInterlinear(String marker) {
        if (marker == null) {
            return false;
        }
        if (this.interlinearMarkers == null) {
            this.interlinearMarkers = new ArrayList<String>();
            ToolboxMarker curMark = null;
            ToolboxMarker parMark = null;
            DefaultMutableTreeNode node = null;
            Enumeration<TreeNode> markEn = this.rootNode.breadthFirstEnumeration();
            block0: while (markEn.hasMoreElements()) {
                node = (DefaultMutableTreeNode)markEn.nextElement();
                if (!(node.getUserObject() instanceof ToolboxMarker)) continue;
                curMark = (ToolboxMarker)node.getUserObject();
                int stereo = curMark.getStereoType();
                if (stereo == 3 || stereo == 0 || stereo == 1) {
                    this.interlinearMarkers.add(curMark.getMarker());
                    continue;
                }
                if (stereo != 4) continue;
                while (node.getParent() != null && node.getParent() != this.rootNode) {
                    if (!((node = (DefaultMutableTreeNode)node.getParent()).getUserObject() instanceof ToolboxMarker) || (stereo = (parMark = (ToolboxMarker)node.getUserObject()).getStereoType()) != 3 && stereo != 0 && stereo != 1) continue;
                    this.interlinearMarkers.add(curMark.getMarker());
                    continue block0;
                }
            }
        }
        return this.interlinearMarkers.contains(marker);
    }

    public int getStereoType(String markerName) {
        if (markerName == null) {
            return -1;
        }
        ToolboxMarker curMark = null;
        DefaultMutableTreeNode node = null;
        int type = -1;
        Enumeration<TreeNode> markEn = this.rootNode.breadthFirstEnumeration();
        while (markEn.hasMoreElements()) {
            node = (DefaultMutableTreeNode)markEn.nextElement();
            if (!(node.getUserObject() instanceof ToolboxMarker) || !(curMark = (ToolboxMarker)node.getUserObject()).getMarker().equals(markerName)) continue;
            return curMark.getStereoType();
        }
        return type;
    }

    public String getParentMarker(String marker) {
        if (marker == null) {
            return null;
        }
        if (this.parentMap != null) {
            return this.parentMap.get(marker);
        }
        return null;
    }

    public String getParticipantMarker() {
        return this.participantMarker;
    }

    public void setParticipantMarker(String participantMarker) {
        this.participantMarker = participantMarker;
    }

    private void fillParentMap() {
        if (this.parentMap == null) {
            this.parentMap = new HashMap();
            ToolboxMarker curMark = null;
            ToolboxMarker parMark = null;
            DefaultMutableTreeNode node = null;
            Enumeration<TreeNode> markEn = this.rootNode.breadthFirstEnumeration();
            while (markEn.hasMoreElements()) {
                node = (DefaultMutableTreeNode)markEn.nextElement();
                if (!(node.getUserObject() instanceof ToolboxMarker)) continue;
                curMark = (ToolboxMarker)node.getUserObject();
                if (node.getParent() == null || !(((DefaultMutableTreeNode)node.getParent()).getUserObject() instanceof ToolboxMarker)) continue;
                parMark = (ToolboxMarker)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                this.parentMap.put(curMark.getMarker(), parMark.getMarker());
            }
        }
    }

    private void readTypFile(File typFile) {
        String line = null;
        ToolboxMarker curMark = null;
        ArrayList<ToolboxMarker> tfMarkers = new ArrayList<ToolboxMarker>(12);
        String label = null;
        String content = null;
        int linenumber = 0;
        String lastFrom = "";
        String lastTo = "";
        String procType = "Lookup";
        try {
            FileReader filereader = new FileReader(typFile);
            BufferedReader br = new BufferedReader(filereader);
            try {
                ToolboxMarker tm2;
                ToolboxMarker tm1;
                block4: while ((line = br.readLine()) != null) {
                    ++linenumber;
                    if ((line = line.trim()).length() == 0) continue;
                    if (linenumber == 1 && line.indexOf("\\+DatabaseType") > -1) {
                        StringTokenizer st = new StringTokenizer(line);
                        st.nextToken();
                        String db = st.nextToken();
                        if (db == null) continue;
                        this.databaseType = db.trim();
                        continue;
                    }
                    StringTokenizer xxx = new StringTokenizer(line);
                    label = xxx.nextToken();
                    content = line.substring(label.length()).trim();
                    if (this.recordMarker == null && label.equals("\\mkrRecord")) {
                        this.recordMarker = content;
                        curMark = new ToolboxMarker(content);
                        this.rootNode.setUserObject(curMark);
                        this.includedMarkers.add(content);
                    }
                    if (label.equals("\\+mkr")) {
                        this.includedMarkers.add(content);
                        curMark = new ToolboxMarker(content);
                        tfMarkers.add(curMark);
                        if (this.recordMarker != null && !content.equals(this.recordMarker)) {
                            curMark.setParent(this.recordMarker);
                            curMark.setStereoType(4);
                        }
                    }
                    if (label.equals("\\-mkr")) {
                        curMark = null;
                    }
                    if (label.equals("\\+intprc")) {
                        lastFrom = "";
                        lastTo = "";
                        procType = "Parse";
                    }
                    if (label.equals("\\mkrFrom")) {
                        lastFrom = content;
                    }
                    if (label.equals("\\mkrTo")) {
                        lastTo = content;
                    }
                    if (line.indexOf("Lookup") >= 0) {
                        procType = "Lookup";
                    }
                    if (line.indexOf("ParseProc") >= 0) {
                        procType = "Parse";
                    }
                    if (!label.equals("\\-intprc")) continue;
                    for (int i = 0; i < tfMarkers.size(); ++i) {
                        ToolboxMarker tm = (ToolboxMarker)tfMarkers.get(i);
                        if (!tm.getMarker().equals(lastTo)) continue;
                        tm.setParent(lastFrom);
                        if (!procType.equals("Parse")) continue block4;
                        tm.setSubdivision(true);
                        tm.setStereoType(3);
                        continue block4;
                    }
                }
                br.close();
                ((Reader)filereader).close();
                ArrayList<DefaultMutableTreeNode> allNodes = new ArrayList<DefaultMutableTreeNode>(tfMarkers.size());
                block6: for (int i = 0; i < tfMarkers.size(); ++i) {
                    tm1 = (ToolboxMarker)tfMarkers.get(i);
                    if (tm1.getMarker().equals(this.recordMarker)) continue;
                    allNodes.add(new DefaultMutableTreeNode(tm1));
                    if (tm1.getParent() == null || !tm1.getParent().equals(this.recordMarker)) continue;
                    for (int j = 0; j < tfMarkers.size(); ++j) {
                        if (j == i || (tm2 = (ToolboxMarker)tfMarkers.get(j)).getParent() == null || !tm2.getParent().equals(tm1.getMarker())) continue;
                        tm1.setSubdivision(true);
                        tm1.setStereoType(3);
                        continue block6;
                    }
                }
                block8: for (int i = 0; i < allNodes.size(); ++i) {
                    DefaultMutableTreeNode n1 = (DefaultMutableTreeNode)allNodes.get(i);
                    tm1 = (ToolboxMarker)n1.getUserObject();
                    if (tm1.getParent() == null || tm1.getParent().equals(this.recordMarker)) {
                        this.rootNode.add(n1);
                        continue;
                    }
                    for (int j = 0; j < allNodes.size(); ++j) {
                        if (j == i) continue;
                        DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)allNodes.get(j);
                        tm2 = (ToolboxMarker)n2.getUserObject();
                        if (!tm1.getParent().equals(tm2.getMarker())) continue;
                        n2.add(n1);
                        continue block8;
                    }
                }
                this.fillParentMap();
            }
            catch (IOException ioe) {
                ServerLogger.LOG.warning("Read error: " + ioe.getMessage());
            }
        }
        catch (FileNotFoundException fne) {
            ServerLogger.LOG.warning("No file: " + fne.getMessage());
        }
    }

    private void initializeFromMarkerRecords(List markerRecords) {
        DefaultMutableTreeNode n1;
        int i;
        ToolboxMarker tm1;
        MarkerRecord mr2 = null;
        ArrayList<DefaultMutableTreeNode> allNodes = new ArrayList<DefaultMutableTreeNode>(markerRecords.size());
        int numRootTiers = 0;
        for (MarkerRecord mr2 : markerRecords) {
            if (mr2.getParentMarker() == null && !mr2.isExcluded()) {
                ++numRootTiers;
            }
            if (!mr2.isExcluded()) {
                this.includedMarkers.add(mr2.getMarker());
            }
            tm1 = new ToolboxMarker(mr2.getMarker());
            tm1.setParent(mr2.getParentMarker());
            if (mr2.getStereoType() != null && mr2.getStereoType().equals("Symbolic Association")) {
                tm1.setStereoType(4);
            } else if (mr2.getStereoType() != null && mr2.getStereoType().equals("Time Subdivision")) {
                tm1.setSubdivision(true);
                tm1.setStereoType(0);
            } else if (mr2.getStereoType() != null && mr2.getStereoType().equals("Included In")) {
                tm1.setSubdivision(true);
                tm1.setStereoType(1);
            } else if (mr2.getStereoType() != null && mr2.getStereoType().equals("Symbolic Subdivision")) {
                tm1.setSubdivision(true);
                tm1.setStereoType(3);
            }
            if (mr2.getParticipantMarker()) {
                this.participantMarker = mr2.getMarker();
                mr2.setStereoType("Symbolic Association");
            }
            allNodes.add(new DefaultMutableTreeNode(tm1));
        }
        if (numRootTiers == 1) {
            for (i = 0; i < allNodes.size(); ++i) {
                n1 = (DefaultMutableTreeNode)allNodes.get(i);
                tm1 = (ToolboxMarker)n1.getUserObject();
                if (tm1.getParent() != null) continue;
                this.recordMarker = tm1.getMarker();
                this.rootNode.setUserObject(tm1);
                break;
            }
        } else {
            this.recordMarker = null;
        }
        if (this.recordMarker == null) {
            // empty if block
        }
        block2: for (i = 0; i < allNodes.size(); ++i) {
            n1 = (DefaultMutableTreeNode)allNodes.get(i);
            tm1 = (ToolboxMarker)n1.getUserObject();
            if (tm1.getParent() == null || tm1.getParent().equals(this.recordMarker)) {
                this.rootNode.add(n1);
                continue;
            }
            for (int j = 0; j < allNodes.size(); ++j) {
                if (j == i) continue;
                DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)allNodes.get(j);
                ToolboxMarker tm2 = (ToolboxMarker)n2.getUserObject();
                if (!tm1.getParent().equals(tm2.getMarker())) continue;
                n2.add(n1);
                continue block2;
            }
        }
        this.fillParentMap();
    }
}

