/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Interlinearizer;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;

public class Metrics {
    private TimeCodedTranscription transcription;
    private Interlinearizer interlinearizer;
    private Hashtable sizeTable;
    private Hashtable usedWidthTable;
    private Hashtable horizontalPositions;
    private Hashtable verticalPositions;
    private Hashtable tierHeights;
    private Vector blockWiseOrdered;
    private Vector verticallyOrdered;
    private int leftMargin;
    private boolean leftMarginOn = false;

    public Metrics(TimeCodedTranscription tr, Interlinearizer interlinearizer) {
        this.transcription = tr;
        this.interlinearizer = interlinearizer;
        this.sizeTable = new Hashtable();
        this.usedWidthTable = new Hashtable();
        this.horizontalPositions = new Hashtable();
        this.verticalPositions = new Hashtable();
        this.tierHeights = new Hashtable();
    }

    public void reset() {
        this.sizeTable.clear();
        this.usedWidthTable.clear();
        this.horizontalPositions.clear();
        this.verticalPositions.clear();
        this.tierHeights.clear();
        this.blockWiseOrdered = null;
        this.verticallyOrdered = null;
    }

    public void setSize(Annotation annot, int size) {
        this.sizeTable.put(annot, new Integer(size));
    }

    public int getSize(Annotation annot) {
        int size = 0;
        Integer intSize = (Integer)this.sizeTable.get(annot);
        if (intSize != null) {
            size = intSize;
        }
        return size;
    }

    public void setUsedWidth(Annotation annot, int width) {
        this.usedWidthTable.put(annot, new Integer(width));
    }

    public int getUsedWidth(Annotation annot) {
        int usedWidth = 0;
        Integer intWidth = (Integer)this.usedWidthTable.get(annot);
        if (intWidth != null) {
            usedWidth = intWidth;
        }
        return usedWidth;
    }

    public void setHorizontalPosition(Annotation annot, int hPos) {
        this.horizontalPositions.put(annot, new Integer(hPos));
    }

    public int getHorizontalPosition(Annotation annot) {
        int hPos = 0;
        Integer intHPos = (Integer)this.horizontalPositions.get(annot);
        if (intHPos != null) {
            hPos = intHPos;
        }
        return hPos;
    }

    public void setVerticalPosition(Annotation annot, int vPos) {
        this.verticalPositions.put(annot, new Integer(vPos));
    }

    public void setVerticalPosition(Annotation annot) {
        int vPos = 0;
        String tierName = annot.getTier().getName();
        String[] visibleTiers = this.getInterlinearizer().getVisibleTiers();
        for (int i = 0; i < visibleTiers.length; ++i) {
            if (tierName.equals(visibleTiers[i])) {
                vPos += this.getTierHeight(visibleTiers[i]);
                break;
            }
            vPos += this.getTierHeight(visibleTiers[i]) + this.getInterlinearizer().getLineSpacing();
        }
        this.verticalPositions.put(annot, new Integer(vPos));
    }

    public int getVerticalPosition(Annotation annot) {
        int vPos = 0;
        Integer intVPos = (Integer)this.verticalPositions.get(annot);
        if (intVPos != null) {
            vPos = intVPos;
        }
        return vPos;
    }

    public int getMaxVerticalPosition() {
        int maxPosition = 0;
        Collection c = this.verticalPositions.values();
        Iterator cIter = c.iterator();
        while (cIter.hasNext()) {
            int vPos = (Integer)cIter.next();
            if (vPos <= maxPosition) continue;
            maxPosition = vPos;
        }
        return maxPosition;
    }

    public int getMaxHorizontallyUsedWidth() {
        int maxHUsed = 0;
        int hpos = 0;
        int usedWidth = 0;
        Annotation a = null;
        Enumeration en = this.horizontalPositions.keys();
        while (en.hasMoreElements()) {
            a = (Annotation)en.nextElement();
            hpos = (Integer)this.horizontalPositions.get(a);
            if (hpos + (usedWidth = ((Integer)this.usedWidthTable.get(a)).intValue()) <= maxHUsed) continue;
            maxHUsed = hpos + usedWidth;
        }
        return maxHUsed + this.getLeftMargin();
    }

    public void setTierHeight(String tierName, int tierHeight) {
        this.tierHeights.put(tierName, new Integer(tierHeight));
    }

    public int getTierHeight(String forTier) {
        Integer i = (Integer)this.tierHeights.get(forTier);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public int getCumulativeTierHeights() {
        int totalHeight = 0;
        Collection heights = this.tierHeights.values();
        Iterator hIter = heights.iterator();
        while (hIter.hasNext()) {
            totalHeight += ((Integer)hIter.next()).intValue();
        }
        int numOfVisibleTiers = this.getInterlinearizer().getVisibleTiers().length;
        return totalHeight += numOfVisibleTiers * this.getInterlinearizer().getLineSpacing();
    }

    public Vector getPositionsOfNonEmptyTiers() {
        Collection c = this.verticalPositions.values();
        return new Vector(new HashSet(c));
    }

    public String getTierLabelAt(int position) {
        String label = null;
        Annotation a = null;
        Enumeration en = this.verticalPositions.keys();
        while (en.hasMoreElements()) {
            a = (Annotation)en.nextElement();
            if ((Integer)this.verticalPositions.get(a) != position) continue;
            label = a.getTier().getName();
            break;
        }
        return label;
    }

    public int[] getVPositionsInTemplate() {
        int[] vPositions = new int[this.getInterlinearizer().getVisibleTiers().length];
        int lineSpacing = this.getInterlinearizer().getLineSpacing();
        int positionInTemplate = 0;
        String[] vTierNames = this.getInterlinearizer().getVisibleTiers();
        for (int index = 0; index < vTierNames.length; ++index) {
            int tierHeight = this.getTierHeight(vTierNames[index]);
            vPositions[index] = positionInTemplate += tierHeight;
            positionInTemplate += lineSpacing;
        }
        return vPositions;
    }

    public TimeCodedTranscription getTranscription() {
        return this.transcription;
    }

    public Interlinearizer getInterlinearizer() {
        return this.interlinearizer;
    }

    public int getLeftMargin() {
        if (this.leftMarginOn) {
            return this.leftMargin;
        }
        return 0;
    }

    public void setLeftMargin(int i) {
        if (this.leftMarginOn) {
            this.leftMargin = i;
        }
    }

    public void showLeftMargin(boolean show) {
        this.leftMarginOn = show;
    }

    public boolean leftMarginShown() {
        return this.leftMarginOn;
    }

    public Vector getBlockWiseOrdered() {
        if (this.blockWiseOrdered == null) {
            this.blockWiseOrdered = new Vector();
            Set allAnnots = this.sizeTable.keySet();
            String[] visibleTiers = this.getInterlinearizer().getVisibleTiers();
            List<String> vTierList = Arrays.asList(visibleTiers);
            for (Annotation a : allAnnots) {
                if (!vTierList.contains(a.getTier().getName())) continue;
                this.blockWiseOrdered.add(a);
            }
            Collections.sort(this.blockWiseOrdered, new AnnotationComparator());
        }
        return this.blockWiseOrdered;
    }

    public Vector getVerticallyOrdered() {
        if (this.verticallyOrdered == null) {
            this.verticallyOrdered = new Vector();
            Set allAnnots = this.sizeTable.keySet();
            String[] visibleTiers = this.getInterlinearizer().getVisibleTiers();
            List<String> vTierList = Arrays.asList(visibleTiers);
            for (Annotation a : allAnnots) {
                if (!vTierList.contains(a.getTier().getName())) continue;
                this.verticallyOrdered.add(a);
            }
            Collections.sort(this.verticallyOrdered, new AnnotComparatorOnVPos());
        }
        return this.verticallyOrdered;
    }

    public int[] getPageBoundaries(int pageHeight) {
        int[] pageBoundaries = null;
        boolean pageCounter = false;
        int lastPageBreak = 0;
        Vector<Integer> boundaries = new Vector<Integer>();
        Vector vPosIntegers = null;
        int[] tierLblVPositions = null;
        vPosIntegers = this.getPositionsOfNonEmptyTiers();
        Collections.sort(vPosIntegers);
        tierLblVPositions = new int[vPosIntegers.size()];
        for (int i = 0; i < vPosIntegers.size(); ++i) {
            tierLblVPositions[i] = (Integer)vPosIntegers.elementAt(i);
        }
        for (int k = 0; k < tierLblVPositions.length; ++k) {
            if (tierLblVPositions[k] <= lastPageBreak + pageHeight || k <= 0) continue;
            lastPageBreak = tierLblVPositions[k - 1];
            boundaries.add(new Integer(lastPageBreak));
        }
        pageBoundaries = new int[boundaries.size()];
        for (int m = 0; m < boundaries.size(); ++m) {
            pageBoundaries[m] = (Integer)boundaries.elementAt(m);
        }
        return pageBoundaries;
    }

    public int[] getPageBoundaries(int pageIndex, int pageHeight) {
        int pageCounter = 0;
        int lastPageBreak = 0;
        int[] boundaries = new int[]{0, 0};
        Vector vPosIntegers = null;
        int[] tierLblVPositions = null;
        vPosIntegers = this.getPositionsOfNonEmptyTiers();
        Collections.sort(vPosIntegers);
        tierLblVPositions = new int[vPosIntegers.size()];
        for (int i = 0; i < vPosIntegers.size(); ++i) {
            tierLblVPositions[i] = (Integer)vPosIntegers.elementAt(i);
        }
        for (int k = 0; k < tierLblVPositions.length; ++k) {
            if (tierLblVPositions[k] > lastPageBreak + pageHeight) {
                if (pageCounter == pageIndex) break;
                if (k > 0) {
                    lastPageBreak = tierLblVPositions[k - 1];
                }
                ++pageCounter;
            }
            boundaries[0] = lastPageBreak;
            boundaries[1] = tierLblVPositions[k];
        }
        if (pageIndex > pageCounter) {
            boundaries[0] = 0;
            boundaries[1] = 0;
        }
        return boundaries;
    }

    class AnnotComparatorOnVPos
    implements Comparator {
        AnnotComparatorOnVPos() {
        }

        public int compare(Object arg0, Object arg1) {
            int vpos1;
            Annotation a0 = (Annotation)arg0;
            Annotation a1 = (Annotation)arg1;
            int vpos0 = (Integer)Metrics.this.verticalPositions.get(a0);
            if (vpos0 < (vpos1 = ((Integer)Metrics.this.verticalPositions.get(a1)).intValue())) {
                return -1;
            }
            if (vpos0 >= vpos1) {
                return 1;
            }
            return 0;
        }
    }

    class AnnotationComparator
    implements Comparator {
        AnnotationComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            int hpos1;
            Annotation a0 = (Annotation)arg0;
            Annotation a1 = (Annotation)arg1;
            int hpos0 = (Integer)Metrics.this.horizontalPositions.get(a0);
            if (hpos0 < (hpos1 = ((Integer)Metrics.this.horizontalPositions.get(a1)).intValue())) {
                return -1;
            }
            if (hpos0 > hpos1) {
                return 1;
            }
            if (hpos0 == hpos1) {
                if (Metrics.this.transcription.isAncestorOf(a1.getTier(), a0.getTier())) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }
}

