/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.util.TimeFormatter;

public class TimeCodedTranscriptionImpl
implements TimeCodedTranscription {
    private TranscriptionImpl wrappedTranscription;
    private Vector timeCodeTiers = null;
    private int tcTierCounter = 0;
    private LinguisticType tcLingType;
    private Hashtable rootTiers;
    private Hashtable tcChildAnnots;

    public TimeCodedTranscriptionImpl(TranscriptionImpl trImpl) {
        this.wrappedTranscription = trImpl;
        this.timeCodeTiers = new Vector();
        this.rootTiers = new Hashtable();
        this.tcChildAnnots = new Hashtable();
        this.tcLingType = new LinguisticType("12nov2004_temp$LING$type");
        this.tcLingType.setTimeAlignable(false);
        this.tcLingType.setGraphicReferences(false);
        this.tcLingType.addConstraint(new SymbolicAssociation());
    }

    public Transcription getTranscription() {
        return this.wrappedTranscription;
    }

    public Vector getTiers() {
        Vector tiers = this.wrappedTranscription.getTiers();
        Vector allTiers = new Vector(tiers);
        if (this.timeCodeTiers != null) {
            allTiers.addAll(this.timeCodeTiers);
        }
        return allTiers;
    }

    public Vector getChildAnnotationsOf(Annotation theAnnot) {
        Vector<Annotation> childAnnots = new Vector<Annotation>(this.wrappedTranscription.getChildAnnotationsOf(theAnnot));
        Annotation child = (Annotation)this.tcChildAnnots.get(theAnnot);
        if (child != null) {
            childAnnots.add(child);
        }
        return childAnnots;
    }

    public TierImpl getParentTier(Tier theTier) {
        TierImpl parentTier = null;
        if (theTier != null) {
            parentTier = this.timeCodeTiers.contains(theTier) ? (TierImpl)this.rootTiers.get(theTier) : (TierImpl)((TierImpl)theTier).getParentTier();
        }
        return parentTier;
    }

    public TierImpl getRootTier(Tier forTier) {
        TierImpl rootTier = null;
        if (forTier != null) {
            rootTier = this.timeCodeTiers.contains(forTier) ? (TierImpl)this.rootTiers.get(forTier) : ((TierImpl)forTier).getRootTier();
        }
        return rootTier;
    }

    public boolean isAncestorOf(Tier tier1, Tier tier2) {
        boolean ancestor = false;
        TierImpl parentTier = this.getParentTier(tier2);
        if (parentTier != null) {
            ancestor = parentTier == tier1 ? true : this.isAncestorOf(tier1, parentTier);
        }
        return ancestor;
    }

    public Vector getTierTree(TierImpl tier) {
        Vector<TierImpl> tierTree = new Vector<TierImpl>();
        Vector children = tier.getChildTiers();
        tierTree.add(tier);
        for (int j = 0; j < children.size(); ++j) {
            TierImpl child = (TierImpl)children.elementAt(j);
            tierTree.addAll(this.getTierTree(child));
        }
        for (int i = 0; i < this.timeCodeTiers.size(); ++i) {
            TierImpl tcTier = (TierImpl)this.timeCodeTiers.elementAt(i);
            if (this.rootTiers.get(tcTier) != tier) continue;
            tierTree.add(tcTier);
        }
        return tierTree;
    }

    public void prepareTimeCodeRendering(int timeCodeStyle, boolean correctAnnotationTimes) {
        this.cleanupTimeCodeTiers();
        this.addTimeCodeTiers(timeCodeStyle, correctAnnotationTimes);
    }

    public void cleanupTimeCodeTiers() {
        this.timeCodeTiers.clear();
        this.rootTiers.clear();
        this.tcChildAnnots.clear();
        this.tcTierCounter = 0;
    }

    private void addTimeCodeTiers(int timeCodeStyle, boolean correctAnnotationTimes) {
        Vector mds;
        long offset = 0L;
        if (correctAnnotationTimes && (mds = this.wrappedTranscription.getMediaDescriptors()) != null && mds.size() > 0) {
            offset = ((MediaDescriptor)mds.get((int)0)).timeOrigin;
        }
        Vector topTiers = this.wrappedTranscription.getTopTiers();
        for (int i = 0; i < topTiers.size(); ++i) {
            TierImpl topT = (TierImpl)topTiers.elementAt(i);
            this.timeCodeTiers.add(this.addTCTierFor(topT, timeCodeStyle, offset));
        }
    }

    private Tier addTCTierFor(TierImpl tier, int timeCodeStyle, long mediaOffset) {
        TierImpl newTier = null;
        String newTierName = "TC-" + this.tcTierCounter++;
        newTier = new TierImpl(null, newTierName, null, null, null);
        newTier.setLinguisticType(this.tcLingType);
        Vector annots = tier.getAnnotations();
        for (int i = 0; i < annots.size(); ++i) {
            Annotation parentAnn = (Annotation)annots.elementAt(i);
            RefAnnotation newAnnot = new RefAnnotation(null, newTier);
            newAnnot.getReferences().add(parentAnn);
            newTier.addAnnotation(newAnnot);
            long bl = -1L;
            long el = -1L;
            if (parentAnn instanceof AlignableAnnotation && ((AlignableAnnotation)parentAnn).getBegin().isTimeAligned()) {
                bl = parentAnn.getBeginTimeBoundary() + mediaOffset;
            }
            if (parentAnn instanceof AlignableAnnotation && ((AlignableAnnotation)parentAnn).getEnd().isTimeAligned()) {
                el = parentAnn.getEndTimeBoundary() + mediaOffset;
            }
            String value = "";
            if (timeCodeStyle == 0) {
                String beginStr = "??:??:??:???";
                if (bl != -1L) {
                    beginStr = TimeFormatter.toString(bl);
                }
                String endStr = "??:??:??:???";
                if (el != -1L) {
                    endStr = TimeFormatter.toString(el);
                }
                value = beginStr + " - " + endStr;
            } else {
                double bd = (double)bl / 1000.0;
                double ed = (double)el / 1000.0;
                DecimalFormat ssmmm = new DecimalFormat("#0.000", new DecimalFormatSymbols(Locale.US));
                String bs = "?.???";
                if (bl != -1L) {
                    bs = ssmmm.format(bd);
                }
                String es = "?.???";
                if (el != -1L) {
                    es = ssmmm.format(ed);
                }
                value = bs + " - " + es;
            }
            newAnnot.setValue(value);
            this.tcChildAnnots.put(parentAnn, newAnnot);
        }
        this.rootTiers.put(newTier, tier);
        return newTier;
    }

    public Vector getTimeCodeTiers() {
        return this.timeCodeTiers;
    }
}

