/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;

public class NoTimeGapWithinParent
extends ConstraintImpl {
    public int getStereoType() {
        return 2;
    }

    public Vector getTimeSlotsForNewAnnotation(long begin, long end, Tier forTier) {
        AlignableAnnotation currAnn;
        Vector<TimeSlot> slots = new Vector<TimeSlot>();
        TierImpl parentTier = (TierImpl)((TierImpl)forTier).getParentTier();
        if (parentTier == null) {
            return slots;
        }
        AlignableAnnotation parentAnn = (AlignableAnnotation)parentTier.getAnnotationAtTime(begin, true);
        if (parentAnn == null) {
            return slots;
        }
        if (parentAnn.getBegin().isTimeAligned() && begin < parentAnn.getBegin().getTime()) {
            begin = parentAnn.getBegin().getTime();
        }
        if (parentAnn.getEnd().isTimeAligned() && end > parentAnn.getEnd().getTime()) {
            end = parentAnn.getEnd().getTime();
        }
        boolean insertAtParentEnd = false;
        if (parentAnn.getEnd().getTime() == end) {
            insertAtParentEnd = true;
        }
        if ((currAnn = (AlignableAnnotation)((TierImpl)forTier).getAnnotationAtTime(begin, true)) == null) {
            slots.add(parentAnn.getBegin());
            slots.add(parentAnn.getEnd());
            return slots;
        }
        if (!parentAnn.getBegin().isTimeAligned() || !parentAnn.getEnd().isTimeAligned()) {
            return slots;
        }
        boolean multiOverlappingAnns = false;
        AlignableAnnotation currEndAnn = null;
        currEndAnn = insertAtParentEnd ? (AlignableAnnotation)((TierImpl)forTier).getAnnotationAtTime(end - 1L, true) : (AlignableAnnotation)((TierImpl)forTier).getAnnotationAtTime(end, true);
        if (currEndAnn != null && currEndAnn != currAnn && end != currAnn.getEnd().getTime()) {
            multiOverlappingAnns = true;
        }
        if (!multiOverlappingAnns && begin != currAnn.getBegin().getTime() && end < currAnn.getEnd().getTime()) {
            end = currAnn.getEnd().getTime();
        }
        TimeOrder timeOrder = ((TranscriptionImpl)forTier.getParent()).getTimeOrder();
        Vector childTiers = ((TierImpl)forTier).getChildTiers();
        TimeSlot bts = null;
        TimeSlot ets = null;
        boolean coincidingBegin = false;
        boolean coincidingEnd = false;
        if (begin == currAnn.getBegin().getTime()) {
            coincidingBegin = true;
        }
        if (currEndAnn != null && (currEndAnn.getBegin().getTime() == end || currEndAnn.getEnd().getTime() == end)) {
            coincidingEnd = true;
        }
        bts = currAnn.getBegin();
        ets = currAnn.getEnd();
        if (!coincidingBegin || end != currAnn.getEnd().getTime()) {
            if (coincidingBegin) {
                if (!multiOverlappingAnns) {
                    ets = new TimeSlotImpl(end, timeOrder);
                    timeOrder.insertTimeSlot(ets, bts, currAnn.getEnd());
                    for (int i = 0; i < childTiers.size(); ++i) {
                        TierImpl nextT = (TierImpl)childTiers.get(i);
                        if (!nextT.isTimeAlignable()) continue;
                        this.setAlignableBeginSlot(nextT, currAnn, ets, end);
                    }
                    currAnn.setBegin(ets);
                } else if (!insertAtParentEnd) {
                    AlignableAnnotation naa;
                    ets = new TimeSlotImpl(end, timeOrder);
                    TimeSlot oldBeginTS = currEndAnn.getBegin();
                    if (!oldBeginTS.isTimeAligned() && (naa = this.getFirstAlignedAnnotation((TierImpl)forTier, currEndAnn)) != null) {
                        currEndAnn = naa;
                        oldBeginTS = currEndAnn.getBegin();
                    }
                    timeOrder.insertTimeSlot(ets, currEndAnn.getBegin(), currEndAnn.getEnd());
                    for (int i = 0; i < childTiers.size(); ++i) {
                        TierImpl nextT = (TierImpl)childTiers.get(i);
                        if (!nextT.isTimeAlignable()) continue;
                        this.setAlignableBeginSlot(nextT, currEndAnn, ets, end);
                    }
                    currEndAnn.setBegin(ets);
                } else {
                    ets = parentAnn.getEnd();
                }
            } else {
                TierImpl nextT;
                bts = new TimeSlotImpl(begin, timeOrder);
                TimeSlot oldEndTS = currAnn.getEnd();
                timeOrder.insertTimeSlot(bts, currAnn.getBegin(), ets);
                if (multiOverlappingAnns) {
                    Vector nx = ((TierImpl)forTier).getAnnotsBeginningAtTimeSlot(oldEndTS);
                    for (int j = 0; j < nx.size(); ++j) {
                        AlignableAnnotation nextAA = (AlignableAnnotation)nx.get(j);
                        if (!parentAnn.getParentListeners().contains(nextAA)) continue;
                        for (int i = 0; i < childTiers.size(); ++i) {
                            nextT = (TierImpl)childTiers.get(i);
                            if (!nextT.isTimeAlignable()) continue;
                        }
                        nextAA.setBegin(bts);
                    }
                }
                for (int i = 0; i < childTiers.size(); ++i) {
                    nextT = (TierImpl)childTiers.get(i);
                    if (!nextT.isTimeAlignable()) continue;
                    this.setAlignableEndSlot(nextT, currAnn, bts, ets, begin, end);
                }
                currAnn.setEnd(bts);
                if (multiOverlappingAnns) {
                    if (coincidingEnd) {
                        ets = insertAtParentEnd ? parentAnn.getEnd() : currEndAnn.getBegin();
                    } else {
                        AlignableAnnotation naa;
                        ets = new TimeSlotImpl(end, timeOrder);
                        TimeSlot oldBeginTS = currEndAnn.getBegin();
                        if (!oldBeginTS.isTimeAligned() && (naa = this.getFirstAlignedAnnotation((TierImpl)forTier, currEndAnn)) != null) {
                            currEndAnn = naa;
                            oldBeginTS = currEndAnn.getBegin();
                        }
                        timeOrder.insertTimeSlot(ets, currEndAnn.getBegin(), currEndAnn.getEnd());
                        for (int i = 0; i < childTiers.size(); ++i) {
                            nextT = (TierImpl)childTiers.get(i);
                            if (!nextT.isTimeAlignable()) continue;
                            this.setAlignableBeginSlot(nextT, currEndAnn, ets, end);
                        }
                        currEndAnn.setBegin(ets);
                    }
                }
            }
        }
        slots.add(bts);
        slots.add(ets);
        return slots;
    }

    public void enforceOnWholeTier(Tier theTier) {
        Tier parentTier = ((TierImpl)theTier).getParentTier();
        if (parentTier != null) {
            Vector parentAnnots = null;
            parentAnnots = ((TierImpl)parentTier).getAnnotations();
            for (AlignableAnnotation parent : parentAnnots) {
                Vector enclosedAnnots = ((TierImpl)theTier).getOverlappingAnnotations(parent.getBegin(), parent.getEnd());
                Iterator annIter = enclosedAnnots.iterator();
                AlignableAnnotation previousAnn = null;
                while (annIter.hasNext()) {
                    AlignableAnnotation a = (AlignableAnnotation)annIter.next();
                    if (previousAnn == null) {
                        a.setBegin(parent.getBegin());
                    } else {
                        previousAnn.setEnd(a.getBegin());
                    }
                    previousAnn = a;
                }
                if (previousAnn == null) continue;
                previousAnn.setEnd(parent.getEnd());
            }
            TimeOrder timeOrder = ((TranscriptionImpl)theTier.getParent()).getTimeOrder();
            timeOrder.pruneTimeSlots();
        }
    }

    public boolean supportsInsertion() {
        return true;
    }

    public Annotation insertBefore(Annotation beforeAnn, Tier theTier) {
        AlignableAnnotation a = null;
        AlignableAnnotation beforeA = (AlignableAnnotation)beforeAnn;
        TimeOrder timeOrder = ((TranscriptionImpl)theTier.getParent()).getTimeOrder();
        TimeSlotImpl newTs = new TimeSlotImpl(timeOrder);
        timeOrder.insertTimeSlot(newTs, beforeA.getBegin(), beforeA.getEnd());
        a = ((TierImpl)theTier).getLinguisticType().hasGraphicReferences() ? new SVGAlignableAnnotation(beforeA.getBegin(), newTs, theTier, null) : new AlignableAnnotation(beforeA.getBegin(), newTs, theTier);
        Annotation parentAnn = beforeAnn.getParentAnnotation();
        Vector beginningAtTs = ((TranscriptionImpl)theTier.getParent()).getAnnotsBeginningAtTimeSlot(beforeA.getBegin(), theTier, true);
        if (beginningAtTs.contains(parentAnn)) {
            beginningAtTs.remove(parentAnn);
        }
        Vector depTiers = ((TierImpl)theTier).getDependentTiers();
        for (int i = 0; i < beginningAtTs.size(); ++i) {
            AlignableAnnotation other = (AlignableAnnotation)beginningAtTs.elementAt(i);
            if (other.getTier() != theTier && !depTiers.contains(other.getTier())) continue;
            other.setBegin(newTs);
        }
        ((TierImpl)theTier).addAnnotation(a);
        return a;
    }

    public Annotation insertAfter(Annotation afterAnn, Tier theTier) {
        AlignableAnnotation a = null;
        AlignableAnnotation afterA = (AlignableAnnotation)afterAnn;
        TimeOrder timeOrder = ((TranscriptionImpl)theTier.getParent()).getTimeOrder();
        TimeSlotImpl newTs = new TimeSlotImpl(timeOrder);
        TimeSlot highestATS = null;
        ArrayList pls = afterA.getParentListeners();
        for (int i = 0; i < pls.size(); ++i) {
            TimeSlot ts;
            Annotation loopA = (Annotation)pls.get(i);
            if (!(loopA instanceof AlignableAnnotation) || !(ts = ((AlignableAnnotation)loopA).getBegin()).isTimeAligned() || highestATS != null && ts.getTime() <= highestATS.getTime()) continue;
            highestATS = ts;
        }
        if (highestATS == null) {
            timeOrder.insertTimeSlot(newTs, afterA.getBegin(), afterA.getEnd());
        } else {
            timeOrder.insertTimeSlot(newTs, highestATS, afterA.getEnd());
        }
        a = ((TierImpl)theTier).getLinguisticType().hasGraphicReferences() ? new SVGAlignableAnnotation(newTs, afterA.getEnd(), theTier, null) : new AlignableAnnotation(newTs, afterA.getEnd(), theTier);
        Annotation parentAnn = afterAnn.getParentAnnotation();
        Vector endingAtTs = ((TranscriptionImpl)theTier.getParent()).getAnnotsEndingAtTimeSlot(afterA.getEnd(), theTier, true);
        if (endingAtTs.contains(parentAnn)) {
            endingAtTs.remove(parentAnn);
        }
        Vector depTiers = ((TierImpl)theTier).getDependentTiers();
        for (int i = 0; i < endingAtTs.size(); ++i) {
            AlignableAnnotation other = (AlignableAnnotation)endingAtTs.elementAt(i);
            if (other.getTier() != theTier && !depTiers.contains(other.getTier())) continue;
            other.setEnd(newTs);
        }
        ((TierImpl)theTier).addAnnotation(a);
        a.registerWithParent();
        return a;
    }

    public void detachAnnotation(Annotation theAnn, Tier theTier) {
        block8: {
            AbstractAnnotation next;
            AlignableAnnotation a;
            block9: {
                a = (AlignableAnnotation)theAnn;
                Annotation parent = a.getParentAnnotation();
                Vector<Annotation> enclosedAnnots = new Vector<Annotation>();
                Vector childAnnots = new Vector();
                if (parent != null) {
                    childAnnots = ((TranscriptionImpl)theTier.getParent()).getChildAnnotationsOf(parent);
                }
                for (Annotation ann : childAnnots) {
                    if (ann.getTier() != theTier) continue;
                    enclosedAnnots.add(ann);
                }
                if (enclosedAnnots.size() <= 0) break block8;
                AbstractAnnotation prev = null;
                next = null;
                int index = enclosedAnnots.indexOf(a);
                if (index > 0) {
                    prev = (AlignableAnnotation)enclosedAnnots.get(index - 1);
                }
                if (index > -1 && index < enclosedAnnots.size() - 1) {
                    next = (AlignableAnnotation)enclosedAnnots.get(index + 1);
                }
                if (prev == null) break block9;
                if (prev.isMarkedDeleted()) {
                    return;
                }
                Vector endingAtTs = ((TranscriptionImpl)theTier.getParent()).getAnnotsEndingAtTimeSlot(((AlignableAnnotation)prev).getEnd(), theTier, true);
                for (int i = 0; i < endingAtTs.size(); ++i) {
                    ((AlignableAnnotation)endingAtTs.elementAt(i)).setEnd(a.getEnd());
                }
                break block8;
            }
            if (next == null) break block8;
            if (next.isMarkedDeleted()) {
                // empty if block
            }
            Vector beginningAtTs = ((TranscriptionImpl)theTier.getParent()).getAnnotsBeginningAtTimeSlot(((AlignableAnnotation)next).getBegin(), theTier, true);
            for (int i = 0; i < beginningAtTs.size(); ++i) {
                ((AlignableAnnotation)beginningAtTs.elementAt(i)).setBegin(a.getBegin());
            }
        }
    }

    private void setAlignableBeginSlot(TierImpl nextT, AlignableAnnotation parentAA, TimeSlot ets, long end) {
        block8: {
            Vector childT;
            AlignableAnnotation nextAA;
            block9: {
                block10: {
                    if (parentAA == null) {
                        return;
                    }
                    if (nextT.getLinguisticType().getConstraints().getStereoType() == 1) {
                        return;
                    }
                    nextAA = (AlignableAnnotation)nextT.getAnnotationAtTime(end);
                    childT = nextT.getChildTiers();
                    if (nextAA == null) break block9;
                    if (!nextAA.getBegin().isTimeAligned()) break block10;
                    if (!parentAA.getParentListeners().contains(nextAA)) break block8;
                    for (int i = 0; i < childT.size(); ++i) {
                        TierImpl ch = (TierImpl)childT.get(i);
                        if (!ch.isTimeAlignable()) continue;
                        this.setAlignableBeginSlot(ch, nextAA, ets, end);
                    }
                    nextAA.setBegin(ets);
                    break block8;
                }
                boolean found = false;
                while (!found) {
                    Vector annos = nextT.getAnnotsEndingAtTimeSlot(nextAA.getBegin());
                    for (int j = 0; j < annos.size(); ++j) {
                        nextAA = (AlignableAnnotation)annos.get(j);
                        if (!nextAA.getBegin().isTimeAligned() && parentAA.getBegin() != nextAA.getBegin() || !parentAA.getParentListeners().contains(nextAA)) continue;
                        for (int i = 0; i < childT.size(); ++i) {
                            TierImpl ch = (TierImpl)childT.get(i);
                            if (!ch.isTimeAlignable()) continue;
                            this.setAlignableBeginSlot(ch, nextAA, ets, end);
                        }
                        nextAA.setBegin(ets);
                        found = true;
                    }
                    if (annos.size() != 0) continue;
                    break block8;
                }
                break block8;
            }
            Vector ba = nextT.getAnnotsBeginningAtTimeSlot(parentAA.getBegin());
            for (int j = 0; j < ba.size(); ++j) {
                nextAA = (AlignableAnnotation)ba.get(j);
                for (int i = 0; i < childT.size(); ++i) {
                    TierImpl ch = (TierImpl)childT.get(i);
                    if (!ch.isTimeAlignable()) continue;
                    this.setAlignableBeginSlot(ch, nextAA, ets, end);
                }
                nextAA.setBegin(ets);
            }
        }
    }

    private void setAlignableEndSlot(TierImpl nextT, AlignableAnnotation parentAA, TimeSlot bts, TimeSlot ets, long begin, long end) {
        block10: {
            Vector childT;
            AlignableAnnotation nextAA;
            block11: {
                TimeSlot oldEndTS;
                block12: {
                    if (parentAA == null) {
                        return;
                    }
                    if (nextT.getLinguisticType().getConstraints().getStereoType() == 1) {
                        return;
                    }
                    nextAA = (AlignableAnnotation)nextT.getAnnotationAtTime(begin);
                    childT = nextT.getChildTiers();
                    if (nextAA == null) break block10;
                    if (nextAA.getBegin().getTime() == begin) break block11;
                    oldEndTS = nextAA.getEnd();
                    if (!nextAA.getEnd().isTimeAligned() && nextAA.getEnd() != parentAA.getEnd()) break block12;
                    for (int i = 0; i < childT.size(); ++i) {
                        TierImpl ch = (TierImpl)childT.get(i);
                        if (!ch.isTimeAlignable()) continue;
                        this.setAlignableEndSlot(ch, nextAA, bts, ets, begin, end);
                    }
                    nextAA.setEnd(bts);
                    if (oldEndTS == ets && oldEndTS.getTime() >= end) break block10;
                    Vector vv = nextT.getAnnotsBeginningAtTimeSlot(oldEndTS);
                    for (int j = 0; j < vv.size(); ++j) {
                        nextAA = (AlignableAnnotation)vv.get(j);
                        nextAA.setBegin(bts);
                    }
                    break block10;
                }
                boolean found = false;
                while (!found) {
                    Vector annos = nextT.getAnnotsBeginningAtTimeSlot(nextAA.getEnd());
                    for (int j = 0; j < annos.size(); ++j) {
                        nextAA = (AlignableAnnotation)annos.get(j);
                        oldEndTS = nextAA.getEnd();
                        if (!nextAA.getEnd().isTimeAligned()) continue;
                        for (int i = 0; i < childT.size(); ++i) {
                            TierImpl ch = (TierImpl)childT.get(i);
                            if (!ch.isTimeAlignable()) continue;
                            this.setAlignableEndSlot(ch, nextAA, bts, ets, begin, end);
                        }
                        nextAA.setEnd(bts);
                        found = true;
                        if (oldEndTS == ets && oldEndTS.getTime() >= end) continue;
                        Vector vv = nextT.getAnnotsBeginningAtTimeSlot(oldEndTS);
                        for (int k = 0; k < vv.size(); ++k) {
                            nextAA = (AlignableAnnotation)vv.get(k);
                            nextAA.setBegin(bts);
                        }
                    }
                    if (annos.size() != 0) continue;
                    break block10;
                }
                break block10;
            }
            TimeSlot oldBeginTS = nextAA.getBegin();
            for (int i = 0; i < childT.size(); ++i) {
                TierImpl ch = (TierImpl)childT.get(i);
                if (!ch.isTimeAlignable()) continue;
                this.setAlignableEndSlot(ch, nextAA, bts, ets, begin, end);
            }
            nextAA.setBegin(bts);
            Vector vv = nextT.getAnnotsEndingAtTimeSlot(oldBeginTS);
            for (int k = 0; k < vv.size(); ++k) {
                nextAA = (AlignableAnnotation)vv.get(k);
                nextAA.setEnd(bts);
            }
        }
    }

    private AlignableAnnotation getFirstAlignedAnnotation(TierImpl tier, AlignableAnnotation fromAnn) {
        AlignableAnnotation resAnn;
        block3: {
            if (tier == null || fromAnn == null) {
                return null;
            }
            resAnn = null;
            AlignableAnnotation loopAnn = fromAnn;
            Vector anns = null;
            do {
                anns = tier.getAnnotsEndingAtTimeSlot(loopAnn.getBegin());
                for (int i = 0; i < anns.size(); ++i) {
                    loopAnn = (AlignableAnnotation)anns.get(i);
                    if (loopAnn.getParentAnnotation() != fromAnn.getParentAnnotation()) break block3;
                    if (!loopAnn.getBegin().isTimeAligned()) continue;
                    resAnn = loopAnn;
                    break block3;
                }
                resAnn = loopAnn;
            } while (anns.size() != 0);
        }
        return resAnn;
    }
}

