/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;

public class SymbolicSubdivision
extends ConstraintImpl {
    public int getStereoType() {
        return 3;
    }

    public void forceTimes(long[] segment, Tier forTier) {
    }

    public long getBeginTimeForRefAnnotation(RefAnnotation theAnnot) {
        long[] segment = new long[]{0L, 0L};
        int[] elmtsLeftAndRight = new int[]{0, 0};
        this.getSegmentForChainOf(theAnnot, segment, elmtsLeftAndRight);
        long duration = segment[1] - segment[0];
        double durationPerAnnot = (double)duration / (double)(elmtsLeftAndRight[0] + elmtsLeftAndRight[1] + 1);
        return segment[0] + (long)((double)elmtsLeftAndRight[0] * durationPerAnnot);
    }

    public long getEndTimeForRefAnnotation(RefAnnotation theAnnot) {
        long[] segment = new long[]{0L, 0L};
        int[] elmtsLeftAndRight = new int[]{0, 0};
        this.getSegmentForChainOf(theAnnot, segment, elmtsLeftAndRight);
        long duration = segment[1] - segment[0];
        double durationPerAnnot = (double)duration / (double)(elmtsLeftAndRight[0] + elmtsLeftAndRight[1] + 1);
        return segment[0] + (long)((double)(elmtsLeftAndRight[0] + 1) * durationPerAnnot);
    }

    public boolean supportsInsertion() {
        return true;
    }

    public Annotation insertBefore(Annotation beforeAnn, Tier theTier) {
        Annotation parentAnn = (Annotation)((RefAnnotation)beforeAnn).getReferences().firstElement();
        RefAnnotation newAnn = new RefAnnotation(parentAnn, theTier);
        if (((RefAnnotation)beforeAnn).hasPrevious()) {
            RefAnnotation prevAnn = ((RefAnnotation)beforeAnn).getPrevious();
            prevAnn.setNext(newAnn);
        }
        newAnn.setNext((RefAnnotation)beforeAnn);
        ((TierImpl)theTier).addAnnotation(newAnn);
        return newAnn;
    }

    public Annotation insertAfter(Annotation afterAnn, Tier theTier) {
        Annotation parentAnn = (Annotation)((RefAnnotation)afterAnn).getReferences().firstElement();
        RefAnnotation newAnn = new RefAnnotation(parentAnn, theTier);
        if (((RefAnnotation)afterAnn).hasNext()) {
            RefAnnotation nextAnn = ((RefAnnotation)afterAnn).getNext();
            newAnn.setNext(nextAnn);
        }
        ((RefAnnotation)afterAnn).setNext(newAnn);
        ((TierImpl)theTier).addAnnotation(newAnn);
        return newAnn;
    }

    private void getSegmentForChainOf(RefAnnotation theAnnot, long[] segment, int[] elmtsLeftAndRight) {
        Vector refsOfLast;
        RefAnnotation firstOfChain = this.getFirstOfChain(theAnnot, elmtsLeftAndRight);
        RefAnnotation lastOfChain = this.getLastOfChain(theAnnot, elmtsLeftAndRight);
        Vector refsOfFirst = firstOfChain.getReferences();
        if (refsOfFirst.size() > 0) {
            Annotation beginRef = (Annotation)refsOfFirst.firstElement();
            segment[0] = beginRef.getBeginTimeBoundary();
        }
        if ((refsOfLast = lastOfChain.getReferences()).size() > 0) {
            Annotation endRef = (Annotation)lastOfChain.getReferences().firstElement();
            segment[1] = endRef.getEndTimeBoundary();
        }
    }

    private RefAnnotation getFirstOfChain(RefAnnotation theAnnot, int[] elmtsLeftAndRight) {
        RefAnnotation first = theAnnot;
        int leftElementCount = 0;
        while (first.hasPrevious()) {
            first = first.getPrevious();
            ++leftElementCount;
        }
        elmtsLeftAndRight[0] = leftElementCount;
        return first;
    }

    private RefAnnotation getLastOfChain(RefAnnotation theAnnot, int[] elmtsLeftAndRight) {
        RefAnnotation last = theAnnot;
        int rightElementCount = 0;
        while (last.hasNext()) {
            last = last.getNext();
            ++rightElementCount;
        }
        elmtsLeftAndRight[1] = rightElementCount;
        return last;
    }

    public void detachAnnotation(Annotation theAnn, Tier theTier) {
        RefAnnotation a = (RefAnnotation)theAnn;
        RefAnnotation prev = a.getPrevious();
        RefAnnotation next = a.getNext();
        if (prev != null) {
            prev.setNext(next);
        } else if (next != null) {
            next.setPrevious(null);
        }
    }
}

