/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mpi.eudico.util.CVEntry;

public class BasicControlledVocabulary {
    public static final int MOVE_TO_TOP = 0;
    public static final int MOVE_UP = 1;
    public static final int MOVE_DOWN = 2;
    public static final int MOVE_TO_BOTTOM = 3;
    protected List entries;
    private String description;
    private String name;
    private boolean initMode;

    public BasicControlledVocabulary(String name, String description) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name can not be null or empty.");
        }
        this.name = name;
        this.description = description;
        this.entries = new ArrayList();
    }

    public BasicControlledVocabulary(String name) {
        this(name, "");
    }

    public void setDescription(String description) {
        this.description = description;
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public CVEntry[] getEntries() {
        return this.entries.toArray(new CVEntry[0]);
    }

    public CVEntry[] getEntriesSortedByAlphabet() {
        Object[] allEntries = this.getEntries();
        Arrays.sort(allEntries);
        this.entries.clear();
        for (int i = 0; i < allEntries.length; ++i) {
            this.entries.add(allEntries[i]);
        }
        return allEntries;
    }

    public CVEntry[] getEntriesSortedByReverseAlphabetOrder() {
        CVEntry[] allEntries = this.getEntries();
        Arrays.sort(allEntries, Collections.reverseOrder());
        this.entries.clear();
        for (int i = 0; i < allEntries.length; ++i) {
            this.entries.add(allEntries[i]);
        }
        return allEntries;
    }

    public String[] getEntryValues() {
        String[] values = new String[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            values[i] = ((CVEntry)this.entries.get(i)).getValue();
        }
        return values;
    }

    public CVEntry getEntryWithValue(String value) {
        CVEntry entry = null;
        if (value == null) {
            return entry;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!((CVEntry)this.entries.get(i)).getValue().equals(value)) continue;
            entry = (CVEntry)this.entries.get(i);
            break;
        }
        return entry;
    }

    public void setInitMode(boolean initMode) {
        this.initMode = initMode;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name can not be null or empty.");
        }
        this.name = name;
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getValuesSortedByAlphabet() {
        Object[] values = this.getEntryValues();
        Arrays.sort(values);
        return values;
    }

    public void addAll(CVEntry[] entries) {
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.addEntry(entries[i]);
            }
        }
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public boolean addEntry(CVEntry entry) {
        if (entry == null) {
            return false;
        }
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            if (!((CVEntry)it.next()).getValue().equals(entry.getValue())) continue;
            return false;
        }
        this.entries.add(entry);
        if (!this.initMode) {
            this.handleModified();
        }
        return true;
    }

    public void clear() {
        this.entries.clear();
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public boolean contains(CVEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.entries.contains(entry);
    }

    public boolean containsValue(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!((CVEntry)this.entries.get(i)).getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicControlledVocabulary)) {
            return false;
        }
        BasicControlledVocabulary other = (BasicControlledVocabulary)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (this.description != null && !this.description.equals(other.getDescription())) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.description)) {
            return false;
        }
        boolean entriesEqual = true;
        CVEntry[] otherEntries = other.getEntries();
        block0: for (int i = 0; i < this.entries.size(); ++i) {
            CVEntry entry = (CVEntry)this.entries.get(i);
            for (int j = 0; j < otherEntries.length; ++j) {
                if (entry.equals(otherEntries[j])) continue block0;
            }
            entriesEqual = false;
            break;
        }
        return entriesEqual;
    }

    public int hashCode() {
        return 1;
    }

    public void modifyEntryValue(CVEntry entry, String value) {
        if (entry == null || value == null) {
            return;
        }
        if (!this.entries.contains(entry)) {
            return;
        }
        if (this.containsValue(value)) {
            return;
        }
        CVEntry newEntry = new CVEntry(value, entry.getDescription());
        int index = this.entries.indexOf(entry);
        this.entries.set(index, newEntry);
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public void moveEntries(CVEntry[] entryArray, int moveType) {
        switch (moveType) {
            case 0: {
                this.moveToTop(entryArray);
                break;
            }
            case 1: {
                this.moveUp(entryArray);
                break;
            }
            case 2: {
                this.moveDown(entryArray);
                break;
            }
            case 3: {
                this.moveToBottom(entryArray);
                break;
            }
        }
    }

    public boolean removeEntries(CVEntry[] entryArray) {
        if (entryArray == null) {
            return false;
        }
        boolean removed = false;
        for (int i = 0; i < entryArray.length; ++i) {
            boolean b = this.entries.remove(entryArray[i]);
            if (!b) continue;
            removed = true;
        }
        if (removed && !this.initMode) {
            this.handleModified();
        }
        return removed;
    }

    public boolean removeEntry(CVEntry entry) {
        boolean b = this.entries.remove(entry);
        if (b && !this.initMode) {
            this.handleModified();
        }
        return b;
    }

    public void removeValue(String value) {
        if (value == null) {
            return;
        }
        boolean removed = false;
        for (int i = 0; i < this.entries.size(); ++i) {
            CVEntry en = (CVEntry)this.entries.get(i);
            if (!en.getValue().equals(value)) continue;
            removed = this.entries.remove(en);
            break;
        }
        if (removed && !this.initMode) {
            this.handleModified();
        }
    }

    public void replaceAll(CVEntry[] newEntries) {
        if (newEntries == null) {
            return;
        }
        this.entries.clear();
        this.addAll(newEntries);
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public boolean replaceEntry(CVEntry oldEntry, CVEntry newEntry) {
        if (oldEntry == null || newEntry == null) {
            return false;
        }
        int index = this.entries.indexOf(oldEntry);
        if (index == -1) {
            return false;
        }
        this.entries.remove(oldEntry);
        this.entries.add(index, newEntry);
        if (!this.initMode) {
            this.handleModified();
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    protected void handleModified() {
    }

    protected void moveToTop(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = 0; i < entryArray.length; ++i) {
            entry = entryArray[i];
            boolean removed = this.entries.remove(entry);
            if (!removed) continue;
            moved = true;
            this.entries.add(i, entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }

    private void moveDown(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = entryArray.length - 1; i >= 0; --i) {
            boolean removed;
            entry = entryArray[i];
            int curIndex = this.entries.indexOf(entry);
            if (curIndex < 0 || curIndex >= this.entries.size() - 1 || !(removed = this.entries.remove(entry))) continue;
            moved = true;
            this.entries.add(curIndex + 1, entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }

    private void moveToBottom(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = 0; i < entryArray.length; ++i) {
            entry = entryArray[i];
            boolean removed = this.entries.remove(entry);
            if (!removed) continue;
            moved = true;
            this.entries.add(entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }

    private void moveUp(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = 0; i < entryArray.length; ++i) {
            boolean removed;
            entry = entryArray[i];
            int curIndex = this.entries.indexOf(entry);
            if (curIndex <= 0 || !(removed = this.entries.remove(entry))) continue;
            moved = true;
            this.entries.add(curIndex - 1, entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }
}

