/*
 * Decompiled with CFR 0.152.
 */
package mpi.lexus.webserviceclient.extension;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.eudico.server.corpora.lexicon.EntryElement;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconEntry;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LexusSearchResultsParser {
    private XMLReader reader;
    public String content;
    private Lexicon searchResponseLexicon;

    public LexusSearchResultsParser() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setContentHandler(new LSRContentHandler());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public Lexicon parseToLexicon(String searchResponse, String fieldOfFocus) {
        ((LSRContentHandler)this.reader.getContentHandler()).setFieldOfFocus(fieldOfFocus);
        this.searchResponseLexicon = new Lexicon();
        try {
            this.reader.parse(new InputSource(new StringReader(searchResponse)));
        }
        catch (SAXException e) {
            System.out.println("SAX error: " + e);
        }
        catch (IOException e) {
            System.out.println("IO error: " + e);
        }
        return this.searchResponseLexicon;
    }

    private class LSRContentHandler
    implements ContentHandler {
        private EntryElement currentElement;
        private LexiconEntry currentEntry;
        private String contentText = "";
        private String fieldOfFocus;

        private LSRContentHandler() {
        }

        public void setFieldOfFocus(String fieldOfFocus) {
            this.fieldOfFocus = fieldOfFocus;
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            this.contentText = this.contentText + new String(ch, start, end);
        }

        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            Pattern pattern = Pattern.compile("_x0020_");
            Matcher matcher = pattern.matcher(name);
            name = matcher.replaceAll(" ");
            pattern = Pattern.compile("_x0028_");
            matcher = pattern.matcher(name);
            name = matcher.replaceAll("(");
            pattern = Pattern.compile("_x0029_");
            matcher = pattern.matcher(name);
            name = matcher.replaceAll(")");
            if (!name.equals("Results")) {
                if (name.equals("lexicalEntry")) {
                    LexiconEntry entry = new LexiconEntry(name);
                    String id = attributes.getValue("id");
                    entry.setId(id);
                    entry.setFieldOfFocus(this.fieldOfFocus);
                    LexusSearchResultsParser.this.searchResponseLexicon.addEntry(entry);
                    this.currentElement = entry;
                    this.currentEntry = entry;
                } else {
                    EntryElement element = new EntryElement(name, this.currentElement);
                    this.currentElement.addElement(element);
                    this.currentElement = element;
                }
            }
            this.contentText = "";
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            Pattern pattern = Pattern.compile("_x0020_");
            Matcher matcher = pattern.matcher(name);
            name = matcher.replaceAll(" ");
            pattern = Pattern.compile("_x0028_");
            matcher = pattern.matcher(name);
            name = matcher.replaceAll("(");
            pattern = Pattern.compile("_x0029_");
            matcher = pattern.matcher(name);
            name = matcher.replaceAll(")");
            if (!name.equals("Results")) {
                if (name.equals("lexicalEntry")) {
                    this.currentElement = null;
                    this.currentEntry = null;
                } else {
                    pattern = Pattern.compile("^\\s+");
                    matcher = pattern.matcher(this.contentText);
                    this.contentText = matcher.replaceAll("");
                    pattern = Pattern.compile("\\s+$");
                    this.contentText = matcher.replaceAll("");
                    this.currentElement.setValue(this.contentText);
                    this.currentElement = this.currentElement.getParent();
                    if (name.equals(this.fieldOfFocus)) {
                        this.currentEntry.addFocusFieldValue(this.contentText);
                    }
                }
            }
            this.contentText = "";
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String arg0) throws SAXException {
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        public void setDocumentLocator(Locator arg0) {
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

