/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public abstract class CorpusType {
    protected final HashMap unitMnemonics = new HashMap();
    protected String frameTitle;
    protected String coarserUnit1 = null;
    protected String coarserUnit2 = null;
    protected String coarserUnit3 = null;
    protected String standardUnit = null;
    protected String[] tierNames;

    public String[] getTierNames() {
        return this.tierNames;
    }

    public abstract String[] getIndexTierNames();

    public String getUnitMnemonic(String unit) {
        return this.unitMnemonics.containsKey(unit) ? (String)this.unitMnemonics.get(unit) : null;
    }

    public abstract boolean allowsSearchOverMultipleTiers();

    public String getUnitFromMnemonic(String mnemonic) {
        for (String key : this.unitMnemonics.keySet()) {
            if (!((String)this.unitMnemonics.get(key)).equals(mnemonic)) continue;
            return key;
        }
        return null;
    }

    public String getUnabbreviatedTierName(String tierName) {
        return Arrays.asList(this.tierNames).contains(tierName) ? tierName : null;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public abstract List getClosedVoc(String var1);

    public abstract boolean isClosedVoc(String var1);

    public abstract boolean isClosedVocEditable(List var1);

    public abstract Locale getDefaultLocale(String var1);

    public abstract String[] getRelatedTiers(String var1);

    public String[] getPossibleUnitsFor(String tierName1, String tierName2) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.standardUnit != null) {
            list.add(this.standardUnit);
        }
        if (this.coarserUnit1 != null) {
            list.add(this.coarserUnit1);
        }
        if (this.coarserUnit2 != null) {
            list.add(this.coarserUnit2);
        }
        if (this.coarserUnit3 != null) {
            list.add(this.coarserUnit3);
        }
        return list.toArray(new String[0]);
    }

    public abstract boolean strictCaseSensitive(String var1);

    public String getDefaultUnit() {
        return this.standardUnit;
    }

    public abstract boolean hasAttributes();

    public abstract String[] getAttributeNames(String var1);

    public abstract String getToolTipTextForAttribute(String var1);

    public abstract boolean allowsQuantifierNO();

    public abstract boolean allowsTemporalConstraints();

    public abstract Object getPossibleAttributeValues(String var1, String var2);

    public abstract Class getInputMethodClass();
}

