/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.search.content.model.CorpusType;
import mpi.util.gui.SteppedComboBox;

public class AttributeConstraintPanel
extends JPanel {
    private final JPanel inputPanel = new JPanel(new GridBagLayout());
    private final CorpusType type;
    private final HashMap comboBoxHash = new HashMap();
    private final HashMap textFieldHash = new HashMap();
    private final String any = "";
    private String tierName;
    private String[] attributeNames;

    public AttributeConstraintPanel(CorpusType type) {
        this.type = type;
        this.add((Component)this.inputPanel, "Center");
    }

    public Dimension getPreferredSize() {
        return new Dimension(320, 50);
    }

    private void makeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        for (int i = 0; i < this.attributeNames.length; ++i) {
            c.gridx = i / 2 * 2;
            c.gridy = i % 2;
            JLabel attributeNameLabel = new JLabel(this.attributeNames[i] + " ", 2);
            attributeNameLabel.setToolTipText(this.type.getToolTipTextForAttribute(this.attributeNames[i]));
            this.inputPanel.add((Component)attributeNameLabel, c);
            c.gridx = i / 2 * 2 + 1;
            Object[] attributeValues = (String[])this.type.getPossibleAttributeValues(this.tierName, this.attributeNames[i]);
            int maxLength = 0;
            for (int j = 0; j < attributeValues.length; ++j) {
                if (maxLength >= attributeValues[j].length()) continue;
                maxLength = ((String)attributeValues[j]).length();
            }
            SteppedComboBox comboBox = new SteppedComboBox(attributeValues);
            comboBox.setName(this.attributeNames[i]);
            comboBox.insertItemAt("", 0);
            comboBox.setFont(comboBox.getFont().deriveFont(11));
            comboBox.setPreferredSize(new Dimension(35 + maxLength * 5, comboBox.getPreferredSize().height));
            this.comboBoxHash.put(this.attributeNames[i], comboBox);
            this.inputPanel.add((Component)comboBox, c);
            if (this.tierName.equals("PHO")) {
                comboBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            JTextField textField = (JTextField)AttributeConstraintPanel.this.textFieldHash.get(((JComboBox)e.getSource()).getName());
                            if (textField == null) {
                                return;
                            }
                            if ("".equals((String)e.getItem())) {
                                textField.setText("");
                                textField.setEnabled(false);
                            } else if ("SEP".equals((String)e.getItem())) {
                                textField.setText("()");
                                textField.setEnabled(false);
                            } else {
                                textField.setText("(.+)");
                                textField.setEnabled(true);
                            }
                        }
                    }
                });
                JTextField textField = new JTextField("(.+)", 4);
                this.textFieldHash.put(this.attributeNames[i], textField);
                c.gridx = i / 2 * 2 + 2;
                this.inputPanel.add((Component)textField, c);
            }
            comboBox.setSelectedIndex(0);
        }
    }

    public String getAttributeValue(String attributeName) {
        String value = "";
        String string = value = this.comboBoxHash.containsKey(attributeName) ? (String)((JComboBox)this.comboBoxHash.get(attributeName)).getSelectedItem() : "";
        if (this.textFieldHash.containsKey(attributeName)) {
            value = value + ((JTextField)this.textFieldHash.get(attributeName)).getText();
        }
        return value;
    }

    private void reset() {
        this.inputPanel.removeAll();
        this.comboBoxHash.clear();
        this.textFieldHash.clear();
        this.revalidate();
    }

    public void setTier(String tierName) {
        this.tierName = tierName;
        this.attributeNames = this.type.getAttributeNames(tierName);
        this.reset();
        if (this.attributeNames.length > 0) {
            this.makeLayout();
            this.inputPanel.setVisible(true);
        } else {
            this.inputPanel.setVisible(false);
        }
    }
}

