/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.model.DependentConstraint;
import mpi.search.content.query.model.RestrictedAnchorConstraint;
import mpi.search.content.query.viewer.ConstraintEditor;
import mpi.search.content.query.viewer.ConstraintRenderer;
import mpi.search.content.result.model.ContentResult;

public class QueryPanel
extends JPanel {
    protected final CorpusType type;
    protected final DefaultTreeModel treeModel;
    protected JTree jTree;

    public QueryPanel(CorpusType type, Action startAction) {
        this.type = type;
        this.treeModel = new DefaultTreeModel(new AnchorConstraint());
        this.createTree(startAction);
    }

    protected void createTree(Action startAction) {
        this.jTree = new JTree(this.treeModel){

            public boolean isPathEditable(TreePath path) {
                return ((Constraint)path.getLastPathComponent()).isEditable();
            }
        };
        this.jTree.setEditable(true);
        this.jTree.setCellRenderer(new ConstraintRenderer());
        this.jTree.setCellEditor(new ConstraintEditor(this.treeModel, this.type, startAction));
        this.jTree.setUI(new BasicTreeUI(){

            protected boolean startEditing(TreePath path, MouseEvent event) {
                return super.startEditing(path, null);
            }
        });
        this.jTree.setRowHeight(0);
        this.jTree.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jTree.setOpaque(false);
        this.setFont(this.getFont().deriveFont(0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTree, "Center");
        this.jTree.startEditingAtPath(this.jTree.getPathForRow(0));
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesInserted(final TreeModelEvent e) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            QueryPanel.this.jTree.startEditingAtPath(e.getTreePath().pathByAddingChild(e.getChildren()[0]));
                        }
                    });
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }

            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                QueryPanel.this.jTree.startEditingAtPath(e.getTreePath());
            }
        });
    }

    public void setQuery(ContentQuery query) {
        this.jTree.stopEditing();
        this.treeModel.setRoot(this.cloneTree(query.getAnchorConstraint()));
        for (int i = 0; i < this.jTree.getRowCount(); ++i) {
            this.jTree.expandRow(i);
        }
        this.jTree.revalidate();
        this.jTree.repaint();
    }

    public ContentQuery getQuery() {
        this.jTree.stopEditing();
        return new ContentQuery((AnchorConstraint)this.cloneTree((AnchorConstraint)this.treeModel.getRoot()), this.type);
    }

    public void newRestrictedQuery(ContentResult result, String comment) {
        if (result.getRealSize() == 0) {
            return;
        }
        this.jTree.stopEditing();
        RestrictedAnchorConstraint ac = new RestrictedAnchorConstraint(result, comment);
        ac.insert(new DependentConstraint(ac.getTierNames()), 0);
        this.treeModel.setRoot(ac);
        this.jTree.startEditingAtPath(this.jTree.getPathForRow(1));
    }

    public void reset() {
        this.jTree.stopEditing();
        this.treeModel.setRoot(new AnchorConstraint());
        this.jTree.startEditingAtPath(this.jTree.getPathForRow(0));
    }

    private MutableTreeNode cloneTree(Constraint node) {
        Constraint newNode = (Constraint)node.clone();
        for (int i = 0; i < node.getChildCount(); ++i) {
            newNode.insert(this.cloneTree((Constraint)node.getChildAt(i)), i);
        }
        return newNode;
    }
}

