/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import mpi.search.SearchLocale;
import mpi.search.content.query.viewer.AbstractDistancePanel;
import mpi.util.gui.XNumericalJTextFieldFilter;

public class StructuralDistancePanel
extends AbstractDistancePanel {
    private static int unitComboBoxWidth = 160;
    protected final JComboBox unitComboBox;
    private final JTextField fromTextField = new JTextField(new XNumericalJTextFieldFilter(5), "0", 3);
    private final JTextField toTextField = new JTextField(new XNumericalJTextFieldFilter(4), "0", 3);

    public StructuralDistancePanel() {
        this.fromTextField.setHorizontalAlignment(0);
        this.toTextField.setHorizontalAlignment(0);
        this.unitComboBox = new JComboBox(){

            public Dimension getPreferredSize() {
                return new Dimension(unitComboBoxWidth, super.getPreferredSize().height);
            }
        };
        JLabel label = new JLabel(SearchLocale.getString("Search.Constraint.Distance") + " ");
        label.setFont(this.getFont().deriveFont(0));
        this.add(label);
        this.add(this.fromTextField);
        label = new JLabel(" " + SearchLocale.getString("Search.To") + " ");
        label.setFont(this.getFont().deriveFont(0));
        this.add(label);
        this.add(this.toTextField);
        this.add(new JLabel(" "));
        this.add(this.unitComboBox);
    }

    public void setLowerBoundary(long l) {
        this.fromTextField.setText(this.getString(l));
    }

    public long getLowerBoundary() {
        return this.fromTextField.getText().trim().equals("") ? Long.MIN_VALUE : this.getLong(this.fromTextField.getText());
    }

    public void setUnit(String s) {
        this.unitComboBox.setSelectedItem(s);
    }

    public String getUnit() {
        return this.unitComboBox.getSelectedIndex() != -1 ? (String)this.unitComboBox.getSelectedItem() : "";
    }

    public JComboBox getUnitComboBox() {
        return this.unitComboBox;
    }

    public void setUnitComboBoxRenderer(ListCellRenderer renderer) {
        this.unitComboBox.setRenderer(renderer);
    }

    public void setUpperBoundary(long l) {
        this.toTextField.setText(this.getString(l));
    }

    public long getUpperBoundary() {
        return this.toTextField.getText().trim().equals("") ? Long.MAX_VALUE : this.getLong(this.toTextField.getText());
    }
}

