/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;

public class TierListCellRenderer
extends DefaultListCellRenderer {
    private final CorpusType type;

    public TierListCellRenderer(CorpusType type) {
        this.type = type;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String valueString = null;
        if (value != null) {
            valueString = value.toString();
            if (this.type != null) {
                String longName = this.type.getUnabbreviatedTierName(valueString);
                if (longName != null) {
                    valueString = longName;
                } else {
                    String localizedValueString = SearchLocale.getString(valueString);
                    if (localizedValueString != null && localizedValueString.length() > 0) {
                        valueString = localizedValueString;
                    }
                }
            }
        }
        return super.getListCellRendererComponent((JList<?>)list, valueString, index, isSelected, cellHasFocus);
    }
}

