/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import mpi.search.SearchLocale;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.viewer.QueryPanel;
import mpi.search.content.result.model.ContentResult;
import mpi.search.content.result.viewer.ContentMatchCounter;
import mpi.search.query.model.Query;
import mpi.search.query.model.QueryManager;
import mpi.search.query.viewer.AbstractSimpleSearchPanel;
import mpi.search.query.viewer.StartStopPanel;
import mpi.util.gui.TriptychLayout;

public abstract class AbstractComplexSearchPanel
extends AbstractSimpleSearchPanel {
    protected Action readAction;
    protected Action saveAction;
    protected Action zoomAction;
    protected JLabel corpusLabel;
    protected final JPanel bottomPanel = new JPanel();
    protected final QueryManager queryManager = new QueryManager();
    protected QueryPanel queryPanel;
    private final JLabel resultCounterLabel = new JLabel();
    private final JPanel toolAndQueryPanel = new JPanel(new BorderLayout());
    private final JToolBar toolBar = new JToolBar();
    private Action backAction;
    private Action forwardAction;
    private Action newAction;

    public AbstractComplexSearchPanel() {
        this.matchCounter = new ContentMatchCounter();
        this.createActions();
    }

    protected Query getQuery() {
        ContentQuery query = this.queryPanel.getQuery();
        if (!query.equals(this.queryManager.getCurrentQuery())) {
            this.queryManager.addQuery(query);
            return query;
        }
        if (this.queryManager.getCurrentQuery().getResult().getStatus() != 1) {
            return this.queryManager.getCurrentQuery();
        }
        return null;
    }

    protected void addQuery(ContentQuery query) {
        this.queryPanel.setQuery(query);
        this.clearResult();
    }

    protected void clearResult() {
        this.resultViewer.reset();
        this.matchCounter.setVisible(false);
        this.progressViewer.setVisible(false);
        this.queryManager.setCurrentQueryNumber(this.queryManager.size() + 1);
        this.updateActions();
    }

    protected void gotoQuery(int nr) {
        this.queryManager.setCurrentQueryNumber(nr);
        ContentQuery query = (ContentQuery)this.queryManager.getCurrentQuery();
        if (query.getResult() != null) {
            this.queryPanel.setQuery(query);
            if (query.getResult().getStatus() == 2) {
                this.startSearch();
            } else {
                this.matchCounter.setResult(query.getResult());
                this.matchCounter.setVisible(true);
                this.progressViewer.setStatus(query.getResult().getStatus());
                this.progressViewer.setVisible(true);
                this.updateActions();
                this.resultViewer.showResult(query.getResult());
            }
        }
    }

    protected void makeLayout() {
        this.toolBar.addSeparator();
        this.toolBar.add(this.startAction);
        this.toolBar.add(this.stopAction);
        this.toolBar.add(this.newAction);
        this.toolBar.add(this.zoomAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.saveAction);
        this.toolBar.add(this.readAction);
        this.toolBar.add(this.exportAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.backAction);
        this.toolBar.add(this.resultCounterLabel);
        this.toolBar.add(this.forwardAction);
        this.toolBar.addSeparator();
        this.toolBar.setBorderPainted(true);
        this.toolBar.setBorder(new LineBorder(Color.gray));
        this.toolBar.putClientProperty("JToolBar.isRollover", new Boolean(true));
        this.toolAndQueryPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        this.toolAndQueryPanel.add((Component)this.toolBar, c);
        JPanel queryCont = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        queryCont.add((Component)this.queryPanel, c);
        JPanel filler = new JPanel();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 18;
        c.fill = 3;
        c.weighty = 10.0;
        queryCont.add((Component)filler, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(queryCont);
        this.toolAndQueryPanel.add((Component)scrollPane, c);
        this.toolAndQueryPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.bottomPanel.setLayout(new TriptychLayout());
        this.matchCounter.setBorder(new CompoundBorder(new EmptyBorder(3, 3, 3, 3), new LineBorder(Color.gray)));
        this.progressViewer.setBorder(new CompoundBorder(new EmptyBorder(3, 3, 3, 3), new LineBorder(Color.gray)));
        this.startStopPanel = new StartStopPanel(this.startAction, this.stopAction, this.closeAction);
        this.bottomPanel.add("Left", this.matchCounter);
        this.bottomPanel.add("Right", this.progressViewer);
        this.bottomPanel.add("Center", this.startStopPanel);
        this.matchCounter.setVisible(false);
        this.progressViewer.setVisible(false);
        this.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        JSplitPane splitPane = new JSplitPane(0, this.toolAndQueryPanel, (JComponent)((Object)this.resultViewer));
        splitPane.setResizeWeight(0.8);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)splitPane, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 16;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.bottomPanel, c);
        this.updateActions();
    }

    protected abstract void read();

    protected abstract void save();

    protected void updateActions() {
        super.updateActions();
        boolean executing = this.searchEngine != null && this.searchEngine.isExecuting();
        this.backAction.setEnabled(!executing && this.queryManager.hasPreviousQuery());
        this.forwardAction.setEnabled(!executing && this.queryManager.hasNextQuery());
        boolean positiveResult = !executing && this.queryManager.getCurrentQuery() != null && this.queryManager.getCurrentQuery().getResult().getRealSize() > 0 && this.queryManager.getCurrentQuery().getResult().getStatus() != 2;
        this.saveAction.setEnabled(positiveResult && !((ContentQuery)this.queryManager.getCurrentQuery()).isRestricted());
        this.exportAction.setEnabled(positiveResult);
        this.zoomAction.setEnabled(positiveResult);
        this.resultCounterLabel.setText(this.queryManager.getCurrentQueryNumber() > 0 ? "" + this.queryManager.getCurrentQueryNumber() : "");
    }

    private void createActions() {
        ImageIcon searchIcon = null;
        ImageIcon stopIcon = null;
        ImageIcon newIcon = null;
        ImageIcon zoomIcon = null;
        ImageIcon saveIcon = null;
        ImageIcon readIcon = null;
        ImageIcon exportIcon = null;
        ImageIcon backIcon = null;
        ImageIcon forwardIcon = null;
        try {
            searchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Play16.gif"));
            stopIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Stop16.gif"));
            newIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif"));
            zoomIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Zoom16.gif"));
            saveIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif"));
            readIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif"));
            exportIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Export16.gif"));
            backIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Back16.gif"));
            forwardIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward16.gif"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.startAction.putValue("SmallIcon", searchIcon);
        this.stopAction.putValue("SmallIcon", stopIcon);
        this.exportAction.putValue("SmallIcon", exportIcon);
        this.newAction = new AbstractAction(SearchLocale.getString("Action.New"), newIcon){

            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchPanel.this.newQuery();
            }
        };
        this.newAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.New"));
        KeyStroke ks = KeyStroke.getKeyStroke(78, 2);
        this.newAction.putValue("AcceleratorKey", ks);
        this.saveAction = new AbstractAction(SearchLocale.getString("Action.Save"), saveIcon){

            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchPanel.this.save();
            }
        };
        this.saveAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Save"));
        ks = KeyStroke.getKeyStroke(77, 2);
        this.saveAction.putValue("AcceleratorKey", ks);
        this.zoomAction = new AbstractAction(SearchLocale.getString("Action.Zoom"), zoomIcon){

            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchPanel.this.queryPanel.newRestrictedQuery((ContentResult)AbstractComplexSearchPanel.this.queryManager.getCurrentQuery().getResult(), SearchLocale.getString("Search.Constraint.Matches") + " " + SearchLocale.getString("Search.FoundIn") + " " + SearchLocale.getString("Search.Result") + " " + AbstractComplexSearchPanel.this.queryManager.getCurrentQueryNumber());
                AbstractComplexSearchPanel.this.clearResult();
            }
        };
        this.zoomAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Zoom"));
        ks = KeyStroke.getKeyStroke(82, 2);
        this.zoomAction.putValue("AcceleratorKey", ks);
        this.readAction = new AbstractAction(SearchLocale.getString("Action.Open"), readIcon){

            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchPanel.this.read();
                AbstractComplexSearchPanel.this.updateActions();
            }
        };
        this.readAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Open"));
        ks = KeyStroke.getKeyStroke(79, 2);
        this.readAction.putValue("AcceleratorKey", ks);
        this.closeAction = new AbstractAction(SearchLocale.getString("Action.Close")){

            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchPanel.this.userQuit();
            }
        };
        ks = KeyStroke.getKeyStroke(88, 2);
        this.closeAction.putValue("AcceleratorKey", ks);
        this.backAction = new AbstractAction(SearchLocale.getString("Action.Back"), backIcon){

            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchPanel.this.gotoQuery(AbstractComplexSearchPanel.this.queryManager.getCurrentQueryNumber() - 1);
            }
        };
        this.backAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Back"));
        ks = KeyStroke.getKeyStroke(66, 2);
        this.backAction.putValue("AcceleratorKey", ks);
        this.forwardAction = new AbstractAction(SearchLocale.getString("Action.Forward"), forwardIcon){

            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchPanel.this.gotoQuery(AbstractComplexSearchPanel.this.queryManager.getCurrentQueryNumber() + 1);
            }
        };
        this.forwardAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Forward"));
        ks = KeyStroke.getKeyStroke(70, 2);
        this.forwardAction.putValue("AcceleratorKey", ks);
        this.stopAction.setEnabled(false);
    }

    private void newQuery() {
        this.queryPanel.reset();
        this.clearResult();
    }

    protected void userQuit() {
        this.stopSearch();
        ((Window)this.getTopLevelAncestor()).dispose();
    }
}

