/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.query.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import mpi.search.SearchLocale;

public abstract class AbstractQueryPanel
extends JPanel {
    private final Action addConstraintAction;
    private final Action deleteConstraintAction;
    private final int maxConstraintCount = 10;
    private final JPanel constraintGridPanel = new JPanel(new GridLayout(0, 1));

    public AbstractQueryPanel() {
        this.addConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Add")){

            public void actionPerformed(ActionEvent e) {
                AbstractQueryPanel.this.addConstraint();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(65, 2);
        this.addConstraintAction.putValue("AcceleratorKey", ks);
        this.deleteConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Delete")){

            public void actionPerformed(ActionEvent e) {
                AbstractQueryPanel.this.deleteConstraint();
            }
        };
        ks = KeyStroke.getKeyStroke(68, 2);
        this.deleteConstraintAction.putValue("AcceleratorKey", ks);
        this.makeLayout();
    }

    private void makeLayout() {
        this.setLayout(new BorderLayout());
        this.addConstraintGridPanel();
        this.addConstraintGridControlPanel();
    }

    protected void addConstraintGridPanel() {
        this.add((Component)this.constraintGridPanel, "Center");
    }

    protected void addConstraintGridControlPanel() {
        JButton addButton = new JButton(this.addConstraintAction);
        JButton delButton = new JButton(this.deleteConstraintAction);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        buttonPanel.setOpaque(false);
        buttonPanel.add(addButton);
        buttonPanel.add(delButton);
        JPanel insetPanel = new JPanel();
        insetPanel.setOpaque(false);
        insetPanel.add(buttonPanel);
        insetPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.add((Component)insetPanel, "South");
    }

    public void updateLayout() {
        if (this.getTopLevelAncestor() != null) {
            int preferredWidth = this.getPreferredSize().width;
            int currentWidth = this.getSize().width;
            if (preferredWidth > currentWidth) {
                this.getTopLevelAncestor().setSize(preferredWidth + 20, this.getTopLevelAncestor().getHeight());
            } else {
                this.getTopLevelAncestor().validate();
                this.repaint();
            }
        }
        this.updateActions();
    }

    protected void updateActions() {
        this.deleteConstraintAction.setEnabled(this.constraintGridPanel.getComponentCount() > 1);
        this.addConstraintAction.setEnabled(this.constraintGridPanel.getComponentCount() < 10);
    }

    public void reset() {
        this.constraintGridPanel.removeAll();
        this.addConstraint();
    }

    protected void addConstraint() {
        this.constraintGridPanel.add(this.createConstraintPanel());
        this.updateLayout();
    }

    protected void deleteConstraint() {
        this.deleteConstraints(1);
    }

    protected void deleteConstraints(int nrOfPanelsToDelete) {
        int nrOfComponents = this.constraintGridPanel.getComponentCount();
        for (int i = nrOfComponents - 1; i > 0 && nrOfPanelsToDelete > 0; --i, --nrOfPanelsToDelete) {
            this.constraintGridPanel.remove(i);
        }
        this.updateLayout();
    }

    protected int getNrOfConstraints() {
        return this.constraintGridPanel.getComponentCount();
    }

    protected JPanel getConstraintGridPanel() {
        return this.constraintGridPanel;
    }

    protected abstract JPanel createConstraintPanel();
}

