/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.result.model;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import mpi.search.result.model.Match;
import mpi.search.result.model.ResultChangeListener;
import mpi.search.result.model.ResultEvent;
import mpi.util.PagingListModel;

public class Result
extends PagingListModel {
    public static final int MODIFIED = 2;
    public static final int COMPLETE = 1;
    public static final int INIT = 0;
    public static final int INTERRUPTED = -1;
    protected int status = -1;
    private final List listeners = new ArrayList();

    public Result() {
        this.data = new ArrayList();
    }

    public Result(int pageSize) {
        this.data = new ArrayList();
        this.setPageSize(pageSize);
    }

    public final void setStatus(int status) {
        if (this.status != status) {
            this.status = status;
            this.fireResultChanged(new ResultEvent(this, 1));
            if ((status == 1 || status == -1) && this.getSize() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Result.this.fireIntervalAdded(this, 0, Result.this.getSize() - 1);
                    }
                });
            }
        }
    }

    public final int getStatus() {
        return this.status;
    }

    public Match getMatch(int i) {
        return 0 < i && i <= this.data.size() ? this.data.get(i - 1) : null;
    }

    public final List getMatches() {
        return this.data;
    }

    public List getSubList() {
        return this.getSubList(0, this.getSize());
    }

    public List getSubList(int index0, int index1) {
        return this.data.subList(this.getFirstShownRealIndex() + index0, this.getFirstShownRealIndex() + index1);
    }

    public void addMatch(Match match) {
        this.data.add(match);
        if (this.data.size() % this.pageSize == 0) {
            this.fireResultChanged(new ResultEvent(this, 2));
        }
    }

    public void addResultChangeListener(ResultChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.resultChanged(new ResultEvent(this, 1));
        }
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public void reset() {
        int index1 = this.data.size() - 1;
        this.data.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
        ListDataListener[] listDataListeners = this.getListDataListeners();
        for (int i = 0; i < listDataListeners.length; ++i) {
            this.removeListDataListener(listDataListeners[i]);
        }
        this.status = 0;
        this.pageOffset = 0;
        this.fireResultChanged(new ResultEvent(this, 1));
    }

    public final void fireResultChanged(ResultEvent event) {
        try {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((ResultChangeListener)iter.next()).resultChanged(event);
            }
        }
        catch (ConcurrentModificationException e) {
            System.out.println("Concurrent modification exception - ignored");
        }
    }
}

