/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.result.viewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mpi.search.result.model.Match;
import mpi.search.result.model.ResultHandler;

public class ResultList
extends JList
implements MouseListener {
    private JPopupMenu actionsMenu;
    private ResultHandler resultHandler;

    public ResultList() {
        this((ResultHandler)null);
    }

    public ResultList(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        this.setSelectionMode(0);
        this.addMouseListener(this);
    }

    public void setPopupChoices(String[] popupChoices) {
        if (popupChoices.length > 0) {
            this.actionsMenu = new JPopupMenu();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ResultList.this.resultHandler.handleMatch((Match)ResultList.this.getSelectedValue(), e.getActionCommand());
                }
            };
            for (int i = 0; i < popupChoices.length; ++i) {
                JMenuItem menuItem = new JMenuItem(popupChoices[i]);
                menuItem.addActionListener(actionListener);
                this.actionsMenu.add(menuItem);
            }
        } else {
            this.actionsMenu = null;
        }
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.resultHandler.handleMatch((Match)this.getSelectedValue(), ((JMenuItem)this.actionsMenu.getSubElements()[0]).getActionCommand());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.actionsMenu != null && e.isPopupTrigger() && this.getSelectedValue() != null) {
            this.showPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.actionsMenu != null && e.isPopupTrigger() && this.getSelectedValue() != null) {
            this.showPopup(e);
        }
    }

    private void showPopup(MouseEvent e) {
        this.actionsMenu.show(this, e.getX(), e.getY());
        this.actionsMenu.setVisible(true);
        this.requestFocus();
    }
}

