/*
 * Decompiled with CFR 0.152.
 */
package mpi.util.gui;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class RestrictedComboBoxEditor
extends BasicComboBoxEditor
implements KeyListener {
    private final char splitChar;
    private final char sepChar;
    private final char endChar;
    private final char wildkeyChar;
    private String oldString;
    private String prefix;
    private Object oldValue;

    public RestrictedComboBoxEditor(char splitChar, char sepChar, char endChar, char wildkeyChar) {
        this.splitChar = splitChar;
        this.sepChar = sepChar;
        this.endChar = endChar;
        this.wildkeyChar = wildkeyChar;
        this.editor.addKeyListener(this);
    }

    public RestrictedComboBoxEditor() {
        this('(', ',', ')', '*');
    }

    public void setItem(Object anObject) {
        if (anObject != null) {
            String string = anObject.toString();
            int splitindex = string.indexOf(this.splitChar);
            if (splitindex >= 0) {
                this.prefix = string.substring(0, splitindex);
                string = string.substring(splitindex);
            }
            this.editor.setText(string);
            this.oldValue = anObject;
            this.oldString = string;
            this.editor.setBackground(Color.white);
        } else {
            this.editor.setText("");
        }
    }

    public Object getItem() {
        String newValue = this.editor.getText();
        if (this.oldValue != null) {
            if (newValue.equals(this.oldString)) {
                return this.oldValue;
            }
            return this.prefix + newValue;
        }
        return newValue;
    }

    public void keyTyped(KeyEvent ke) {
        ke.consume();
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 127) {
            int position = this.editor.getCaretPosition();
            String string = this.editor.getText();
            if (0 < position && position < string.length() - 1) {
                int prev = string.lastIndexOf(this.sepChar, position);
                if (prev == -1) {
                    prev = 0;
                }
                this.editor.setText(string.substring(0, prev + 1) + this.wildkeyChar + this.endChar);
            }
        }
        if (ke.getKeyCode() != 37) {
            if (ke.getKeyCode() != 39) {
                ke.consume();
            }
        }
    }

    public void keyReleased(KeyEvent ke) {
        ke.consume();
    }
}

