/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ImageGen {
    static String arname;
    static String pkgname;
    static String destdir;
    static String[] names;
    static byte[][] images;
    static DataOutputStream ds;

    private static String byte2oct(byte by) {
        int n2 = by & 0xFF;
        int n3 = n2 % 8;
        int n4 = n2 / 8 % 8;
        int n5 = n2 / 64;
        return n5 + "" + n4 + "" + n3;
    }

    private static String fileName(String string) {
        int n2 = string.lastIndexOf(File.separator);
        return string.substring(n2 + 1);
    }

    public static void main(String[] stringArray) {
        names = new String[stringArray.length + 1];
        images = new byte[stringArray.length + 1][];
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-d")) {
                if (n2++ >= stringArray.length) {
                    ImageGen.printUsage();
                    return;
                }
                destdir = stringArray[n2];
            } else {
                ImageGen.names[n3++] = stringArray[n2];
            }
            ++n2;
        }
        ImageGen.names[n3] = null;
        if (n3 == 0) {
            ImageGen.printUsage();
            return;
        }
        n2 = names[0].lastIndexOf(".");
        if (n2 == -1) {
            pkgname = null;
            arname = names[0];
        } else {
            pkgname = names[0].substring(0, n2);
            arname = names[0].substring(n2 + 1);
        }
        String string = null;
        try {
            string = destdir == null ? String.valueOf(arname) + ".java" : String.valueOf(destdir) + File.separator + arname + ".java";
            ds = new DataOutputStream(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open file: " + string + iOException);
        }
        if (n3 == 1) {
            ImageGen.writeInterface();
        } else {
            ImageGen.writeClass();
        }
    }

    static void printUsage() {
        System.err.println("java ImageGen [-d <destdir>] <imagelib> image1 image2 ...");
    }

    static void readImages() {
        int n2 = 1;
        while (names[n2] != null) {
            String string = names[n2];
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                int n3 = fileInputStream.available();
                ImageGen.images[n2] = new byte[n3];
                fileInputStream.read(images[n2]);
            }
            catch (IOException iOException) {
                System.err.println("Cannot open image file: " + string);
            }
            ++n2;
        }
    }

    static void writeClass() {
        int n2 = 0;
        try {
            ImageGen.readImages();
            ds.writeBytes("/* Generated by ImageGen.\n   DO NOT EDIT.*/\n\n");
            if (pkgname != null) {
                ds.writeBytes("package ");
                ds.writeBytes(pkgname);
                ds.writeBytes(";\n\n");
            }
            ds.writeBytes("public abstract class ");
            ds.writeBytes(arname);
            ds.writeBytes(" {\n\n");
            ds.writeBytes("    private static byte[] m(int from,int to){\n");
            ds.writeBytes("       int i;\n");
            ds.writeBytes("       byte[] b= new byte[to - from];\n");
            ds.writeBytes("       for (i=0;i<b.length;i++)\n");
            ds.writeBytes("          b[i] = (byte)(s.charAt(i+from)-1);\n");
            ds.writeBytes("       return b;\n");
            ds.writeBytes("    }\n");
            ds.writeBytes("    private static String s = \n        ");
            int n3 = 1;
            while (names[n3] != null) {
                ds.writeBytes("\"");
                int n4 = images[n3].length;
                int n5 = 0;
                while (n5 < n4) {
                    ds.writeBytes("\\" + ImageGen.byte2oct((byte)(1 + images[n3][n5])));
                    if (n5 % 16 == 15) {
                        ds.writeBytes("\"+\n        \"");
                    }
                    ++n5;
                }
                ds.writeBytes("\"");
                if (names[n3 + 1] != null) {
                    ds.writeBytes("+\n        ");
                }
                ++n3;
            }
            ds.writeBytes(";\n\n");
            ds.writeBytes("    public static byte[] getImage(String name) {\n");
            n3 = 1;
            while (names[n3] != null) {
                ds.writeBytes("        if (name.equals(\"" + ImageGen.fileName(names[n3]) + "\"))\n");
                ds.writeBytes("            return m(" + n2 + "," + (n2 += images[n3].length) + ");\n");
                ++n3;
            }
            ds.writeBytes("        return null;\n");
            ds.writeBytes("    }\n\n");
            ds.writeBytes("}\n");
        }
        catch (IOException iOException) {}
    }

    static void writeInterface() {
        try {
            ds.writeBytes("/* Generated by ImageGen.\n   DO NOT EDIT.*/\n\n");
            if (pkgname != null) {
                ds.writeBytes("package ");
                ds.writeBytes(pkgname);
                ds.writeBytes(";\n\n");
            }
            ds.writeBytes("public interface ImageLib {\n");
            ds.writeBytes("    public byte[] getImage(String name);\n");
            ds.writeBytes("}\n");
        }
        catch (IOException iOException) {}
    }
}

