/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

public class GsmEncoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    protected static final int ORDER = 8;
    protected static final int BLOCKSIZE = 160;
    protected static final int SBLOCKSIZE = 40;
    protected static final int SBLOCKS = 4;
    protected static final int SUBSAMPBLOCKS = 4;
    protected static final int SUBSAMPSIZE = 13;
    protected static final int nPARAMETERS = 77;
    private static final int INTERPLAR = 4;
    public static final boolean USE_VAD = true;
    public static final boolean NO_VAD = false;
    public static final boolean GSM_FULL = true;
    public static final boolean GSM_LIGHT = false;
    protected int sidUpdateRate = 0;
    public static final int GSM_SPEECH_FRAME = 0;
    public static final int GSM_SID_FRAME = 1;
    public static final int GSM_SILENCE_FRAME = 2;
    protected int frameType = 0;
    protected boolean vadSupportFlag;
    protected float data_buffer;
    protected float data_scaledSample;
    protected int data_blockNumber;
    protected float[] aux_correlations = new float[121];
    protected int[] data_Nc = new int[4];
    protected float[] data_LAR = new float[8];
    protected float[] data_currentxmax = new float[4];
    protected int[] data_Parameters = new int[77];
    protected int data_pParams;
    protected float[] data_wt = new float[50];
    protected float[] data_u = new float[9];
    protected float[] data_prevLARpp = new float[9];
    protected boolean data_complexity_mode;
    protected boolean data_vad_mode;
    protected float[] data_residual = new float[280];
    protected int data_residual_Index;
    protected float[] data_input = new float[160];
    protected float[] data_first_res = new float[160];
    protected float[] data_acf = new float[9];
    protected float[] data_r = new float[9];
    protected float[] data_LARpp = new float[9];
    protected float[] aux_decimated_subsegment = new float[20];
    protected float[] aux_decimated_q_frstbase = new float[60];
    protected float[] aux_decimated_correlations = new float[41];
    protected float[] aux_KK = new float[9];
    protected float[] aux_P = new float[9];
    protected float[] encode_outsegment = new float[40];
    protected int[] encode_pitchArray = new int[1];
    protected float[] aux_rp = new float[9];
    protected static float[] lut_A;
    protected static float[] lut_INVA;
    protected static float[] lut_MIC;
    protected static float[] lut_MAC;
    protected static float[] lut_B;
    protected static int[] lut_k_start;
    protected static int[] lut_lg2s;
    private static final int GSM_MAGIC = 13;

    static {
        float[] fArray = new float[9];
        fArray[1] = 20.0f;
        fArray[2] = 20.0f;
        fArray[3] = 20.0f;
        fArray[4] = 20.0f;
        fArray[5] = 13.637f;
        fArray[6] = 15.0f;
        fArray[7] = 8.334f;
        fArray[8] = 8.824f;
        lut_A = fArray;
        float[] fArray2 = new float[9];
        fArray2[1] = 0.05f;
        fArray2[2] = 0.05f;
        fArray2[3] = 0.05f;
        fArray2[4] = 0.05f;
        fArray2[5] = 0.07332991f;
        fArray2[6] = 0.06666667f;
        fArray2[7] = 0.11999041f;
        fArray2[8] = 0.11332729f;
        lut_INVA = fArray2;
        float[] fArray3 = new float[9];
        fArray3[1] = -32.0f;
        fArray3[2] = -32.0f;
        fArray3[3] = -16.0f;
        fArray3[4] = -16.0f;
        fArray3[5] = -8.0f;
        fArray3[6] = -8.0f;
        fArray3[7] = -4.0f;
        fArray3[8] = -4.0f;
        lut_MIC = fArray3;
        float[] fArray4 = new float[9];
        fArray4[1] = 31.0f;
        fArray4[2] = 31.0f;
        fArray4[3] = 15.0f;
        fArray4[4] = 15.0f;
        fArray4[5] = 7.0f;
        fArray4[6] = 7.0f;
        fArray4[7] = 3.0f;
        fArray4[8] = 3.0f;
        lut_MAC = fArray4;
        float[] fArray5 = new float[9];
        fArray5[3] = 4.0f;
        fArray5[4] = -5.0f;
        fArray5[5] = 0.184f;
        fArray5[6] = -3.5f;
        fArray5[7] = -0.666f;
        fArray5[8] = -2.235f;
        lut_B = fArray5;
        int[] nArray = new int[5];
        nArray[1] = 13;
        nArray[2] = 27;
        nArray[3] = 40;
        nArray[4] = 160;
        lut_k_start = nArray;
        lut_lg2s = new int[32];
        int n2 = 0;
        GsmEncoder.lut_lg2s[n2++] = 1;
        GsmEncoder.lut_lg2s[n2++] = 2;
        int n3 = 3;
        while (n3 <= 6) {
            int n4 = 1;
            while (n4 <= 1 << n3 - 2) {
                GsmEncoder.lut_lg2s[n2++] = n3;
                ++n4;
            }
            ++n3;
        }
    }

    void Autocorrelations(float[] fArray, float[] fArray2) {
        int n2 = 0;
        while (n2 <= 8) {
            float f2 = 0.0f;
            int n3 = n2;
            while (n3 < 160) {
                f2 += fArray[n3] * fArray[n3 - n2];
                ++n3;
            }
            fArray2[n2] = f2;
            ++n2;
        }
    }

    void PreProcessing(float[] fArray, float[] fArray2) {
        float f2 = this.data_buffer;
        float f3 = this.data_scaledSample;
        int n2 = 0;
        while (n2 < 160) {
            float f4 = f3;
            f3 = fArray[n2] * 0.5f;
            fArray2[n2] = f2 * -0.85998535f;
            f2 = f3 - f4 + 0.9989929f * f2;
            int n3 = n2++;
            fArray2[n3] = fArray2[n3] + (f2 + 1.0E-15f);
        }
        this.data_buffer = f2;
        this.data_scaledSample = f3;
    }

    private final int analizeSecondResidual(float f2, int n2, float[] fArray, int n3, float[] fArray2) {
        int n4 = 0;
        float f3 = 0.0f;
        float[] fArray3 = this.data_wt;
        int n5 = this.data_residual_Index;
        float[] fArray4 = this.data_residual;
        int n6 = this.data_pParams;
        int[] nArray = this.data_Parameters;
        int n7 = n5;
        int n8 = 0;
        while (n8 < 40) {
            float f4;
            fArray4[n7] = f4 = f2 * fArray4[n7 - n2];
            fArray3[5 + n8] = fArray[n3 + n8] - f4;
            ++n7;
            ++n8;
        }
        int n9 = 0;
        while (n9 < 40) {
            fArray2[n9] = -0.016357422f * (fArray3[n9] + fArray3[n9 + 10]) + -0.045654297f * (fArray3[n9 + 1] + fArray3[n9 + 9]) + 0.25073242f * (fArray3[n9 + 3] + fArray3[n9 + 7]) + 0.70080566f * (fArray3[n9 + 4] + fArray3[n9 + 6]) + fArray3[n9 + 5];
            ++n9;
        }
        int n10 = 0;
        while (n10 <= 3) {
            float f5 = 0.0f;
            int n11 = n10;
            int n12 = 0;
            while (n12 <= 12) {
                float f6 = fArray2[n11];
                n11 += 3;
                f5 += f6 * f6;
                ++n12;
            }
            if (f3 < f5) {
                n4 = n10;
                f3 = f5;
            }
            ++n10;
        }
        nArray[n6++] = n4;
        this.data_pParams = n6;
        return n4;
    }

    private float calculatePitch(float[] fArray, int n2, int[] nArray) {
        int n3;
        float f2 = 0.0f;
        float[] fArray2 = this.aux_correlations;
        int[] nArray2 = this.data_Nc;
        int n4 = this.data_blockNumber;
        int n5 = this.data_residual_Index;
        float[] fArray3 = this.data_residual;
        int n6 = this.data_pParams;
        int[] nArray3 = this.data_Parameters;
        nArray[0] = 40;
        int n7 = 40;
        while (n7 <= 120) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = fArray3[n5 - 1 - n7];
            float f7 = fArray3[n5 - 2 - n7];
            n3 = 0;
            while (n3 < 40) {
                float f8 = fArray[n2 + n3];
                float f9 = fArray[n2 + n3 + 1];
                int n8 = n5 + n3 - n7;
                float f10 = f6;
                float f11 = f7;
                f6 = fArray3[n8 + 1];
                f7 = fArray3[n8];
                f3 += f8 * f7 + f9 * f6;
                f4 += f8 * f10 + f9 * f7;
                f5 += f8 * f11 + f9 * f10;
                n3 += 2;
            }
            fArray2[n7] = f3;
            fArray2[n7 + 1] = f4;
            fArray2[n7 + 2] = f5;
            n7 += 3;
        }
        n3 = 40;
        while (n3 <= 120) {
            if (f2 < fArray2[n3]) {
                f2 = fArray2[n3];
                nArray[0] = n3;
            }
            ++n3;
        }
        int n9 = n6++;
        int n10 = nArray[0];
        nArray3[n9] = n10;
        nArray2[n4] = n10;
        this.data_pParams = n6;
        return f2;
    }

    private final float calculatePitchGain(float f2, int n2) {
        float f3;
        float[] fArray = this.data_residual;
        int n3 = this.data_residual_Index;
        int n4 = this.data_pParams;
        int[] nArray = this.data_Parameters;
        float f4 = 0.0f;
        int n5 = n3 - n2;
        int n6 = 0;
        while (n6 < 40) {
            float f5 = fArray[n5++];
            f4 += f5 * f5;
            ++n6;
        }
        if ((double)f2 <= 0.2 * (double)f4) {
            nArray[n4++] = 0;
            f3 = 0.1f;
        } else if ((double)f2 <= 0.5 * (double)f4) {
            nArray[n4++] = 1;
            f3 = 0.35f;
        } else if ((double)f2 <= 0.8 * (double)f4) {
            nArray[n4++] = 2;
            f3 = 0.65f;
        } else {
            nArray[n4++] = 3;
            f3 = 1.0f;
        }
        this.data_pParams = n4;
        return f3;
    }

    private float calculatePitch_Light(float[] fArray, int n2, int[] nArray) {
        float f2;
        float f3;
        float f4;
        int n3;
        float f5 = 0.0f;
        float[] fArray2 = this.aux_correlations;
        int[] nArray2 = this.data_Nc;
        int n4 = this.data_blockNumber;
        int n5 = this.data_residual_Index;
        float[] fArray3 = this.data_residual;
        int n6 = this.data_pParams;
        int[] nArray3 = this.data_Parameters;
        float[] fArray4 = this.aux_decimated_subsegment;
        float[] fArray5 = this.aux_decimated_q_frstbase;
        float[] fArray6 = this.aux_decimated_correlations;
        fArray4[0] = 0.5f * (fArray[n2] + fArray[n2 + 1]);
        int n7 = 1;
        int n8 = 2;
        while (n7 <= 19) {
            fArray4[n7] = 0.25f * (fArray[n2 + n8 - 1] + fArray[n2 + n8 + 1]) + 0.5f * fArray[n2 + n8];
            ++n7;
            n8 += 2;
        }
        fArray5[0] = 0.5f * (fArray3[n5 - 120] + fArray3[n5 - 119]);
        n7 = 1;
        n8 = -118;
        while (n7 <= 59) {
            n3 = n5 + n8;
            fArray5[n7] = 0.25f * (fArray3[n3 - 1] + fArray3[n3 + 1]) + 0.5f * fArray3[n3];
            ++n7;
            n8 += 2;
        }
        n3 = 60;
        n7 = 20;
        while (n7 < 60) {
            f4 = 0.0f;
            f3 = 0.0f;
            n8 = 0;
            while (n8 < 20) {
                float f6 = fArray4[n8];
                f2 = fArray4[n8 + 1];
                int n9 = n3 + n8 - n7;
                f4 += f6 * fArray5[n9] + f2 * fArray5[n9 + 1];
                f3 += f6 * fArray5[n9 - 1] + f2 * fArray5[n9];
                n8 += 2;
            }
            fArray6[n7 - 20] = f4;
            fArray6[n7 + 1 - 20] = f3;
            n7 += 2;
        }
        f4 = 0.0f;
        n8 = 0;
        while (n8 < 20) {
            f4 += fArray4[n8] * fArray5[n3 + n8 - n7];
            ++n8;
        }
        fArray6[n7 - 20] = f4;
        int n10 = 20;
        f5 = 0.0f;
        n8 = 20;
        while (n8 <= 60) {
            if (f5 < fArray6[n8 - 20]) {
                f5 = fArray6[n8 - 20];
                n10 = n8;
            }
            ++n8;
        }
        n7 = 2 * n10 - 1;
        if (n7 == 39) {
            n7 = 40;
        }
        if (n7 == 119) {
            n7 = 118;
        }
        f4 = 0.0f;
        f3 = 0.0f;
        float f7 = 0.0f;
        n8 = 0;
        while (n8 <= 39) {
            int n11 = n5 + n8 - n7;
            f2 = fArray[n2 + n8];
            f4 += f2 * fArray3[n11];
            f3 += f2 * fArray3[n11 - 1];
            f7 += f2 * fArray3[n11 - 2];
            ++n8;
        }
        fArray2[n7] = f4;
        fArray2[n7 + 1] = f3;
        fArray2[n7 + 2] = f7;
        nArray[0] = 40;
        f5 = 0.0f;
        n8 = n7;
        while (n8 <= n7 + 2) {
            if (f5 < fArray2[n8]) {
                f5 = fArray2[n8];
                nArray[0] = n8;
            }
            ++n8;
        }
        int n12 = n6++;
        int n13 = nArray[0];
        nArray3[n12] = n13;
        nArray2[n4] = n13;
        this.data_pParams = n6;
        return f5;
    }

    protected void doVAD() {
    }

    public boolean getComplexity() {
        return this.data_complexity_mode;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public boolean getVAD() {
        return this.data_vad_mode;
    }

    public void gsm_encode_frame(byte[] byArray, int n2, byte[] byArray2, int n3) {
        float[] fArray = this.encode_outsegment;
        float[] fArray2 = this.data_input;
        float[] fArray3 = this.data_first_res;
        float[] fArray4 = this.data_acf;
        float[] fArray5 = this.data_r;
        float[] fArray6 = this.data_LARpp;
        int[] nArray = this.encode_pitchArray;
        int n4 = 0;
        while (n4 < 160) {
            int n5 = byArray[2 * n4 + n2] & 0xFF | byArray[2 * n4 + n2 + 1] << 8;
            fArray2[n4] = (float)n5 * 3.0517578E-5f;
            ++n4;
        }
        this.PreProcessing(fArray2, fArray3);
        this.Autocorrelations(fArray3, fArray4);
        this.schurRecursion(fArray4, fArray5);
        this.rToLAR(fArray5, fArray6);
        this.latticeFilter(fArray6, fArray3);
        this.data_residual_Index = 120;
        int n6 = 0;
        while (n6 < 4) {
            this.data_blockNumber = n6;
            float f2 = this.data_complexity_mode ? this.calculatePitch(fArray3, n6 * 40, nArray) : this.calculatePitch_Light(fArray3, n6 * 40, nArray);
            int n7 = nArray[0];
            float f3 = this.calculatePitchGain(f2, n7);
            int n8 = this.analizeSecondResidual(f3, n7, fArray3, n6 * 40, fArray);
            this.quantizeSecondResidual(n8, fArray);
            this.data_residual_Index += 40;
            ++n6;
        }
        if (this.data_vad_mode) {
            this.doVAD();
        } else {
            this.frameType = 0;
        }
        this.packBitStream(byArray2, n3);
        System.arraycopy(this.data_residual, 160, this.data_residual, 0, 120);
    }

    public void gsm_encoder_close() {
    }

    public void gsm_encoder_reset() {
        this.data_buffer = 0.0f;
        this.data_scaledSample = 0.0f;
        int n2 = 0;
        while (n2 < this.data_first_res.length) {
            this.data_first_res[n2] = 0.0f;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.data_residual.length) {
            this.data_residual[n2] = 0.0f;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.data_u.length) {
            this.data_u[n2] = 0.0f;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.data_prevLARpp.length) {
            this.data_prevLARpp[n2] = 0.0f;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.data_wt.length) {
            this.data_wt[n2] = 0.0f;
            ++n2;
        }
        this.data_complexity_mode = true;
        this.data_vad_mode = false;
        this.data_Parameters[76] = 0;
        this.vadSupportFlag = false;
    }

    public boolean isVADsupported() {
        return this.vadSupportFlag;
    }

    void latticeFilter(float[] fArray, float[] fArray2) {
        float[] fArray3 = this.aux_rp;
        float[] fArray4 = this.data_u;
        float[] fArray5 = this.data_prevLARpp;
        int[] nArray = lut_k_start;
        int n2 = 0;
        while (n2 < 4) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6 = 0.75f - (float)n2 * 0.25f;
            float f7 = 1.0f - f6;
            int n3 = 1;
            while (n3 <= 8) {
                f5 = fArray5[n3] * f6 + fArray[n3] * f7;
                if (f5 > 0.0f) {
                    f4 = f5;
                    f3 = 1.0f;
                } else {
                    f4 = -f5;
                    f3 = -1.0f;
                }
                f2 = f4 < 0.675f ? f5 : (f4 < 1.225f ? f3 * (0.5f * f4 + 0.3375f) : f3 * (0.125f * f4 + 0.796875f));
                fArray3[n3] = f2;
                ++n3;
            }
            f2 = fArray4[0];
            f4 = fArray4[1];
            f3 = fArray4[2];
            f5 = fArray4[3];
            float f8 = fArray4[4];
            float f9 = fArray4[5];
            float f10 = fArray4[6];
            float f11 = fArray4[7];
            float f12 = fArray3[1];
            float f13 = fArray3[2];
            float f14 = fArray3[3];
            float f15 = fArray3[4];
            float f16 = fArray3[5];
            float f17 = fArray3[6];
            float f18 = fArray3[7];
            float f19 = fArray3[8];
            int n4 = nArray[n2 + 1];
            int n5 = nArray[n2];
            while (n5 < n4) {
                float f20;
                float f21 = f20 = fArray2[n5];
                float f22 = f2 + f12 * f20;
                f2 = f21;
                f21 = f22;
                f22 = f4 + f13 * (f20 += f12 * f2);
                f4 = f21;
                f21 = f22;
                f22 = f3 + f14 * (f20 += f13 * f4);
                f3 = f21;
                f21 = f22;
                f22 = f5 + f15 * (f20 += f14 * f3);
                f5 = f21;
                f21 = f22;
                f22 = f8 + f16 * (f20 += f15 * f5);
                f8 = f21;
                f21 = f22;
                f22 = f9 + f17 * (f20 += f16 * f8);
                f9 = f21;
                f21 = f22;
                f22 = f10 + f18 * (f20 += f17 * f9);
                f10 = f21;
                f21 = f22;
                f22 = f11 + f19 * (f20 += f18 * f10);
                f11 = f21;
                f21 = f22;
                fArray2[n5] = f20 += f19 * f11;
                ++n5;
            }
            fArray4[0] = f2;
            fArray4[1] = f4;
            fArray4[2] = f3;
            fArray4[3] = f5;
            fArray4[4] = f8;
            fArray4[5] = f9;
            fArray4[6] = f10;
            fArray4[7] = f11;
            fArray3[1] = f12;
            fArray3[2] = f13;
            fArray3[3] = f14;
            fArray3[4] = f15;
            fArray3[5] = f16;
            fArray3[6] = f17;
            fArray3[7] = f18;
            fArray3[8] = f19;
            ++n2;
        }
        System.arraycopy(fArray, 1, fArray5, 1, 8);
    }

    protected void packBitStream(byte[] byArray, int n2) {
        int[] nArray = this.data_Parameters;
        int n3 = n2;
        byArray[n3++] = (byte)(0xD0 | nArray[0] >> 2 & 0xF);
        byArray[n3++] = (byte)((nArray[0] & 3) << 6 | nArray[1] & 0x3F);
        byArray[n3++] = (byte)((nArray[2] & 0x1F) << 3 | nArray[3] >> 2 & 7);
        byArray[n3++] = (byte)((nArray[3] & 3) << 6 | (nArray[4] & 0xF) << 2 | nArray[5] >> 2 & 3);
        byArray[n3++] = (byte)((nArray[5] & 3) << 6 | (nArray[6] & 7) << 3 | nArray[7] & 7);
        int n4 = 8;
        int n5 = 0;
        while (n5 < 4) {
            byArray[n3++] = (byte)((nArray[n4++] & 0x7F) << 1 | nArray[n4] >> 1 & 1);
            byArray[n3++] = (byte)((nArray[n4++] & 1) << 7 | (nArray[n4++] & 3) << 5 | nArray[n4] >> 1 & 0x1F);
            byArray[n3++] = (byte)((nArray[n4++] & 1) << 7 | (nArray[n4++] & 7) << 4 | (nArray[n4++] & 7) << 1 | nArray[n4] >> 2 & 1);
            byArray[n3++] = (byte)((nArray[n4++] & 3) << 6 | (nArray[n4++] & 7) << 3 | nArray[n4++] & 7);
            byArray[n3++] = (byte)((nArray[n4++] & 7) << 5 | (nArray[n4++] & 7) << 2 | nArray[n4] >> 1 & 3);
            byArray[n3++] = (byte)((nArray[n4++] & 1) << 7 | (nArray[n4++] & 7) << 4 | (nArray[n4++] & 7) << 1 | nArray[n4] >> 2 & 1);
            byArray[n3++] = (byte)((nArray[n4++] & 3) << 6 | (nArray[n4++] & 7) << 3 | nArray[n4++] & 7);
            ++n5;
        }
    }

    private final void quantizeSecondResidual(int n2, float[] fArray) {
        int n3;
        float f2;
        int n4;
        int n5 = this.data_blockNumber;
        float[] fArray2 = this.data_currentxmax;
        float[] fArray3 = this.data_residual;
        int n6 = this.data_residual_Index;
        int[] nArray = lut_lg2s;
        int n7 = this.data_pParams;
        int[] nArray2 = this.data_Parameters;
        float f3 = 0.0f;
        int n8 = 0;
        while (n8 < 13) {
            float f4 = fArray[n2 + n8 * 3];
            if (f4 > f3) {
                f3 = f4;
            } else if (-f4 > f3) {
                f3 = -f4;
            }
            ++n8;
        }
        fArray2[n5] = f3;
        if (f3 < 0.015625f) {
            n4 = (int)(f3 * 1024.0f);
            nArray2[n7++] = n4;
            f2 = 31 + n4 * 32;
            n3 = (int)(f3 * 1024.0f);
        } else {
            n4 = (int)(32768.0f * f3);
            if ((n4 >>= 10) < 31) {
                n8 = nArray[n4];
                n3 = (int)((float)(n8 << 3) + f3 * (float)(1024 >> n8));
                nArray2[n7++] = n3;
                f2 = (256 << n8) + (32 << n8) - 1 + (n3 - 8 - 8 * n8) * (32 << n8);
            } else {
                nArray2[n7++] = 63;
                n3 = 63;
                f2 = 32767.0f;
            }
        }
        float f5 = 1.0f / f2;
        n8 = 0;
        while (n8 < 13) {
            n4 = (int)(fArray[n2 + n8 * 3] * f5 * 262144.0f);
            if (n4 > 7) {
                n4 = 7;
            } else if (n4 < -7) {
                n4 = -7;
            }
            n4 = n4 + 7 >> 1;
            nArray2[n7++] = n4;
            int n9 = n6 + n2 + n8 * 3;
            fArray3[n9] = fArray3[n9] + (0.25f * (float)n4 - 0.875f) * 3.0517578E-5f * f2;
            ++n8;
        }
        this.data_pParams = n7;
    }

    void rToLAR(float[] fArray, float[] fArray2) {
        float[] fArray3 = lut_MIC;
        float[] fArray4 = lut_MAC;
        float[] fArray5 = lut_A;
        float[] fArray6 = lut_B;
        float[] fArray7 = lut_INVA;
        int[] nArray = this.data_Parameters;
        int n2 = 0;
        float[] fArray8 = this.data_LAR;
        int n3 = 1;
        while (n3 <= 8) {
            float f2;
            if ((double)fArray[n3] >= 1.0) {
                f2 = fArray4[n3];
                fArray8[n3 - 1] = 1.625f;
            } else if ((double)fArray[n3] <= -1.0) {
                f2 = fArray3[n3];
                fArray8[n3 - 1] = -1.625f;
            } else {
                float f3;
                float f4;
                float f5 = fArray[n3];
                if (f5 > 0.0f) {
                    f4 = f5;
                    f3 = 1.0f;
                } else {
                    f4 = -f5;
                    f3 = -1.0f;
                }
                float f6 = f4 < 0.675f ? f5 : (f4 < 0.95f ? f3 * (2.0f * f4 - 0.675f) : f3 * (8.0f * f4 - 6.375f));
                fArray8[n3 - 1] = f6;
                f2 = fArray5[n3] * f6 + fArray6[n3];
                f2 = f2 >= 0.0f ? (float)((double)f2 + 0.5) : (float)((double)f2 - 0.5);
                f2 = (int)f2;
                if (f2 > fArray4[n3]) {
                    f2 = fArray4[n3];
                }
                if (f2 < fArray3[n3]) {
                    f2 = fArray3[n3];
                }
            }
            nArray[n2++] = (int)(f2 -= fArray3[n3]);
            fArray2[n3] = (f2 + fArray3[n3] - fArray6[n3]) * fArray7[n3];
            ++n3;
        }
        this.data_pParams = n2;
    }

    void schurRecursion(float[] fArray, float[] fArray2) {
        float[] fArray3 = this.aux_KK;
        float[] fArray4 = this.aux_P;
        if (fArray[0] == 0.0f) {
            int n2 = 1;
            while (n2 <= 8) {
                fArray2[n2] = 0.0f;
                ++n2;
            }
            return;
        }
        fArray4[0] = fArray[0];
        int n3 = 1;
        while (n3 <= 8) {
            float f2 = fArray[n3];
            fArray3[9 - n3] = f2;
            fArray4[n3] = f2;
            ++n3;
        }
        n3 = 1;
        while (n3 <= 8) {
            int n4;
            float f3;
            float f4 = f3 = fArray4[1] > 0.0f ? fArray4[1] : -fArray4[1];
            if (fArray4[0] < f3) {
                n4 = n3;
                while (n4 <= 8) {
                    fArray2[n4] = 0.0f;
                    ++n4;
                }
                return;
            }
            fArray2[n3] = f3 / fArray4[0];
            if ((double)fArray4[1] > 0.0) {
                fArray2[n3] = -fArray2[n3];
            }
            if (n3 == 8) {
                return;
            }
            fArray4[0] = fArray4[0] + fArray4[1] * fArray2[n3];
            n4 = 1;
            while (n4 <= 8 - n3) {
                fArray4[n4] = fArray4[n4 + 1] + fArray3[9 - n4] * fArray2[n3];
                fArray3[9 - n4] = fArray3[9 - n4] + fArray4[n4 + 1] * fArray2[n3];
                ++n4;
            }
            ++n3;
        }
    }

    public void setComplexity(boolean bl) {
        this.data_complexity_mode = bl;
    }

    public void setSIDupdateRate(int n2) {
        this.sidUpdateRate = n2;
    }

    public void setVAD(boolean bl) {
        this.data_vad_mode = this.vadSupportFlag ? bl : false;
    }
}

