/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.parser.video;

import com.ibm.media.parser.video.BadDataException;
import com.ibm.media.parser.video.MpegBufferThread;
import com.ibm.media.parser.video.jdk12CreateThreadAction;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.format.WavAudioFormat;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.jdk12;
import java.awt.Dimension;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class MpegParser
extends BasicPullParser {
    boolean saveOutputFlag = false;
    String AoutName = "Audio.mpg";
    String VoutName = "Video.mpg";
    FileOutputStream aout;
    FileOutputStream vout;
    boolean throwOutputFlag = false;
    boolean hideAudioTracks = false;
    boolean hideVideoTracks = false;
    static final long NO_PTS_VAL = -3333333L;
    private static final float EPSILON_PTS = 45000.0f;
    private static final float EPSILON_NS = 5.0E8f;
    private static final long PRE_ROLLING_DELTA_NS = 500000000L;
    private static final byte UNKNOWN_TYPE = 0;
    private static final byte AUDIO_TYPE = 1;
    private static final byte VIDEO_TYPE = 2;
    private static final byte SYS11172_TYPE = 3;
    private static final int AUDIO_TRACK_BUF_SIZE = 100000;
    private static final int VIDEO_TRACK_BUF_SIZE = 200000;
    private static final int PACK_START_CODE = 442;
    private static final int SYSTEM_HEADER_START_CODE = 443;
    private static final int PACKET_START_CODE_24 = 1;
    private static final int END_CODE = 441;
    private static final int MIN_STREAM_CODE = 188;
    private static final int MAX_STREAM_CODE = 255;
    private static final int PRIVATE_STREAM2_CODE = 191;
    private static final int VIDEO_PICTURE_START_CODE = 256;
    private static final int VIDEO_SEQUENCE_HEADER_CODE = 435;
    private static final int VIDEO_GROUP_START_CODE = 440;
    private static final int MAX_AUDIO_STREAMS = 32;
    private static final int MAX_VIDEO_STREAMS = 16;
    private static final int MAX_NUM_STREAMS = 48;
    private static final int MIN_AUDIO_ID = 0;
    private static final int MAX_AUDIO_ID = 31;
    private static final int MIN_VIDEO_ID = 32;
    private static final int MAX_VIDEO_ID = 47;
    private static int MAX_TRACKS_SUPPORTED = 48;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.mpeg"), new ContentDescriptor("video.mpeg"), new ContentDescriptor("audio.mpeg")};
    private PullSourceStream stream = null;
    private TrackList[] trackList = new TrackList[MAX_TRACKS_SUPPORTED];
    private Track[] tracks = null;
    private Track[] videoTracks = null;
    private Track[] audioTracks = null;
    private int videoCount = 0;
    private int audioCount = 0;
    private int numSupportedTracks = 0;
    private int numTracks = 0;
    private int numPackets = 0;
    private int initTmpBufLen;
    private byte[] initTmpStreamBuf;
    private byte streamType = 0;
    private long streamContentLength = 0L;
    private SystemHeader sysHeader = new SystemHeader();
    private boolean sysHeaderSeen = false;
    boolean EOMflag = false;
    boolean parserErrorFlag = false;
    private boolean durationInitialized = false;
    private boolean sysPausedFlag = false;
    private boolean seekableStreamFlag = false;
    private boolean randomAccessStreamFlag = true;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    private long startLocation = 0L;
    private Time durationNs = Duration.DURATION_UNKNOWN;
    private Time lastSetPositionTime = new Time(0L);
    private long startPTS = -3333333L;
    long currentPTS = -3333333L;
    long endPTS = -3333333L;
    private long AVstartTimeNs = 0L;
    private long AVcurrentTimeNs = 0L;
    private long AVlastTimeNs = 0L;
    private long lastAudioNs = 0L;
    private MpegBufferThread mpThread = null;
    static int[][][] bitrates;
    static int[][] samplerates;
    static /* synthetic */ Class class$com$ibm$media$parser$video$MpegBufferThread;
    static /* synthetic */ Class array$B;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
        int[][][] nArrayArray = new int[4][][];
        int[][] nArrayArray2 = new int[4][];
        nArrayArray2[0] = new int[]{-1};
        int[] nArray = new int[16];
        nArray[1] = 8;
        nArray[2] = 16;
        nArray[3] = 24;
        nArray[4] = 32;
        nArray[5] = 40;
        nArray[6] = 48;
        nArray[7] = 56;
        nArray[8] = 64;
        nArray[9] = 80;
        nArray[10] = 96;
        nArray[11] = 112;
        nArray[12] = 128;
        nArray[13] = 144;
        nArray[14] = 160;
        nArray[15] = -1;
        nArrayArray2[1] = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 8;
        nArray2[2] = 16;
        nArray2[3] = 24;
        nArray2[4] = 32;
        nArray2[5] = 40;
        nArray2[6] = 48;
        nArray2[7] = 56;
        nArray2[8] = 64;
        nArray2[9] = 80;
        nArray2[10] = 96;
        nArray2[11] = 112;
        nArray2[12] = 128;
        nArray2[13] = 144;
        nArray2[14] = 160;
        nArray2[15] = -1;
        nArrayArray2[2] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 32;
        nArray3[2] = 48;
        nArray3[3] = 56;
        nArray3[4] = 64;
        nArray3[5] = 80;
        nArray3[6] = 96;
        nArray3[7] = 112;
        nArray3[8] = 128;
        nArray3[9] = 144;
        nArray3[10] = 160;
        nArray3[11] = 176;
        nArray3[12] = 192;
        nArray3[13] = 224;
        nArray3[14] = 256;
        nArray3[15] = -1;
        nArrayArray2[3] = nArray3;
        nArrayArray[0] = nArrayArray2;
        nArrayArray[1] = new int[][]{{-1}};
        int[][] nArrayArray3 = new int[4][];
        nArrayArray3[0] = new int[]{-1};
        int[] nArray4 = new int[16];
        nArray4[1] = 8;
        nArray4[2] = 16;
        nArray4[3] = 24;
        nArray4[4] = 32;
        nArray4[5] = 40;
        nArray4[6] = 48;
        nArray4[7] = 56;
        nArray4[8] = 64;
        nArray4[9] = 80;
        nArray4[10] = 96;
        nArray4[11] = 112;
        nArray4[12] = 128;
        nArray4[13] = 144;
        nArray4[14] = 160;
        nArray4[15] = -1;
        nArrayArray3[1] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[1] = 8;
        nArray5[2] = 16;
        nArray5[3] = 24;
        nArray5[4] = 32;
        nArray5[5] = 40;
        nArray5[6] = 48;
        nArray5[7] = 56;
        nArray5[8] = 64;
        nArray5[9] = 80;
        nArray5[10] = 96;
        nArray5[11] = 112;
        nArray5[12] = 128;
        nArray5[13] = 144;
        nArray5[14] = 160;
        nArray5[15] = -1;
        nArrayArray3[2] = nArray5;
        int[] nArray6 = new int[16];
        nArray6[1] = 32;
        nArray6[2] = 48;
        nArray6[3] = 56;
        nArray6[4] = 64;
        nArray6[5] = 80;
        nArray6[6] = 96;
        nArray6[7] = 112;
        nArray6[8] = 128;
        nArray6[9] = 144;
        nArray6[10] = 160;
        nArray6[11] = 176;
        nArray6[12] = 192;
        nArray6[13] = 224;
        nArray6[14] = 256;
        nArray6[15] = -1;
        nArrayArray3[3] = nArray6;
        nArrayArray[2] = nArrayArray3;
        int[][] nArrayArray4 = new int[4][];
        nArrayArray4[0] = new int[]{-1};
        int[] nArray7 = new int[16];
        nArray7[1] = 32;
        nArray7[2] = 40;
        nArray7[3] = 48;
        nArray7[4] = 56;
        nArray7[5] = 64;
        nArray7[6] = 80;
        nArray7[7] = 96;
        nArray7[8] = 112;
        nArray7[9] = 128;
        nArray7[10] = 160;
        nArray7[11] = 192;
        nArray7[12] = 224;
        nArray7[13] = 256;
        nArray7[14] = 320;
        nArray7[15] = -1;
        nArrayArray4[1] = nArray7;
        int[] nArray8 = new int[16];
        nArray8[1] = 32;
        nArray8[2] = 48;
        nArray8[3] = 56;
        nArray8[4] = 64;
        nArray8[5] = 80;
        nArray8[6] = 96;
        nArray8[7] = 112;
        nArray8[8] = 128;
        nArray8[9] = 160;
        nArray8[10] = 192;
        nArray8[11] = 224;
        nArray8[12] = 256;
        nArray8[13] = 320;
        nArray8[14] = 384;
        nArray8[15] = -1;
        nArrayArray4[2] = nArray8;
        int[] nArray9 = new int[16];
        nArray9[1] = 32;
        nArray9[2] = 64;
        nArray9[3] = 96;
        nArray9[4] = 128;
        nArray9[5] = 160;
        nArray9[6] = 192;
        nArray9[7] = 224;
        nArray9[8] = 256;
        nArray9[9] = 288;
        nArray9[10] = 320;
        nArray9[11] = 352;
        nArray9[12] = 384;
        nArray9[13] = 416;
        nArray9[14] = 448;
        nArray9[15] = -1;
        nArrayArray4[3] = nArray9;
        nArrayArray[3] = nArrayArray4;
        bitrates = nArrayArray;
        samplerates = new int[][]{{11025, 12000, 8000, -1}, {-1}, {22050, 24000, 16000, -1}, {44100, 48000, 32000, -1}};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        this.stop();
        this.flushInnerBuffers();
        super.close();
        if (this.mpThread != null) {
            this.mpThread.kill();
        }
    }

    private long convBytesToTimeAV(long l2) {
        long l3;
        if (this.trackList[0] == null) {
            return 0L;
        }
        if (this.streamType == 1) {
            if (((Audio)this.trackList[0].media).bitRate == 0) {
                l3 = 0L;
            } else {
                l3 = (l2 << 3) / (long)((Audio)this.trackList[0].media).bitRate;
                l3 *= 1000000L;
            }
        } else if (((Video)this.trackList[0].media).bitRate == 0) {
            l3 = 0L;
        } else {
            l3 = (l2 << 3) / (long)((Video)this.trackList[0].media).bitRate;
            l3 *= 1000000000L;
        }
        return l3;
    }

    private long convNanosecondsToPTS(long l2) {
        return l2 * 9L / 100000L;
    }

    private long convPTStoNanoseconds(long l2) {
        return l2 * 100000L / 9L;
    }

    private long convTimeToBytesAV(long l2) {
        long l3;
        if (this.streamType == 1) {
            l3 = (l2 >> 3) * (long)((Audio)this.trackList[0].media).bitRate;
            l3 /= 1000000L;
        } else {
            l3 = (l2 >> 3) * (long)((Video)this.trackList[0].media).bitRate;
            l3 /= 1000000000L;
        }
        return l3;
    }

    private int detectStreamType(byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (this.streamType != 0) {
            return 0;
        }
        try {
            this.readBytes(this.stream, byArray, 4);
            block7: while (!bl && n2 < byArray.length - 5) {
                int n5 = (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                switch (n5) {
                    case 442: {
                        this.readBytes(this.stream, byArray, ++n2 + 3, 1);
                        if ((byArray[n2 + 3] & 0xFFFFFFF1) != 33) continue block7;
                        this.streamType = (byte)3;
                        bl = true;
                        continue block7;
                    }
                    case 435: {
                        if (n2 == 0) {
                            this.streamType = (byte)2;
                            bl = true;
                        }
                    }
                    case 256: 
                    case 440: {
                        ++n3;
                        break;
                    }
                    default: {
                        if ((n5 & 0xFFF00000) != -1048576 || (n5 & 0x60000) == 0 || !this.isValidMp3Header(n5)) break;
                        ++n4;
                        this.streamType = 1;
                        bl = true;
                        this.startLocation = n2;
                    }
                }
                this.readBytes(this.stream, byArray, ++n2 + 3, 1);
            }
        }
        catch (IOException iOException) {
            if (this.streamType == 0) {
                if (n3 > 0) {
                    this.streamType = (byte)2;
                } else if (n4 > 0) {
                    this.streamType = 1;
                }
            }
            this.updateEOMState();
            this.EOMflag = true;
            throw iOException;
        }
        if (this.streamType == 0) {
            if (n3 > 4) {
                this.streamType = (byte)2;
            } else if (n4 > 20) {
                this.streamType = 1;
            }
        }
        if (this.seekableStreamFlag && this.streamType == 1) {
            int n6 = -1;
            Seekable seekable = (Seekable)((Object)this.stream);
            long l2 = seekable.tell();
            seekable.seek(this.startLocation);
            int n7 = this.readInt(this.stream);
            int n8 = n7 >>> 19 & 3;
            int n9 = n7 >>> 17 & 3;
            int n10 = n7 >>> 12 & 0xF;
            int n11 = n7 >>> 10 & 3;
            int n12 = n7 >>> 9 & 1;
            int n13 = n7 >>> 6 & 3;
            int n14 = bitrates[n8][n9][n10];
            int n15 = (n8 & 1) == 1 ? (n13 != 3 ? 36 : 21) : (n13 != 3 ? 21 : 13);
            seekable.seek(n15);
            String string = this.readString(this.stream);
            if (string.equals("Xing")) {
                int n16 = this.readInt(this.stream);
                int n17 = this.readInt(this.stream);
                int n18 = this.readInt(this.stream);
                int n19 = samplerates[n8][n11];
                int n20 = 144000 * n14 / n19 + n12;
                n6 = n20 * n17 / (n14 * 125);
                if (n6 > 0) {
                    this.durationInitialized = true;
                    this.durationNs = new Time((double)n6);
                }
            }
            seekable.seek(l2);
        }
        return n2 + 4;
    }

    private int extractAudioInfo(byte[] byArray, TrackList trackList, int n2, boolean bl) throws IOException, BadDataException {
        Audio audio = new Audio();
        int[] nArray = new int[]{44100, 48000, 32000};
        short[] sArray = new short[15];
        sArray[1] = 32;
        sArray[2] = 48;
        sArray[3] = 56;
        sArray[4] = 64;
        sArray[5] = 80;
        sArray[6] = 96;
        sArray[7] = 112;
        sArray[8] = 128;
        sArray[9] = 160;
        sArray[10] = 192;
        sArray[11] = 224;
        sArray[12] = 256;
        sArray[13] = 320;
        sArray[14] = 384;
        short[] sArray2 = sArray;
        short[] sArray3 = new short[15];
        sArray3[1] = 8;
        sArray3[2] = 16;
        sArray3[3] = 24;
        sArray3[4] = 32;
        sArray3[5] = 40;
        sArray3[6] = 48;
        sArray3[7] = 56;
        sArray3[8] = 64;
        sArray3[9] = 80;
        sArray3[10] = 96;
        sArray3[11] = 112;
        sArray3[12] = 128;
        sArray3[13] = 144;
        sArray3[14] = 160;
        short[] sArray4 = sArray3;
        int n3 = bl ? n2 : this.readBytes(this.stream, byArray, n2);
        int n4 = (int)this.startLocation;
        while (n4 < n3 - 3) {
            if (byArray[n4] == -1 && (byArray[n4 + 1] & 0xFFFFFFF0) == -16) {
                audio.ID = (byArray[n4 + 1] & 8) >> 3;
                audio.layer = 4 - ((byArray[n4 + 1] & 6) >> 1);
                audio.protection = byArray[n4 + 1] & 1;
                int n5 = (byArray[n4 + 2] & 0xF0) >> 4;
                int n6 = (byArray[n4 + 2] & 0xC) >> 2;
                if (n6 < 0 || n6 >= nArray.length) {
                    throw new BadDataException("Non Standard sample rates not supported");
                }
                audio.mode = (byArray[n4 + 3] & 0xC0) >> 6;
                audio.modeExt = (byArray[n4 + 3] & 0x30) >> 4;
                audio.channels = audio.mode == 3 ? 1 : 2;
                audio.copyright = (byArray[n4 + 3] & 8) >> 3;
                audio.original = (byArray[n4 + 3] & 4) >> 2;
                audio.emphasis = byArray[n4 + 3] & 3;
                boolean bl2 = audio.valid = n5 != 15;
                if (audio.ID == 1) {
                    audio.sampleRate = nArray[n6];
                    audio.bitRate = audio.layer == 3 ? (n5 < 2 ? sArray2[n5] : (n5 == 2 ? 40 : sArray2[n5 - 1])) : (audio.layer == 2 ? sArray2[n5] : n5 << 5);
                } else {
                    audio.sampleRate = nArray[n6] >> 1;
                    audio.bitRate = audio.layer == 3 || audio.layer == 2 ? sArray4[n5] : (n5 < 9 ? sArray2[n5] : (n5 == 9 ? 144 : (n5 == 10 ? sArray2[n5 - 1] : (n5 == 11 ? 176 : sArray2[n5 - 2]))));
                }
                trackList.readFrameSize = audio.bitRate * 1000 >> 3;
                trackList.infoFlag = true;
                trackList.media = audio;
                break;
            }
            ++n4;
        }
        return n3;
    }

    private int extractStreamInfo(byte[] byArray, int n2, int n3, boolean bl) throws IOException, BadDataException {
        int n4 = 0;
        TrackList trackList = this.trackList[n2];
        if (trackList.trackType == 0) {
            n4 = bl ? this.streamType : (n2 < 32 ? 1 : 2);
            trackList.init((byte)n4);
            this.sysHeader.streamFlags[n2] = true;
            trackList.startPTS = this.currentPTS;
        }
        int n5 = n4 == 1 ? this.extractAudioInfo(byArray, trackList, n3, bl) : this.extractVideoInfo(byArray, trackList, n3, bl);
        if (trackList.infoFlag) {
            if (bl) {
                this.tracks[0] = new MediaTrack(trackList);
            } else {
                this.tracks[this.numTracks] = new MediaTrack(trackList);
                ++this.numTracks;
            }
        }
        return n5;
    }

    private int extractVideoInfo(byte[] byArray, TrackList trackList, int n2, boolean bl) throws IOException, BadDataException {
        Video video = new Video();
        float[] fArray = new float[16];
        fArray[1] = 1.0f;
        fArray[2] = 0.6735f;
        fArray[3] = 0.7031f;
        fArray[4] = 0.7615f;
        fArray[5] = 0.8055f;
        fArray[6] = 0.8437f;
        fArray[7] = 0.8935f;
        fArray[8] = 0.9375f;
        fArray[9] = 0.9815f;
        fArray[10] = 1.0255f;
        fArray[11] = 1.0695f;
        fArray[12] = 1.125f;
        fArray[13] = 1.1575f;
        fArray[14] = 1.2015f;
        fArray[15] = 1.0f;
        float[] fArray2 = fArray;
        float[] fArray3 = new float[16];
        fArray3[1] = 23.976f;
        fArray3[2] = 24.0f;
        fArray3[3] = 25.0f;
        fArray3[4] = 29.97f;
        fArray3[5] = 30.0f;
        fArray3[6] = 50.0f;
        fArray3[7] = 59.94f;
        fArray3[8] = 60.0f;
        fArray3[9] = -1.0f;
        fArray3[10] = -1.0f;
        fArray3[11] = -1.0f;
        fArray3[12] = -1.0f;
        fArray3[13] = -1.0f;
        fArray3[14] = -1.0f;
        fArray3[15] = -1.0f;
        float[] fArray4 = fArray3;
        int n3 = bl ? n2 : this.readBytes(this.stream, byArray, n2);
        int n4 = 0;
        while (n4 < n3 - 10) {
            int n5 = byArray[n4] << 24 & 0xFF000000 | byArray[n4 + 1] << 16 & 0xFF0000 | byArray[n4 + 2] << 8 & 0xFF00 | byArray[n4 + 3] & 0xFF;
            if (n5 == 435) {
                video.width = (byArray[n4 + 4] & 0xFF) << 4;
                video.width |= byArray[n4 + 4 + 1] >> 4 & 0xF;
                video.height = (byArray[n4 + 4 + 1] & 0xF) << 8;
                video.height |= byArray[n4 + 4 + 2] & 0xFF;
                int n6 = (byArray[n4 + 4 + 3] & 0xF0) >> 4;
                video.pelAspectRatio = fArray2[n6];
                n6 = byArray[n4 + 4 + 3] & 0xF;
                video.pictureRate = fArray4[n6];
                n6 = (byArray[n4 + 4 + 4] & 0xFF) << 10 | (byArray[n4 + 4 + 5] & 0xFF) << 2 | (byArray[n4 + 4 + 6] & 0xC0) >> 6;
                video.bitRate = n6 * 400;
                if ((double)video.pelAspectRatio == 0.0 || (double)video.pictureRate == 0.0) {
                    throw new BadDataException("video header corrupted");
                }
                if ((double)video.pictureRate < 23.0) {
                    trackList.readFrameSize = 65536;
                } else {
                    trackList.readFrameSize = video.bitRate >> 3;
                    if (trackList.readFrameSize > 100000) {
                        trackList.readFrameSize = 100000;
                    }
                }
                trackList.infoFlag = true;
                trackList.media = video;
                break;
            }
            ++n4;
        }
        return n3;
    }

    void flushInnerBuffers() {
        int n2 = 0;
        while (n2 < this.numTracks) {
            if (this.tracks[n2] != null) {
                TrackList trackList = ((MediaTrack)this.tracks[n2]).getTrackInfo();
                CircularBuffer circularBuffer = trackList.bufQ;
                synchronized (circularBuffer) {
                    trackList.flushFlag = true;
                    trackList.bufQ.notifyAll();
                }
                trackList.flushBuffer();
            }
            ++n2;
        }
    }

    public Time getDuration() {
        if (this.durationInitialized) {
            return this.durationNs;
        }
        if (this.EOMflag) {
            this.durationInitialized = true;
        }
        return this.durationNs;
    }

    private long getLocation() {
        return this.getLocation(this.stream);
    }

    public Time getMediaTime() {
        Time time;
        if (this.streamType == 3) {
            time = this.currentPTS == -3333333L ? new Time(0L) : new Time(this.convPTStoNanoseconds(this.currentPTS - this.startPTS));
        } else {
            this.AVcurrentTimeNs = this.convBytesToTimeAV(this.getLocation(this.stream));
            time = new Time(this.AVcurrentTimeNs);
        }
        return time;
    }

    public String getName() {
        return "Parser for MPEG-1 file format";
    }

    private int getStreamID(byte by) {
        return (by & 0xFF) - 192;
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.streamType == 3) {
            if (this.hideAudioTracks && this.videoTracks != null) {
                return this.videoTracks;
            }
            if (this.hideVideoTracks && this.audioTracks != null) {
                return this.audioTracks;
            }
        }
        if (this.tracks != null) {
            return this.tracks;
        }
        try {
            this.initTmpBufLen = 100000;
            this.initTmpStreamBuf = new byte[this.initTmpBufLen];
            this.initTmpBufLen = this.detectStreamType(this.initTmpStreamBuf);
            switch (this.streamType) {
                case 1: 
                case 2: {
                    this.initTrackAudioVideoOnly();
                    break;
                }
                case 3: {
                    this.initTrackSystemStream();
                    break;
                }
                default: {
                    throw new BadHeaderException("Couldn't detect stream type");
                }
            }
            this.initDuration();
            if (this.saveOutputFlag) {
                this.aout = new FileOutputStream(this.AoutName);
                this.vout = new FileOutputStream(this.VoutName);
            }
            if (this.streamType == 3) {
                Object object;
                if (jmfSecurity != null) {
                    object = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object = "thread";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object = jdk12CreateThreadAction.cons;
                        this.mpThread = (MpegBufferThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$ibm$media$parser$video$MpegBufferThread != null ? class$com$ibm$media$parser$video$MpegBufferThread : (class$com$ibm$media$parser$video$MpegBufferThread = MpegParser.class$("com.ibm.media.parser.video.MpegBufferThread"))));
                    }
                    catch (Exception exception) {
                        System.err.println("MpegParser: Caught Exception " + exception);
                    }
                } else {
                    this.mpThread = new MpegBufferThread();
                }
                if (this.mpThread != null) {
                    this.mpThread.setParser(this);
                    this.mpThread.start();
                }
                if (this.saveOutputFlag || this.throwOutputFlag) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.streamType == 3) {
                if (this.hideAudioTracks) {
                    return this.videoTracks;
                }
                if (this.hideVideoTracks) {
                    return this.audioTracks;
                }
            }
            return this.tracks;
        }
        catch (BadDataException badDataException) {
            this.parserErrorFlag = true;
            throw new BadHeaderException("Bad data");
        }
        catch (BadHeaderException badHeaderException) {
            this.parserErrorFlag = true;
            throw badHeaderException;
        }
        catch (IOException iOException) {
            this.updateEOMState();
            this.EOMflag = true;
            throw iOException;
        }
    }

    private void initDuration() {
        if (this.streamContentLength != -1L) {
            if (this.streamType == 3) {
                if (this.randomAccessStreamFlag) {
                    this.initDurationSystemSeekableRA();
                }
            } else {
                this.updateDurationAudioVideoOnly();
            }
        }
    }

    private void initDurationSystemSeekableRA() {
        long l2;
        long l3 = 0L;
        int n2 = this.numPackets;
        boolean bl = this.EOMflag;
        l3 = ((Seekable)((Object)this.stream)).tell();
        if (this.startPTS == -3333333L) {
            this.EOMflag = false;
            ((Seekable)((Object)this.stream)).seek(0L);
            try {
                this.mpegSystemParseBitstream(true, 65536L, false, -3333333L);
            }
            catch (Exception exception) {}
        }
        if (this.startPTS == -3333333L) {
            this.startPTS = 0L;
        }
        if (this.endPTS == -3333333L) {
            this.EOMflag = false;
            this.currentPTS = -3333333L;
            l2 = this.streamContentLength - 131072L;
            if (l2 < 0L) {
                l2 = 0L;
            }
            ((Seekable)((Object)this.stream)).seek(l2);
            try {
                this.mpegSystemParseBitstream(true, 131072L, false, -3333333L);
            }
            catch (Exception exception) {}
            this.endPTS = this.currentPTS;
        }
        if (this.endPTS == -3333333L) {
            this.endPTS = this.startPTS;
        }
        if ((l2 = this.endPTS - this.startPTS) < 0L) {
            l2 = 0L;
            this.parserErrorFlag = true;
        }
        this.durationNs = new Time(this.convPTStoNanoseconds(l2));
        this.lastSetPositionTime = new Time(this.convPTStoNanoseconds(this.startPTS));
        ((Seekable)((Object)this.stream)).seek(l3);
        this.EOMflag = bl;
        this.numPackets = n2;
        this.durationInitialized = true;
    }

    private void initTrackAudioVideoOnly() throws IOException, BadHeaderException, BadDataException {
        int n2;
        int n3 = 0;
        this.numTracks = 1;
        this.tracks = new Track[1];
        this.trackList[0] = new TrackList();
        int n4 = n2 = this.streamType == 1 ? 100000 : 200000;
        if (this.initTmpBufLen < n2) {
            if (n2 > this.initTmpStreamBuf.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.initTmpStreamBuf, 0, byArray, 0, this.initTmpBufLen);
                this.initTmpStreamBuf = byArray;
            }
            try {
                n3 = this.readBytes(this.stream, this.initTmpStreamBuf, this.initTmpBufLen, n2 - this.initTmpBufLen);
            }
            catch (IOException iOException) {
                this.updateEOMState();
                this.EOMflag = true;
            }
            this.initTmpBufLen += n3;
        }
        TrackList trackList = this.trackList[0];
        do {
            this.extractStreamInfo(this.initTmpStreamBuf, 0, this.initTmpBufLen, true);
            if (trackList.infoFlag) break;
            try {
                n3 = this.readBytes(this.stream, this.initTmpStreamBuf, n2);
            }
            catch (IOException iOException) {
                this.updateEOMState();
                this.EOMflag = true;
                break;
            }
            this.initTmpBufLen = n3;
        } while (!trackList.infoFlag);
        if (!trackList.infoFlag) {
            this.numTracks = 0;
            this.tracks = null;
            throw new BadHeaderException("Sorry, No tracks found");
        }
        ((Seekable)((Object)this.stream)).seek(0L);
        this.initTmpBufLen = 0;
        this.EOMflag = false;
    }

    private void initTrackSystemStream() throws IOException, BadHeaderException, BadDataException {
        int n2;
        TrackList trackList;
        this.tracks = new Track[MAX_TRACKS_SUPPORTED];
        int n3 = 0;
        while (n3 < this.tracks.length) {
            this.tracks[n3] = null;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.trackList.length) {
            this.trackList[n3] = null;
            ++n3;
        }
        this.mpegSystemParseBitstream(false, 0L, true, -3333333L);
        if (this.numTracks == 0) {
            throw new BadHeaderException("Sorry, No tracks found");
        }
        Track[] trackArray = new Track[this.numTracks];
        n3 = 0;
        while (n3 < this.numTracks) {
            trackArray[n3] = this.tracks[n3];
            ++n3;
        }
        this.tracks = trackArray;
        if (this.hideAudioTracks) {
            n3 = 0;
            while (n3 < this.numTracks) {
                if (this.tracks[n3] != null) {
                    trackList = ((MediaTrack)this.tracks[n3]).getTrackInfo();
                    if (trackList.trackType == 2) {
                        ++this.videoCount;
                    }
                }
                ++n3;
            }
            if (this.videoCount == 0) {
                throw new BadHeaderException("Sorry, No video tracks found");
            }
            this.videoTracks = new Track[this.videoCount];
            n3 = 0;
            n2 = 0;
            while (n3 < this.numTracks) {
                if (this.tracks[n3] != null) {
                    trackList = ((MediaTrack)this.tracks[n3]).getTrackInfo();
                    if (trackList.trackType == 2) {
                        this.videoTracks[n2] = this.tracks[n3];
                    }
                }
                ++n3;
            }
        }
        if (this.hideVideoTracks) {
            n3 = 0;
            while (n3 < this.numTracks) {
                if (this.tracks[n3] != null) {
                    trackList = ((MediaTrack)this.tracks[n3]).getTrackInfo();
                    if (trackList.trackType == 1) {
                        ++this.audioCount;
                    }
                }
                ++n3;
            }
            if (this.audioCount == 0) {
                throw new BadHeaderException("Sorry, No video tracks found");
            }
            this.audioTracks = new Track[this.audioCount];
            n3 = 0;
            n2 = 0;
            while (n3 < this.numTracks) {
                if (this.tracks[n3] != null) {
                    trackList = ((MediaTrack)this.tracks[n3]).getTrackInfo();
                    if (trackList.trackType == 1) {
                        this.audioTracks[n2] = this.tracks[n3];
                    }
                }
                ++n3;
            }
        }
    }

    private boolean isValidMp3Header(int n2) {
        return (n2 >>> 21 & 0x7FF) == 2047 && (n2 >>> 19 & 3) != 1 && (n2 >>> 17 & 3) != 0 && (n2 >>> 12 & 0xF) != 0 && (n2 >>> 12 & 0xF) != 15 && (n2 >>> 10 & 3) != 3 && (n2 & 3) != 2;
    }

    long mpegSystemParseBitstream(boolean bl, long l2, boolean bl2, long l3) throws IOException, BadHeaderException, BadDataException {
        long l4;
        byte[] byArray = new byte[1];
        int n2 = 0;
        boolean bl3 = true;
        boolean bl4 = false;
        long l5 = l4 = this.getLocation(this.stream);
        long l6 = l4;
        long l7 = l4 + 4L;
        long l8 = -3333333L;
        long l9 = -3333333L;
        block5: while (!this.sysPausedFlag && !this.EOMflag || bl || bl2) {
            if (bl2 && !this.needingMore()) break;
            if (bl) {
                if (this.getLocation(this.stream) - l4 > l2) break;
                if (l3 != -3333333L) {
                    if (l3 < this.startPTS) {
                        return -1L;
                    }
                    if (l3 <= this.currentPTS) {
                        if (l3 == this.currentPTS) {
                            return l5;
                        }
                        this.currentPTS = l8;
                        return l6;
                    }
                }
            }
            if (bl3) {
                n2 = this.readInt(this.stream, true);
            } else {
                this.readBytes(this.stream, byArray, 1);
                n2 = n2 << 8 & 0xFFFFFF00 | byArray[0] & 0xFF;
            }
            switch (n2) {
                case 442: {
                    this.parsePackHeader();
                    bl3 = true;
                    bl4 = true;
                    break;
                }
                case 443: {
                    this.parseSystemHeader();
                    bl3 = true;
                    break;
                }
                case 441: {
                    this.EOMflag = true;
                    if (this.endPTS == -3333333L) {
                        this.endPTS = this.currentPTS;
                    }
                    if (bl && l3 == -3333333L) continue block5;
                    this.updateEOMState();
                    break;
                }
                default: {
                    if (n2 >> 8 == 1 && (!bl || bl4 & bl)) {
                        if (bl && l3 != -3333333L) {
                            l7 = this.getLocation(this.stream);
                            l9 = this.currentPTS;
                        }
                        byte by = (byte)(n2 & 0xFF);
                        this.parsePacket(by, bl);
                        bl3 = true;
                        if (!bl || l3 == -3333333L || l9 == this.currentPTS) continue block5;
                        l8 = l9;
                        l6 = l5;
                        l5 = l7 - 4L;
                        break;
                    }
                    bl3 = false;
                    break;
                }
            }
        }
        return this.EOMflag ? -2L : -1L;
    }

    boolean needingMore() {
        int n2 = 0;
        while (n2 < this.numTracks) {
            if (this.tracks[n2] != null) {
                TrackList trackList = ((MediaTrack)this.tracks[n2]).getTrackInfo();
                if (trackList.bufQ.canRead()) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void parsePackHeader() throws IOException, BadDataException {
        byte[] byArray = new byte[1];
        this.readBytes(this.stream, byArray, 1);
        if ((byArray[0] & 0xFFFFFFF0) != 32) {
            throw new BadDataException("invalid pack header");
        }
        if ((byArray[0] & 1) != 1) {
            throw new BadDataException("illegal marker bit");
        }
        this.skip(this.stream, 7);
    }

    private void parsePacket(byte by, boolean bl) throws IOException, BadDataException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = null;
        byte[] byArray2 = new byte[1];
        if ((by & 0xFF) < 188 || (by & 0xFF) > 255) {
            throw new BadDataException("invalid stream(track) number");
        }
        int n6 = this.getStreamID(by);
        short s = this.readShort(this.stream, true);
        byArray2[0] = by;
        if ((byArray2[0] & 0xFF) != 191) {
            do {
                this.readBytes(this.stream, byArray2, 1);
                ++n2;
            } while (byArray2[0] == -1);
            if ((byArray2[0] & 0xFFFFFFC0) == 64) {
                n4 = (byArray2[0] & 0x20) >> 5;
                n3 = (byArray2[0] & 0x1F) << 8;
                this.readBytes(this.stream, byArray2, 1);
                n3 |= byArray2[0];
                this.readBytes(this.stream, byArray2, 1);
                n2 += 2;
            }
            if ((byArray2[0] & 0xFFFFFFE0) == 32) {
                long l2 = (long)(byArray2[0] & 0xE) << 29;
                l2 = l2 << 31 >> 31;
                if ((byArray2[0] & 1) != 1) {
                    throw new BadDataException("illegal marker bit");
                }
                int n7 = this.readInt(this.stream, true);
                n2 += 4;
                if ((n7 & 0x10001) != 65537) {
                    throw new BadDataException("illegal marker bit");
                }
                int n8 = (n7 & 0xFFFE0000) >> 2;
                l2 |= (long)(n8 & 0x3FFFFFFF);
                this.currentPTS = l2 |= (long)((n7 & 0xFFFE) >> 1);
                if (this.startPTS == -3333333L) {
                    this.startPTS = this.currentPTS;
                    if (this.startPTS > 0L && (float)this.startPTS <= 45000.0f) {
                        this.startPTS = 0L;
                    }
                }
                if ((byArray2[0] & 0xFFFFFFF0) == 48) {
                    this.skip(this.stream, 5);
                    n2 += 5;
                }
            } else if (byArray2[0] != 15) {
                throw new BadDataException("invalid packet");
            }
        }
        int n9 = s - n2;
        if (bl) {
            this.skip(this.stream, n9);
            return;
        }
        if (n6 < 0 || n6 >= 48) {
            this.skip(this.stream, n9);
        } else {
            if (this.trackList[n6] == null) {
                this.trackList[n6] = new TrackList();
            }
            TrackList trackList = this.trackList[n6];
            if (!trackList.infoFlag) {
                byArray = new byte[n9];
                n5 = this.extractStreamInfo(byArray, n6, n9, false);
            }
            if (!trackList.infoFlag) {
                this.trackList[n6] = null;
                if (n5 < n9) {
                    this.skip(this.stream, n9 - n5);
                }
            } else {
                if (this.startPTS == -3333333L) {
                    trackList.startPTS = this.currentPTS;
                }
                trackList.copyStreamDataToInnerBuffer(byArray, n5, n9 - n5, this.currentPTS);
                ++trackList.numPackets;
                if (n9 > trackList.maxPacketSize) {
                    trackList.maxPacketSize = n9;
                }
            }
        }
        ++this.numPackets;
    }

    private void parseSystemHeader() throws IOException, BadHeaderException {
        byte[] byArray = new byte[1];
        int n2 = this.readShort(this.stream, true);
        if (this.sysHeaderSeen) {
            this.skip(this.stream, n2);
        } else {
            this.sysHeader.resetSystemHeader();
            this.sysHeader.headerLen = n2;
            int n3 = this.readInt(this.stream, true);
            n2 -= 4;
            if ((n3 & 0x80000100) != -2147483392) {
                throw new BadHeaderException("illegal marker bits in system header");
            }
            this.sysHeader.rateBound = (n3 & 0x7FFFFE00) >> 9;
            this.sysHeader.audioBound = (n3 & 0xFC) >> 2;
            this.sysHeader.fixedFlag = (n3 & 2) >> 1;
            this.sysHeader.CSPSFlag = n3 & 1;
            this.readBytes(this.stream, byArray, 1);
            byte by = byArray[0];
            --n2;
            if ((by & 0x20) != 32) {
                throw new BadHeaderException("illegal marker bits in system header");
            }
            this.sysHeader.audioLockFlag = (by & 0x80) >> 7;
            this.sysHeader.videoLockFlag = (by & 0x40) >> 6;
            this.sysHeader.videoBound = by & 0x1F;
            this.readBytes(this.stream, byArray, 1);
            --n2;
            this.sysHeader.reserved = byArray[0];
            while (n2 > 1) {
                int n4;
                int n5;
                short s;
                this.readBytes(this.stream, byArray, 1);
                by = byArray[0];
                --n2;
                if ((by & 0xFFFFFF80) != -128) break;
                if (by == -72) {
                    s = this.readShort(this.stream, true);
                    n2 -= 2;
                    if ((s & 0xC000) != 49152) {
                        throw new BadHeaderException("illegal marker bits in system header");
                    }
                    n5 = s & 0x1FFF;
                    this.sysHeader.allAudioSTDFlag = true;
                    n4 = 0;
                    while (n4 <= 31) {
                        this.sysHeader.STDBufBoundScale[n4] = 0;
                        this.sysHeader.STDBufSizeBound[n4] = n5;
                        ++n4;
                    }
                    continue;
                }
                if (by == -71) {
                    s = this.readShort(this.stream, true);
                    n2 -= 2;
                    if ((s & 0xC000) != 49152) {
                        throw new BadHeaderException("illegal marker bits in system header");
                    }
                    n5 = s & 0x1FFF;
                    this.sysHeader.allVideoSTDFlag = true;
                    n4 = 32;
                    while (n4 <= 47) {
                        this.sysHeader.STDBufBoundScale[n4] = 1;
                        this.sysHeader.STDBufSizeBound[n4] = n5;
                        ++n4;
                    }
                    continue;
                }
                if ((by & 0xFF) < 188 || (by & 0xFF) > 255) {
                    throw new BadHeaderException("illegal track number in system header");
                }
                int n6 = this.getStreamID(by);
                if (n6 < 0 || n6 >= 48) continue;
                s = this.readShort(this.stream, true);
                n2 -= 2;
                if ((s & 0xC000) != 49152) {
                    throw new BadHeaderException("illegal marker bits in system header");
                }
                int n7 = (s & 0x2000) >> 13;
                n5 = s & 0x1FFF;
                this.sysHeader.streamFlags[n6] = true;
                this.sysHeader.STDBufBoundScale[n6] = n7;
                this.sysHeader.STDBufSizeBound[n6] = n5;
            }
            if (n2 < 0) {
                throw new BadHeaderException("illegal system header");
            }
            if (n2 > 0) {
                this.skip(this.stream, n2);
            }
            this.sysHeaderSeen = true;
        }
    }

    void saveInnerBuffersToFiles() {
        int n2 = 0;
        while (n2 < this.numTracks) {
            if (this.tracks[n2] != null) {
                TrackList trackList = ((MediaTrack)this.tracks[n2]).getTrackInfo();
                trackList.saveBufToFile();
            }
            ++n2;
        }
    }

    public Time setPosition(Time time, int n2) {
        long l2;
        Time time2 = null;
        if (!this.durationInitialized || this.durationNs == Duration.DURATION_UNKNOWN) {
            return new Time(0L);
        }
        Time time3 = new Time(time.getNanoseconds() - 500000000L);
        if (this.streamType == 3) {
            this.flushInnerBuffers();
            long l3 = this.convNanosecondsToPTS(time3.getNanoseconds());
            long l4 = this.convNanosecondsToPTS(time.getNanoseconds());
            long l5 = this.setPositionSystemSeekableRA(l3 += this.startPTS, l4 += this.startPTS);
            this.lastAudioNs = l2 = this.convPTStoNanoseconds(l5);
        } else {
            this.lastAudioNs = l2 = this.setPositionAudioVideoOnly(time3.getNanoseconds(), time.getNanoseconds());
        }
        time2 = new Time(l2);
        if (this.lastSetPositionTime.getNanoseconds() == l2) {
            ++l2;
        }
        this.lastSetPositionTime = new Time(l2);
        this.EOMflag = false;
        this.parserErrorFlag = false;
        return time2;
    }

    private long setPositionAudioVideoOnly(long l2, long l3) {
        long l4;
        if ((float)l3 <= (float)this.AVstartTimeNs + 5.0E8f) {
            l4 = this.AVstartTimeNs;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)l3 >= (float)this.AVlastTimeNs - 5.0E8f) {
            l4 = this.AVlastTimeNs - this.AVstartTimeNs;
            ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
        } else {
            l4 = l2;
            long l5 = this.convTimeToBytesAV(l2);
            ((Seekable)((Object)this.stream)).seek(l5);
        }
        return l4;
    }

    private long setPositionSystemSeekableRA(long l2, long l3) {
        long l4 = -3333333L;
        long l5 = -1L;
        long l6 = this.startPTS;
        boolean bl = this.EOMflag;
        boolean bl2 = false;
        if (this.endPTS == -3333333L || this.startPTS == -3333333L) {
            l4 = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)l3 <= (float)this.startPTS + 45000.0f) {
            l4 = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)l3 >= (float)this.endPTS - 45000.0f) {
            l4 = this.endPTS - this.startPTS;
            ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
        } else if ((float)(this.endPTS - this.startPTS) < 45000.0f) {
            l4 = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else {
            long l7 = (long)((float)this.streamContentLength * ((float)(l2 - this.startPTS) / (float)(this.endPTS - this.startPTS)));
            long l8 = 20480L;
            if ((l7 -= l8) < 0L) {
                l7 = 0L;
            }
            long l9 = this.streamContentLength - l7;
            while (true) {
                ((Seekable)((Object)this.stream)).seek(l7);
                this.currentPTS = -3333333L;
                this.startPTS = -3333333L;
                this.EOMflag = false;
                try {
                    l5 = this.mpegSystemParseBitstream(true, l9, false, l2);
                }
                catch (IOException iOException) {
                    l5 = -2L;
                    bl = true;
                }
                catch (Exception exception) {
                    l5 = -1L;
                }
                if (l5 >= 0L) {
                    l4 = this.currentPTS - l6;
                    ((Seekable)((Object)this.stream)).seek(l5);
                    break;
                }
                if (l5 == -2L) {
                    l4 = this.endPTS - l6;
                    ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
                    break;
                }
                if ((l7 -= l8) <= 0L) {
                    if (bl2) {
                        l4 = 0L;
                        ((Seekable)((Object)this.stream)).seek(0L);
                        break;
                    }
                    l7 = 0L;
                    bl2 = true;
                }
                l9 = 3L * l8;
            }
            this.startPTS = l6;
            this.EOMflag = bl;
        }
        return l4;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        super.setSource(dataSource);
        this.stream = (PullSourceStream)this.streams[0];
        this.streamContentLength = this.stream.getContentLength();
        this.seekableStreamFlag = this.streams[0] instanceof Seekable;
        if (!this.seekableStreamFlag) {
            throw new IncompatibleSourceException("Mpeg Stream is not Seekable");
        }
        this.randomAccessStreamFlag = this.seekableStreamFlag && ((Seekable)((Object)this.streams[0])).isRandomAccess();
    }

    public void start() throws IOException {
        super.start();
        this.sysPausedFlag = false;
        if (this.mpThread != null) {
            this.mpThread.start();
        }
    }

    public void stop() {
        super.stop();
        this.sysPausedFlag = true;
        if (this.mpThread != null) {
            this.mpThread.pause();
        }
        int n2 = 0;
        while (n2 < this.numTracks) {
            if (this.tracks[n2] != null && this.tracks[n2].isEnabled()) {
                TrackList trackList = ((MediaTrack)this.tracks[n2]).getTrackInfo();
                trackList.releaseReadFrame();
            }
            ++n2;
        }
    }

    void throwInnerBuffersContents() {
        int n2 = 0;
        while (n2 < this.numTracks) {
            if (this.tracks[n2] != null) {
                TrackList trackList = ((MediaTrack)this.tracks[n2]).getTrackInfo();
                trackList.flushBuffer();
            }
            ++n2;
        }
    }

    private void updateDurationAudioVideoOnly() {
        if (this.durationInitialized) {
            return;
        }
        this.AVstartTimeNs = 0L;
        this.AVcurrentTimeNs = 0L;
        this.AVlastTimeNs = this.convBytesToTimeAV(this.streamContentLength);
        this.durationNs = new Time(this.AVlastTimeNs - this.AVstartTimeNs);
        this.durationInitialized = true;
    }

    void updateEOMState() {
        if (!this.durationInitialized) {
            if (this.streamContentLength == -1L) {
                this.streamContentLength = this.getLocation(this.stream);
            }
            if (this.streamType == 3) {
                long l2;
                if (this.startPTS == -3333333L) {
                    this.startPTS = 0L;
                }
                if (this.endPTS == -3333333L) {
                    this.endPTS = this.currentPTS;
                }
                if (this.endPTS == -3333333L) {
                    this.endPTS = this.startPTS;
                }
                if ((l2 = this.endPTS - this.startPTS) < 0L) {
                    l2 = 0L;
                    this.parserErrorFlag = true;
                }
                this.durationNs = new Time(this.convPTStoNanoseconds(l2));
                this.durationInitialized = true;
            } else {
                this.updateDurationAudioVideoOnly();
            }
        }
    }

    void updateTrackEOM() {
        int n2 = 0;
        while (n2 < this.trackList.length) {
            if (this.trackList[n2] != null) {
                this.trackList[n2].generateEOM();
            }
            ++n2;
        }
    }

    private abstract class Media {
        Media() {
        }

        abstract Format createFormat();
    }

    private class Audio
    extends Media {
        boolean valid = false;
        int ID = 0;
        int layer = 0;
        int protection = 0;
        int bitRate = 0;
        int sampleRate = 0;
        int mode = 0;
        int modeExt = 0;
        int copyright = 0;
        int original = 0;
        int emphasis = 0;
        int channels = 0;
        AudioFormat format = null;

        Audio() {
        }

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            String string = this.layer == 3 ? "mpeglayer3" : "mpegaudio";
            int n2 = 16;
            int n3 = (this.layer == 1 ? 352 : 1024) * this.channels * n2;
            int n4 = this.bitRate * 1000 >> 3;
            this.format = new WavAudioFormat(string, this.sampleRate, n2, this.channels, n3, n4, 0, 1, -1.0f, array$B != null ? array$B : (array$B = MpegParser.class$("[B")), null);
            return this.format;
        }

        public String toString() {
            System.out.println("Audio Media: " + this.format);
            System.out.println("Number of channels " + this.channels);
            System.out.println("valid " + this.valid);
            System.out.println("ID " + this.ID);
            System.out.println("layer " + this.layer);
            System.out.println("protection " + this.protection);
            System.out.println("bitrate " + this.bitRate);
            System.out.println("sample rate " + this.sampleRate);
            System.out.println("Mode " + this.mode + " ext " + this.modeExt);
            System.out.println("copyright " + this.copyright);
            System.out.println("original " + this.original);
            System.out.println("emphasis " + this.emphasis);
            System.out.println("channels " + this.channels);
            return super.toString();
        }
    }

    private class Video
    extends Media {
        int width = 0;
        int height = 0;
        float pelAspectRatio = 0.0f;
        float pictureRate = 0.0f;
        int bitRate = 0;
        VideoFormat format = null;

        Video() {
        }

        Format createFormat() {
            int n2 = (int)((double)(this.width * this.height) * 1.5);
            if (this.format != null) {
                return this.format;
            }
            this.format = new VideoFormat("mpeg", new Dimension(this.width, this.height), n2, array$B != null ? array$B : (array$B = MpegParser.class$("[B")), this.pictureRate);
            return this.format;
        }

        public String toString() {
            System.out.println("Video Media: " + this.format);
            System.out.println("width " + this.width);
            System.out.println("height " + this.height);
            System.out.println("pixel aspect ratio " + this.pelAspectRatio);
            System.out.println("picture rate " + this.pictureRate);
            System.out.println("bitrate " + this.bitRate);
            return super.toString();
        }
    }

    private class TrackList {
        byte trackType = 0;
        Time duration = Duration.DURATION_UNKNOWN;
        long startPTS = -3333333L;
        boolean infoFlag = false;
        int numPackets = 0;
        int maxPacketSize = 0;
        int readFrameSize = 0;
        Media media;
        boolean supported = false;
        boolean flushFlag = false;
        CircularBuffer bufQ = null;
        Buffer current = null;
        MpegParser parser = MpegParser.this;

        TrackList() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void copyFromInnerBuffer(Buffer buffer) {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                while (true) {
                    if (this.bufQ.canRead() || MpegParser.this.sysPausedFlag || MpegParser.this.parserErrorFlag) {
                        if (!MpegParser.this.sysPausedFlag && !MpegParser.this.parserErrorFlag) {
                            Buffer buffer2 = this.bufQ.read();
                            byte[] byArray = (byte[])buffer.getData();
                            buffer.copy(buffer2);
                            buffer2.setData(byArray);
                            this.bufQ.readReport();
                            this.bufQ.notify();
                            return;
                        }
                        buffer.setLength(0);
                        buffer.setDiscard(true);
                        return;
                    }
                    try {
                        this.bufQ.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        void copyStreamDataToInnerBuffer(byte[] byArray, int n2, int n3, long l2) throws IOException {
            int n4 = n3;
            int n5 = 0;
            if (n2 > 0) {
                n4 += n2;
            } else {
                n2 = 0;
            }
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                byte[] byArray2;
                if (this.current != null && (n5 = this.current.getLength()) != 0 && n5 + n4 >= this.readFrameSize) {
                    this.bufQ.writeReport();
                    this.bufQ.notify();
                    this.current = null;
                }
                this.flushFlag = false;
                if (this.current == null) {
                    while (!this.bufQ.canWrite() && !this.flushFlag) {
                        try {
                            this.bufQ.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.flushFlag) {
                        Object var9_8 = null;
                        return;
                    }
                    this.current = this.bufQ.getEmptyBuffer();
                    this.current.setFlags(0);
                    this.current.setOffset(0);
                    this.current.setLength(0);
                    this.current.setTimeStamp(MpegParser.this.convPTStoNanoseconds(l2));
                    int n6 = n4 > this.readFrameSize ? n4 : this.readFrameSize;
                    byArray2 = (byte[])this.current.getData();
                    if (byArray2 == null || byArray2.length < n6) {
                        byArray2 = new byte[n6];
                        this.current.setData(byArray2);
                    }
                } else {
                    byArray2 = (byte[])this.current.getData();
                }
                n5 = this.current.getLength();
                if (n2 > 0) {
                    System.arraycopy(byArray, 0, byArray2, n5, n2);
                }
                this.parser.readBytes(MpegParser.this.stream, byArray2, n5 + n2, n3);
                this.current.setLength(n5 + n4);
            }
        }

        void flushBuffer() {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                if (this.current != null) {
                    this.current.setDiscard(true);
                    this.bufQ.writeReport();
                    this.current = null;
                }
                while (this.bufQ.canRead()) {
                    this.bufQ.read();
                    this.bufQ.readReport();
                }
                this.bufQ.notifyAll();
            }
        }

        void generateEOM() {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                if (this.current != null) {
                    this.bufQ.writeReport();
                    this.bufQ.notify();
                    this.current = null;
                }
                while (!this.bufQ.canWrite()) {
                    try {
                        this.bufQ.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Buffer buffer = this.bufQ.getEmptyBuffer();
                buffer.setFlags(1);
                buffer.setLength(0);
                this.bufQ.writeReport();
                this.bufQ.notify();
            }
        }

        void init(byte by) {
            this.supported = true;
            this.trackType = by;
            this.bufQ = this.trackType == 2 ? new CircularBuffer(15) : new CircularBuffer(10);
        }

        int readyDataBytes() {
            return 1;
        }

        void releaseReadFrame() {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                this.bufQ.notifyAll();
            }
        }

        void saveBufToFile() {
        }

        public String toString() {
            System.out.println("track type " + this.trackType + "(0 ?, 1 audio, 2 video)");
            System.out.println("start PTS " + this.startPTS);
            System.out.println("info flag " + this.infoFlag);
            System.out.println("number of packets " + this.numPackets);
            System.out.println("maximum packet size " + this.maxPacketSize);
            System.out.println("supported " + this.supported);
            System.out.println("duration (?) " + this.duration);
            return this.media.toString();
        }
    }

    private class MediaTrack
    implements Track {
        private TrackList trackInfo;
        private boolean enabled;
        private long sequenceNumber = 0L;
        private Format format;
        private TrackListener listener;
        MpegParser parser = MpegParser.this;

        MediaTrack(TrackList trackList) {
            this.trackInfo = trackList;
            this.enabled = true;
            this.format = trackList.media.createFormat();
        }

        private void AudioVideoOnlyReadFrame(Buffer buffer) {
            int n2;
            int n3;
            block14: {
                byte[] byArray;
                if (MpegParser.this.sysPausedFlag || MpegParser.this.parserErrorFlag) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                }
                int n4 = this.trackInfo.readFrameSize;
                Object object = buffer.getData();
                if (object == null || !(object instanceof byte[]) || ((byte[])object).length < n4) {
                    byArray = new byte[n4];
                    buffer.setData(byArray);
                } else {
                    byArray = (byte[])object;
                }
                n3 = 0;
                int n5 = n4;
                int n6 = 0;
                n2 = 0;
                if (MpegParser.this.initTmpBufLen > 0) {
                    n3 = MpegParser.this.initTmpBufLen > n4 ? n4 : MpegParser.this.initTmpBufLen;
                    System.arraycopy(MpegParser.this.initTmpStreamBuf, 0, byArray, 0, n3);
                    MpegParser mpegParser = MpegParser.this;
                    mpegParser.initTmpBufLen = mpegParser.initTmpBufLen - n3;
                    n5 -= n3;
                    n2 = n3;
                }
                if (this.trackInfo.trackType == 1) {
                    buffer.setTimeStamp(MpegParser.this.convBytesToTimeAV(MpegParser.this.getLocation() - (long)n3));
                }
                if (n5 > 0 && !MpegParser.this.EOMflag) {
                    try {
                        n6 = this.parser.readBytes(MpegParser.this.stream, byArray, n3, n5);
                        if (n6 == -2) {
                            if (n3 == 0) {
                                buffer.setDiscard(true);
                                return;
                            }
                        } else {
                            n2 += n6;
                        }
                    }
                    catch (IOException iOException) {
                        MpegParser.this.updateEOMState();
                        MpegParser.this.EOMflag = true;
                        if (MpegParser.this.AVlastTimeNs != 0L) break block14;
                        MpegParser.this.AVcurrentTimeNs = MpegParser.this.convBytesToTimeAV(MpegParser.this.getLocation());
                        MpegParser.this.AVlastTimeNs = MpegParser.this.AVcurrentTimeNs;
                    }
                }
            }
            if (MpegParser.this.EOMflag) {
                if (n3 > 0) {
                    buffer.setLength(n3);
                    buffer.setOffset(0);
                } else {
                    buffer.setLength(0);
                    buffer.setEOM(true);
                }
            }
            buffer.setOffset(0);
            buffer.setLength(n2);
        }

        public Time getDuration() {
            return this.trackInfo.duration;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time getStartTime() {
            if (MpegParser.this.streamType == 3) {
                return new Time((double)MpegParser.this.startPTS / 90000.0);
            }
            return new Time(MpegParser.this.AVstartTimeNs);
        }

        private TrackList getTrackInfo() {
            return this.trackInfo;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int n2) {
            return null;
        }

        public int mapTimeToFrame(Time time) {
            return 0;
        }

        public void readFrame(Buffer buffer) {
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            if (MpegParser.this.streamType == 3) {
                this.systemStreamReadFrame(buffer);
            } else {
                this.AudioVideoOnlyReadFrame(buffer);
            }
            buffer.setFormat(this.format);
            buffer.setSequenceNumber(++this.sequenceNumber);
            if (this.format instanceof AudioFormat) {
                long l2 = buffer.getTimeStamp();
                buffer.setTimeStamp(MpegParser.this.lastAudioNs);
                MpegParser.this.lastAudioNs = l2;
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }

        private void systemStreamReadFrame(Buffer buffer) {
            int n2;
            TrackList trackList;
            this.trackInfo.copyFromInnerBuffer(buffer);
            if (MpegParser.this.sysPausedFlag || MpegParser.this.parserErrorFlag) {
                return;
            }
            int n3 = 0;
            while (n3 < MpegParser.this.numTracks) {
                if (MpegParser.this.tracks[n3] != null && !MpegParser.this.tracks[n3].isEnabled()) {
                    trackList = ((MediaTrack)MpegParser.this.tracks[n3]).getTrackInfo();
                    trackList.flushBuffer();
                }
                ++n3;
            }
            if (MpegParser.this.hideAudioTracks) {
                n2 = 0;
                while (n2 < MpegParser.this.numTracks) {
                    if (MpegParser.this.tracks[n2] != null) {
                        trackList = ((MediaTrack)MpegParser.this.tracks[n2]).getTrackInfo();
                        if (trackList.trackType == 1) {
                            trackList.flushBuffer();
                        }
                    }
                    ++n2;
                }
            }
            if (MpegParser.this.hideVideoTracks) {
                n2 = 0;
                while (n2 < MpegParser.this.numTracks) {
                    if (MpegParser.this.tracks[n2] != null) {
                        trackList = ((MediaTrack)MpegParser.this.tracks[n2]).getTrackInfo();
                        if (trackList.trackType == 2) {
                            trackList.flushBuffer();
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private class SystemHeader {
        int headerLen = 0;
        int rateBound = 0;
        int audioBound = 0;
        int fixedFlag = 0;
        int CSPSFlag = 0;
        int audioLockFlag = 0;
        int videoLockFlag = 0;
        int videoBound = 0;
        int reserved = 0;
        boolean allAudioSTDFlag = false;
        boolean allVideoSTDFlag = false;
        boolean[] streamFlags = new boolean[48];
        int[] STDBufBoundScale = new int[48];
        int[] STDBufSizeBound = new int[48];

        SystemHeader() {
            int n2 = 0;
            while (n2 < 48) {
                this.streamFlags[n2] = false;
                this.STDBufBoundScale[n2] = 0;
                this.STDBufSizeBound[n2] = 0;
                ++n2;
            }
        }

        void printFields() {
            System.out.println("headerLen " + this.headerLen);
            System.out.println("rateBound " + this.rateBound);
            System.out.println("audioBound " + this.audioBound);
            System.out.println("fixedFlag " + this.fixedFlag);
            System.out.println("CSPSFlag " + this.CSPSFlag);
            System.out.println("audioLockFlag " + this.audioLockFlag);
            System.out.println("videoLockFlag " + this.videoLockFlag);
            System.out.println("videoBound " + this.videoBound);
            System.out.println("reserved " + this.reserved);
            System.out.println("allAudioSTDFlag " + this.allAudioSTDFlag);
            System.out.println("allVideoSTDFlag " + this.allVideoSTDFlag);
            int n2 = 0;
            while (n2 < 48) {
                if (this.streamFlags[n2]) {
                    System.out.println("[" + n2 + "]  STDBufBoundScale " + this.STDBufBoundScale[n2] + "     STDBufSizeBound " + this.STDBufSizeBound[n2]);
                }
                ++n2;
            }
        }

        void resetSystemHeader() {
            this.headerLen = 0;
            this.rateBound = 0;
            this.audioBound = 0;
            this.fixedFlag = 0;
            this.CSPSFlag = 0;
            this.audioLockFlag = 0;
            this.videoLockFlag = 0;
            this.videoBound = 0;
            this.reserved = 0;
            this.allAudioSTDFlag = false;
            this.allVideoSTDFlag = false;
            int n2 = 0;
            while (n2 < 48) {
                this.streamFlags[n2] = false;
                this.STDBufBoundScale[n2] = 0;
                this.STDBufSizeBound[n2] = 0;
                ++n2;
            }
        }
    }
}

