/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.format.AviVideoFormat;
import com.sun.media.format.WavAudioFormat;
import com.sun.media.multiplexer.BasicMux;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.ByteBuffer;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class AVIMux
extends BasicMux {
    private int[] suggestedBufferSizes;
    private int[] suggestedBufferSizeOffsets;
    private int[] scaleOffsets;
    private boolean[] endOfMediaStatus;
    private int numberOfEoms = 0;
    private int width = 0;
    private int height = 0;
    private static final int MAX_FRAMES_STORED = 20000;
    private static final int AVIH_HEADER_LENGTH = 56;
    private static final int STRH_HEADER_LENGTH = 56;
    private static final int STRF_VIDEO_HEADER_LENGTH = 40;
    private static final int STRF_AUDIO_HEADER_LENGTH = 16;
    static final String AUDIO = "auds";
    static final String VIDEO = "vids";
    static final int AVIF_HASINDEX = 16;
    static final int AVIF_MUSTUSEINDEX = 32;
    static final int AVIF_ISINTERLEAVED = 256;
    static final int AVIF_WASCAPTUREFILE = 65536;
    static final int AVIF_COPYRIGHTED = 131072;
    static final int AVIF_KEYFRAME = 16;
    private int usecPerFrame = -1;
    private float frameRate = -1.0f;
    private int maxBytesPerSecond;
    private int paddingGranularity;
    private long avgFrameTime;
    private int flags = 16;
    private int totalDataLength = 0;
    private int totalFrames = 0;
    private int totalVideoFrames = 0;
    private int initialFrames;
    private int[] reserved = new int[4];
    private Vector chunkList = new Vector(1);
    private final int BUF_SIZE = 16384;
    private ByteBuffer bbuf = new ByteBuffer(16384);
    private int chunkOffset = 4;
    private int moviOffset = 0;
    private int avihOffset = 0;
    private int hdrlSizeOffset = 0;
    private int totalStrlLength = 0;
    private int blockAlign = 1;
    private int samplesPerBlock = -1;
    private double sampleRate = 0.0;
    private double audioDuration = 0.0;
    private int averageBytesPerSecond = -1;
    private int mp3BitRate = -1;
    private long cumulativeInterFrameTimeVideo = 0L;
    private long previousTimeStampVideo = 0L;
    static final String LISTRECORDCHUNK = "rec ";
    static final String VIDEO_MAGIC = "dc";
    static final String VIDEO_MAGIC_JPEG = "db";
    static final String VIDEO_MAGIC_IV32a = "iv";
    static final String VIDEO_MAGIC_IV32b = "32";
    static final String VIDEO_MAGIC_IV31 = "31";
    static final String VIDEO_MAGIC_CVID = "id";
    static final String AUDIO_MAGIC = "wb";
    Format littleEndian = new AudioFormat(null, -1.0, -1, -1, 0, -1);
    Format signed = new AudioFormat(null, -1.0, -1, -1, 0, 1);
    Format unsigned = new AudioFormat(null, -1.0, -1, -1, 0, 0);

    public AVIMux() {
        this.supportedInputs = new Format[2];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedInputs[1] = new VideoFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("video.x_msvideo");
        this.chunkList.addElement(this.bbuf);
    }

    private Format[] createRGBFormats(Dimension dimension) {
        int n2 = -1;
        Format[] formatArray = new Format[]{new RGBFormat(dimension, dimension.width * dimension.height * 2, Format.byteArray, n2, 16, 31744, 992, 31, 2, dimension.width * 2, 1, 1), new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, n2, 24, 3, 2, 1, 3, dimension.width * 3, 1, n2), new RGBFormat(dimension, dimension.width * dimension.height * 4, Format.byteArray, n2, 32, 3, 2, 1, 4, dimension.width * 4, 1, n2)};
        return formatArray;
    }

    private Format[] createYUVFormats(Dimension dimension) {
        int n2 = -1;
        Format[] formatArray = new Format[]{new YUVFormat(dimension, dimension.width * dimension.height * 2, Format.byteArray, n2, 32, dimension.width * 2, dimension.width * 2, 1, 0, 2), new YUVFormat(dimension, dimension.width * dimension.height * 2, Format.byteArray, n2, 32, dimension.width * 2, dimension.width * 2, 0, 1, 3), new YUVFormat(dimension, dimension.width * dimension.height * 3 / 2, Format.byteArray, n2, 2, dimension.width, dimension.width / 2, 0, dimension.width * dimension.height, dimension.width * dimension.height * 5 / 4), new YUVFormat(dimension, dimension.width * dimension.height * 3 / 2, Format.byteArray, n2, 2, dimension.width, dimension.width / 2, 0, dimension.width * dimension.height * 5 / 4, dimension.width * dimension.height)};
        return formatArray;
    }

    public synchronized int doProcess(Buffer buffer, int n2) {
        long l2;
        if (buffer.isEOM()) {
            ++this.numberOfEoms;
            if (this.numberOfEoms >= this.numTracks) {
                return super.doProcess(buffer, n2);
            }
            return 0;
        }
        if (buffer.getData() == null) {
            return 0;
        }
        boolean bl = buffer.getFormat() instanceof VideoFormat;
        if (bl && (double)((l2 = buffer.getTimeStamp()) - this.previousTimeStampVideo) > (double)this.avgFrameTime * 1.9) {
            int n3 = (int)((l2 - this.previousTimeStampVideo) / this.avgFrameTime);
            int n4 = 0;
            while (n4 < n3) {
                Buffer buffer2 = new Buffer();
                buffer2.setTimeStamp(this.previousTimeStampVideo + (long)n4 * this.avgFrameTime);
                buffer2.setFormat(buffer.getFormat());
                buffer2.setDuration(this.avgFrameTime);
                buffer2.setSequenceNumber(buffer.getSequenceNumber());
                buffer2.setFlags(buffer.getFlags() & 0xFFFFFFEF);
                int n5 = this.writeFrame(buffer2, n2);
                if (n5 != 0) {
                    return n5;
                }
                ++n4;
            }
        }
        return this.writeFrame(buffer, n2);
    }

    private String getAviEncodingMagic(int n2, boolean bl) {
        String string = this.inputs[n2].getEncoding().toLowerCase();
        String string2 = bl ? (string.equalsIgnoreCase("cvid") ? VIDEO_MAGIC_CVID : (string.startsWith("iv32") ? VIDEO_MAGIC_IV32b : (string.startsWith("iv31") ? VIDEO_MAGIC_IV31 : (string.startsWith(VIDEO_MAGIC_IV32a) ? VIDEO_MAGIC_IV32a : VIDEO_MAGIC)))) : AUDIO_MAGIC;
        String string3 = null;
        if (n2 == 0) {
            string3 = "00";
        } else if (n2 == 1) {
            string3 = "01";
        } else if (n2 == 2) {
            string3 = "02";
        } else if (n2 == 3) {
            string3 = "03";
        } else if (n2 == 4) {
            string3 = "04";
        }
        return String.valueOf(string3) + string2;
    }

    public String getName() {
        return "AVI Multiplexer";
    }

    /*
     * Unable to fully structure code
     */
    public Format setInputFormat(Format var1_1, int var2_2) {
        block33: {
            block32: {
                var3_3 = null;
                if (!(var1_1 instanceof AudioFormat)) break block32;
                var4_4 = (AudioFormat)var1_1;
                var5_6 = null;
                if (var1_1 instanceof WavAudioFormat) {
                    var5_6 = (WavAudioFormat)var1_1;
                }
                if ((var6_8 = var4_4.getEncoding()) == null) {
                    return null;
                }
                if (var6_8.equalsIgnoreCase("LINEAR")) {
                    if (var4_4.getSampleSizeInBits() > 8) {
                        if (var4_4.getEndian() == 1) {
                            return null;
                        }
                        if (var4_4.getSigned() == 0) {
                            return null;
                        }
                        if (var4_4.getEndian() == -1 || var4_4.getSigned() == -1) {
                            var1_1 = (AudioFormat)var4_4.intersects(this.signed);
                        }
                    } else {
                        if (var4_4.getSigned() == 1) {
                            return null;
                        }
                        if (var4_4.getEndian() == -1 || var4_4.getSigned() == -1) {
                            var1_1 = (AudioFormat)var4_4.intersects(this.unsigned);
                        }
                    }
                }
                if ((var7_10 = (Integer)WavAudioFormat.reverseFormatMapper.get(var6_8.toLowerCase())) == null || var4_4.getEncoding().equalsIgnoreCase("truespeech") || var4_4.getEncoding().toLowerCase().startsWith("voxware")) {
                    var3_3 = "Cannot handle format";
                    return null;
                }
                var8_11 = var7_10.shortValue();
                switch (var8_11) {
                    case 2: 
                    case 17: 
                    case 49: {
                        if (var5_6 == null) {
                            var3_3 = "A WavAudioFormat is required  to provide encoding specific information for this encoding " + var8_11;
                            return null;
                        }
                        ** GOTO lbl61
                    }
                    default: {
                        if (var3_3 == null) break block33;
                    }
                }
            }
            if (var1_1 instanceof VideoFormat) {
                var4_5 = (VideoFormat)var1_1;
                var5_7 = var4_5.getEncoding();
                var6_9 = var4_5.getSize();
                if (var6_9 == null) {
                    var6_9 = new Dimension(320, 240);
                }
                if (var5_7 == null) {
                    return null;
                }
                if (var5_7.equalsIgnoreCase("rgb")) {
                    if (BasicPlugIn.matches(var4_5, this.createRGBFormats(var6_9)) == null) {
                        return null;
                    }
                } else if (var5_7.equalsIgnoreCase("yuv")) {
                    if (BasicPlugIn.matches(var4_5, this.createYUVFormats(var6_9)) == null) {
                        return null;
                    }
                } else {
                    if (var5_7.equalsIgnoreCase("jpeg")) {
                        return null;
                    }
                    if (var5_7.length() > 4) {
                        return null;
                    }
                }
                this.frameRate = var4_5.getFrameRate();
                if (this.frameRate > 0.0f) {
                    this.usecPerFrame = (int)(1.0f / this.frameRate * 1000000.0f);
                }
                this.avgFrameTime = this.usecPerFrame * 1000;
            } else {
                var3_3 = "Can only support Audio and Video formats";
            }
lbl61:
            // 3 sources

            if (var3_3 == null) break block33;
            return null;
        }
        this.inputs[var2_2] = var1_1;
        return var1_1;
    }

    public int setNumTracks(int n2) {
        if (n2 > 2) {
            return 2;
        }
        this.suggestedBufferSizeOffsets = new int[n2];
        this.suggestedBufferSizes = new int[n2];
        this.endOfMediaStatus = new boolean[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.suggestedBufferSizes[n3] = -1;
            this.suggestedBufferSizeOffsets[n3] = -1;
            ++n3;
        }
        return super.setNumTracks(n2);
    }

    private void writeAVIH() {
        int n2 = 0;
        if (this.totalVideoFrames <= 0) {
            this.usecPerFrame = 1000;
            n2 = (int)(this.audioDuration * 1000000.0 / (double)this.usecPerFrame);
        } else {
            int n3;
            this.usecPerFrame = n3 = (int)((double)this.cumulativeInterFrameTimeVideo / (1000.0 * (double)(this.totalVideoFrames - 1)));
        }
        this.seek(this.avihOffset);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.usecPerFrame);
        this.bufWriteIntLittleEndian(this.maxBytesPerSecond);
        this.bufWriteIntLittleEndian(this.paddingGranularity);
        this.bufWriteIntLittleEndian(this.flags);
        if (this.totalVideoFrames > 0) {
            this.bufWriteIntLittleEndian(this.totalVideoFrames);
        } else {
            this.bufWriteIntLittleEndian(n2);
        }
        this.bufWriteIntLittleEndian(this.initialFrames);
        this.bufWriteIntLittleEndian(this.numTracks);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(this.width);
        this.bufWriteIntLittleEndian(this.height);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufFlush();
    }

    protected void writeFooter() {
        this.writeIDX1Chunk();
        this.writeAVIH();
        this.seek(this.moviOffset);
        this.bufClear();
        this.bufWriteIntLittleEndian(4 + this.totalDataLength + this.totalFrames * 8);
        this.bufFlush();
        int n2 = 0;
        while (n2 < this.numTracks) {
            int n3 = this.suggestedBufferSizeOffsets[n2];
            if (n3 > 0) {
                this.seek(n3);
                this.bufClear();
                this.bufWriteIntLittleEndian(this.suggestedBufferSizes[n2]);
                this.bufFlush();
            }
            this.seek(this.scaleOffsets[n2]);
            if (this.inputs[n2] instanceof VideoFormat) {
                int n4 = 10000;
                this.bufClear();
                this.bufWriteIntLittleEndian(this.usecPerFrame / 100);
                this.bufWriteIntLittleEndian(n4);
                this.bufWriteIntLittleEndian(0);
                this.bufWriteIntLittleEndian(this.totalVideoFrames);
                this.bufFlush();
            } else {
                AudioFormat audioFormat = (AudioFormat)this.inputs[n2];
                if (this.mp3BitRate > 0) {
                    this.bufClear();
                    this.bufWriteIntLittleEndian(8);
                    this.bufFlush();
                    this.bufClear();
                    this.bufWriteIntLittleEndian(this.mp3BitRate);
                    this.bufFlush();
                    this.blockAlign = 1;
                } else {
                    this.bufClear();
                    this.bufWriteIntLittleEndian(this.blockAlign);
                    this.bufFlush();
                    int n5 = 1;
                    if (this.samplesPerBlock > 0) {
                        n5 = this.samplesPerBlock;
                    }
                    int n6 = (int)(audioFormat.getSampleRate() / (double)n5 * (double)this.blockAlign);
                    this.bufClear();
                    this.bufWriteIntLittleEndian(n6);
                    this.bufFlush();
                }
                this.seek(this.filePointer + 16);
                this.bufClear();
                this.bufWriteIntLittleEndian(this.blockAlign);
                this.bufFlush();
            }
            ++n2;
        }
        this.seek(4);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.fileSize - 8);
        this.bufFlush();
    }

    private int writeFrame(Buffer buffer, int n2) {
        boolean bl = buffer.getFormat() instanceof VideoFormat;
        int n3 = buffer.getLength();
        int n4 = (n3 & 1) > 0 ? 1 : 0;
        String string = this.getAviEncodingMagic(n2, bl);
        this.bufClear();
        this.bufWriteBytes(string);
        this.bufWriteIntLittleEndian(n3 + n4);
        this.bufFlush();
        if (n3 > 0) {
            this.write((byte[])buffer.getData(), buffer.getOffset(), n3);
        }
        if (n4 > 0) {
            this.bufClear();
            this.bufWriteByte((byte)0);
            this.bufFlush();
        }
        this.totalDataLength += n3 + n4;
        if (n3 > this.suggestedBufferSizes[n2]) {
            this.suggestedBufferSizes[n2] = n3;
        }
        if (this.bbuf.length == 16384) {
            this.bbuf = new ByteBuffer(16384);
            this.chunkList.addElement(this.bbuf);
        }
        this.bbuf.writeBytes(string);
        int n5 = (buffer.getFlags() & 0x10) != 0 ? 16 : 0;
        this.bbuf.writeIntLittleEndian(n5);
        this.bbuf.writeIntLittleEndian(this.chunkOffset);
        this.bbuf.writeIntLittleEndian(n3);
        this.chunkOffset += n3 + n4 + 8;
        if (bl) {
            long l2 = buffer.getTimeStamp();
            if (this.totalVideoFrames > 0) {
                this.cumulativeInterFrameTimeVideo += l2 - this.previousTimeStampVideo;
            }
            this.previousTimeStampVideo = l2;
            ++this.totalVideoFrames;
        } else if (this.samplesPerBlock != -1) {
            int n6 = n3 / this.blockAlign;
            int n7 = n6 * this.samplesPerBlock;
            this.audioDuration += (double)n7 / this.sampleRate;
        } else if (this.averageBytesPerSecond > 0) {
            this.audioDuration += (double)n3 / (double)this.averageBytesPerSecond;
        }
        ++this.totalFrames;
        return 0;
    }

    protected void writeHeader() {
        Format format;
        int n2 = 0;
        while (n2 < this.inputs.length) {
            if (this.inputs[n2] instanceof AudioFormat) {
                AudioFormat audioFormat = (AudioFormat)this.inputs[n2];
                format = null;
                this.sampleRate = audioFormat.getSampleRate();
                if (audioFormat.getEncoding().equalsIgnoreCase("LINEAR")) {
                    this.samplesPerBlock = 1;
                }
                if (this.inputs[n2] instanceof WavAudioFormat) {
                    format = (WavAudioFormat)this.inputs[n2];
                    byte[] byArray = ((WavAudioFormat)format).getCodecSpecificHeader();
                    if (!audioFormat.getEncoding().equalsIgnoreCase("mpeglayer3") && byArray != null && byArray.length >= 2) {
                        try {
                            this.samplesPerBlock = BasicPullParser.parseShortFromArray(byArray, false);
                        }
                        catch (IOException iOException) {
                            System.err.println("Unable to parse codecSpecificHeader");
                        }
                    }
                }
            }
            ++n2;
        }
        this.bufClear();
        this.bufWriteBytes("RIFF");
        this.bufSkip(4);
        this.bufWriteBytes("AVI ");
        this.bufWriteBytes("LIST");
        this.hdrlSizeOffset = this.filePointer;
        this.bufSkip(4);
        this.bufWriteBytes("hdrl");
        this.bufWriteBytes("avih");
        this.bufWriteIntLittleEndian(56);
        this.avihOffset = this.filePointer;
        this.bufSkip(56);
        this.scaleOffsets = new int[this.numTracks];
        int n3 = 0;
        while (n3 < this.numTracks) {
            short s;
            int n4;
            Format format2;
            int n5;
            format = this.inputs[n3];
            boolean bl = format instanceof VideoFormat;
            this.bufWriteBytes("LIST");
            byte[] byArray = null;
            int n6 = 0;
            AviVideoFormat aviVideoFormat = null;
            WavAudioFormat wavAudioFormat = null;
            int n7 = 1;
            int n8 = 24;
            String string = null;
            String string2 = format.getEncoding();
            int n9 = -1;
            if (bl) {
                n5 = 40;
                RGBFormat rGBFormat = null;
                if (format instanceof RGBFormat) {
                    rGBFormat = (RGBFormat)format;
                } else if (format instanceof YUVFormat) {
                    format2 = (YUVFormat)format;
                    if (((YUVFormat)format2).getYuvType() == 32 && ((YUVFormat)format2).getStrideY() == ((VideoFormat)format2).getSize().width * 2 && ((YUVFormat)format2).getOffsetY() == 0 && ((YUVFormat)format2).getOffsetU() == 1 && ((YUVFormat)format2).getOffsetV() == 3) {
                        string = "YUY2";
                    } else if (((YUVFormat)format2).getYuvType() == 32 && ((YUVFormat)format2).getStrideY() == ((VideoFormat)format2).getSize().width * 2 && ((YUVFormat)format2).getOffsetY() == 1 && ((YUVFormat)format2).getOffsetU() == 0 && ((YUVFormat)format2).getOffsetV() == 2) {
                        string = "UYVY";
                    } else if (((YUVFormat)format2).getYuvType() == 32 && ((YUVFormat)format2).getStrideY() == ((VideoFormat)format2).getSize().width * 2 && ((YUVFormat)format2).getOffsetY() == 0 && ((YUVFormat)format2).getOffsetU() == 3 && ((YUVFormat)format2).getOffsetV() == 1) {
                        string = "YVYU";
                    } else if (((YUVFormat)format2).getYuvType() == 2 && ((YUVFormat)format2).getStrideY() == ((VideoFormat)format2).getSize().width && ((YUVFormat)format2).getStrideUV() == ((VideoFormat)format2).getSize().width / 2) {
                        string = ((YUVFormat)format2).getOffsetU() < ((YUVFormat)format2).getOffsetV() ? "I420" : "YV12";
                    }
                }
                if (format instanceof AviVideoFormat) {
                    aviVideoFormat = (AviVideoFormat)format;
                }
                if (aviVideoFormat != null) {
                    n7 = aviVideoFormat.getPlanes();
                    n8 = aviVideoFormat.getBitsPerPixel();
                    byArray = aviVideoFormat.getCodecSpecificHeader();
                } else if (rGBFormat != null) {
                    n8 = rGBFormat.getBitsPerPixel();
                }
            } else {
                Integer n10;
                if (format instanceof WavAudioFormat) {
                    wavAudioFormat = (WavAudioFormat)format;
                    byArray = wavAudioFormat.getCodecSpecificHeader();
                }
                if (byArray == null && (n10 = (Integer)WavAudioFormat.reverseFormatMapper.get(string2.toLowerCase())) != null && (n9 = (int)n10.shortValue()) == 85) {
                    n6 = 12;
                }
            }
            if (n6 <= 0 && byArray != null) {
                n6 = byArray.length;
            }
            n5 = 0;
            if (bl) {
                n5 = 116 + n6;
                this.bufWriteIntLittleEndian(n5);
            } else {
                n5 = n6 > 0 ? 92 + n6 + 2 : 92;
                this.bufWriteIntLittleEndian(n5);
            }
            this.totalStrlLength += n5;
            this.bufWriteBytes("strl");
            this.bufWriteBytes("strh");
            this.bufWriteIntLittleEndian(56);
            if (bl) {
                this.bufWriteBytes(VIDEO);
                if (string2.startsWith("rgb")) {
                    string2 = "DIB ";
                } else if (string != null) {
                    string2 = string;
                }
                this.bufWriteBytes(string2);
            } else {
                this.bufWriteBytes(AUDIO);
                this.bufWriteIntLittleEndian(0);
            }
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.scaleOffsets[n3] = this.filePointer;
            this.bufWriteIntLittleEndian(1);
            this.bufWriteIntLittleEndian(15);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.suggestedBufferSizeOffsets[n3] = this.filePointer;
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(10000);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteBytes("strf");
            if (bl) {
                this.bufWriteIntLittleEndian(40 + n6);
                this.bufWriteIntLittleEndian(40 + n6);
                this.width = ((VideoFormat)format).getSize().width;
                this.height = ((VideoFormat)format).getSize().height;
                this.bufWriteIntLittleEndian(this.width);
                this.bufWriteIntLittleEndian(this.height);
                this.bufWriteShortLittleEndian((short)n7);
                this.bufWriteShortLittleEndian((short)n8);
                if (string2.startsWith("DIB")) {
                    this.bufWriteIntLittleEndian(0);
                } else {
                    this.bufWriteBytes(string2);
                }
                int n11 = 0;
                int n12 = 0;
                n4 = 0;
                s = 0;
                int n13 = 0;
                if (aviVideoFormat != null) {
                    if (aviVideoFormat.getImageSize() != -1) {
                        n11 = aviVideoFormat.getImageSize();
                    }
                    if (aviVideoFormat.getXPelsPerMeter() != -1) {
                        n12 = aviVideoFormat.getXPelsPerMeter();
                    }
                    if (aviVideoFormat.getYPelsPerMeter() != -1) {
                        n4 = aviVideoFormat.getYPelsPerMeter();
                    }
                    if (aviVideoFormat.getClrUsed() != -1) {
                        s = aviVideoFormat.getClrUsed();
                    }
                    if (aviVideoFormat.getClrImportant() != -1) {
                        n13 = aviVideoFormat.getClrImportant();
                    }
                }
                this.bufWriteIntLittleEndian(n11);
                this.bufWriteIntLittleEndian(n12);
                this.bufWriteIntLittleEndian(n4);
                this.bufWriteIntLittleEndian(s);
                this.bufWriteIntLittleEndian(n13);
            } else {
                Integer n14;
                format2 = (AudioFormat)format;
                if (n6 > 0) {
                    this.bufWriteIntLittleEndian(16 + n6 + 2);
                } else {
                    this.bufWriteIntLittleEndian(16);
                }
                if (string2.equals("unknown")) {
                    string2 = "LINEAR";
                }
                if ((n14 = (Integer)WavAudioFormat.reverseFormatMapper.get(string2.toLowerCase())) != null) {
                    this.bufWriteShortLittleEndian(n14.shortValue());
                    n4 = ((AudioFormat)format2).getChannels();
                    this.bufWriteShortLittleEndian((short)n4);
                    this.bufWriteIntLittleEndian((int)((AudioFormat)format2).getSampleRate());
                    s = (short)((AudioFormat)format2).getSampleSizeInBits();
                    if (wavAudioFormat != null) {
                        this.averageBytesPerSecond = wavAudioFormat.getAverageBytesPerSecond();
                        if (n14.shortValue() == 85) {
                            this.mp3BitRate = this.averageBytesPerSecond * 8;
                        }
                    } else if (n14.shortValue() == 85) {
                        int n15 = (int)((AudioFormat)format2).getFrameRate();
                        if (n15 != -1) {
                            this.averageBytesPerSecond = n15;
                            this.mp3BitRate = this.averageBytesPerSecond * 8;
                        } else {
                            this.averageBytesPerSecond = (int)((AudioFormat)format2).getSampleRate() * n4 * (s / 8);
                        }
                    } else {
                        this.averageBytesPerSecond = (int)((AudioFormat)format2).getSampleRate() * n4 * (s / 8);
                    }
                    this.bufWriteIntLittleEndian(this.averageBytesPerSecond);
                    this.blockAlign = ((AudioFormat)format2).getFrameSizeInBits() / 8;
                    if (this.blockAlign < 1) {
                        this.blockAlign = s * n4 / 8;
                    }
                    if (this.blockAlign == 0) {
                        this.blockAlign = 1;
                    }
                    if (this.mp3BitRate > 0) {
                        this.blockAlign = 1;
                    }
                    this.bufWriteShortLittleEndian((short)this.blockAlign);
                    this.bufWriteShortLittleEndian(s);
                }
            }
            if (n6 > 0) {
                if (!bl) {
                    if (byArray != null) {
                        this.bufWriteShortLittleEndian((short)byArray.length);
                        this.bufWriteBytes(byArray);
                    } else {
                        Integer n16 = (Integer)WavAudioFormat.reverseFormatMapper.get(string2.toLowerCase());
                        if (n16 != null && (n9 = (int)n16.shortValue()) == 85) {
                            AudioFormat audioFormat = (AudioFormat)this.inputs[n3];
                            n4 = (int)audioFormat.getFrameRate();
                            if (n4 > 0) {
                                float f2 = 72.0f * (float)n4 * 8.0f / 8000.0f;
                                f2 = (float)((double)f2 * (8000.0 / audioFormat.getSampleRate()));
                                s = (int)f2;
                            } else {
                                s = 417;
                            }
                            this.bufWriteShortLittleEndian((short)12);
                            this.bufWriteShortLittleEndian((short)1);
                            this.bufWriteIntLittleEndian(2);
                            this.bufWriteShortLittleEndian(s);
                            this.bufWriteShortLittleEndian((short)1);
                            this.bufWriteShortLittleEndian((short)1393);
                        }
                    }
                } else {
                    this.bufWriteBytes(byArray);
                }
            }
            ++n3;
        }
        this.bufWriteBytes("LIST");
        this.moviOffset = this.filePointer;
        this.bufSkip(4);
        this.bufWriteBytes("movi");
        this.bufFlush();
        this.seek(this.hdrlSizeOffset);
        int n17 = this.totalStrlLength + 56 + 4 * (3 + 2 * this.numTracks);
        this.bufClear();
        this.bufWriteIntLittleEndian(n17);
        this.bufFlush();
        this.seek(this.moviOffset + 8);
    }

    private void writeIDX1Chunk() {
        this.bufClear();
        this.bufWriteBytes("idx1");
        this.bufWriteIntLittleEndian(this.totalFrames * 16);
        this.bufFlush();
        int n2 = 0;
        while (n2 < this.chunkList.size()) {
            ByteBuffer byteBuffer = (ByteBuffer)this.chunkList.elementAt(n2);
            this.write(byteBuffer.buffer, 0, byteBuffer.length);
            ++n2;
        }
    }
}

