/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class AuParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private Format format = null;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private int encoding;
    private String encodingString;
    private int sampleRate;
    private int samplesPerBlock;
    private int bytesPerSecond;
    private int blockSize;
    private long minLocation;
    private long maxLocation;
    private PullSourceStream stream = null;
    public static final int AU_SUN_MAGIC = 779316836;
    public static final int AU_SUN_INV_MAGIC = 1684960046;
    public static final int AU_DEC_MAGIC = 779314176;
    public static final int AU_DEC_INV_MAGIC = 6583086;
    public static final int AU_ULAW_8 = 1;
    public static final int AU_LINEAR_8 = 2;
    public static final int AU_LINEAR_16 = 3;
    public static final int AU_LINEAR_24 = 4;
    public static final int AU_LINEAR_32 = 5;
    public static final int AU_FLOAT = 6;
    public static final int AU_DOUBLE = 7;
    public static final int AU_ADPCM_G721 = 23;
    public static final int AU_ADPCM_G722 = 24;
    public static final int AU_ADPCM_G723_3 = 25;
    public static final int AU_ADPCM_G723_5 = 26;
    public static final int AU_ALAW_8 = 27;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.basic")};

    public Time getDuration() {
        return this.duration;
    }

    public Time getMediaTime() {
        long l2 = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long l3 = l2 != -1L ? l2 - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)l3 / (double)this.bytesPerSecond);
        }
        return this.mediaTime;
    }

    public String getName() {
        return "Parser for AU file format";
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.minLocation = this.getLocation(this.stream);
        this.maxLocation = this.dataSize == -1 ? Long.MAX_VALUE : this.minLocation + (long)this.dataSize;
        this.tracks[0] = new AuTrack((AudioFormat)this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        int n2;
        long l2;
        boolean bl;
        int n3 = this.readInt(this.stream, true);
        if (n3 == 779316836 || n3 == 779314176) {
            bl = true;
        } else if (n3 == 1684960046 || n3 == 6583086) {
            bl = false;
        } else {
            throw new BadHeaderException("Invalid magic number " + Integer.toHexString(n3));
        }
        int n4 = this.readInt(this.stream);
        if (n4 < 24) {
            throw new BadHeaderException("AU Parser: header size should be atleast 24 but is " + n4);
        }
        this.dataSize = this.readInt(this.stream);
        if (this.dataSize == -1 && (l2 = this.stream.getContentLength()) != -1L) {
            this.dataSize = (int)(l2 - (long)n4);
            if (this.dataSize < 0) {
                this.dataSize = -1;
            }
        }
        int n5 = this.readInt(this.stream);
        this.blockSize = -1;
        switch (n5) {
            case 1: {
                this.encodingString = "ULAW";
                n2 = 8;
                this.blockSize = 1;
                break;
            }
            case 27: {
                this.encodingString = "alaw";
                n2 = 8;
                this.blockSize = 1;
                break;
            }
            case 2: {
                this.encodingString = "LINEAR";
                n2 = 8;
                this.blockSize = 1;
                break;
            }
            case 3: {
                this.encodingString = "LINEAR";
                n2 = 16;
                this.blockSize = 2;
                break;
            }
            case 4: {
                this.encodingString = "LINEAR";
                n2 = 24;
                this.blockSize = 3;
                break;
            }
            case 5: {
                this.encodingString = "LINEAR";
                n2 = 32;
                this.blockSize = 4;
                break;
            }
            case 6: {
                this.encodingString = "float";
                n2 = 32;
                this.blockSize = 4;
                break;
            }
            case 7: {
                this.encodingString = "double";
                n2 = 64;
                this.blockSize = 8;
                break;
            }
            case 23: {
                this.encodingString = "??? what adpcm";
                n2 = 4;
                break;
            }
            case 25: {
                this.encodingString = "G723_3";
                n2 = 3;
                break;
            }
            case 26: {
                this.encodingString = "G723_5";
                n2 = 5;
                break;
            }
            default: {
                throw new BadHeaderException("Unsupported encoding: " + Integer.toHexString(n5));
            }
        }
        int n6 = this.readInt(this.stream);
        if (n6 < 0) {
            throw new BadHeaderException("Negative Sample Rate " + n6);
        }
        int n7 = this.readInt(this.stream);
        if (n7 < 1) {
            throw new BadHeaderException("Number of channels is " + n7);
        }
        if (this.blockSize != -1) {
            this.blockSize *= n7;
        }
        this.skip(this.stream, n4 - 24);
        this.bytesPerSecond = n7 * n2 * n6 / 8;
        int n8 = n7 * n2 / 8;
        this.bufferSize = this.bytesPerSecond;
        if (this.dataSize != -1) {
            double d2 = (double)this.dataSize / (double)this.bytesPerSecond;
            this.duration = new Time(d2);
        }
        boolean bl2 = true;
        this.format = new AudioFormat(this.encodingString, n6, n2, n7, bl ? 1 : 0, bl2 ? 1 : 0, n8 * 8, -1.0, Format.byteArray);
    }

    public Time setPosition(Time time, int n2) {
        if (!this.seekable) {
            return this.getMediaTime();
        }
        if (this.blockSize < 0) {
            return this.getMediaTime();
        }
        long l2 = time.getNanoseconds();
        if (l2 < 0L) {
            l2 = 0L;
        }
        double d2 = (double)(l2 * (long)this.bytesPerSecond) / 1.0E9;
        double d3 = d2 % (double)this.blockSize;
        long l3 = (long)(d2 - d3);
        if (d3 > 0.0) {
            switch (n2) {
                case 1: {
                    l3 += (long)this.blockSize;
                    break;
                }
                case 3: {
                    if (!(d3 > (double)this.blockSize / 2.0)) break;
                    l3 += (long)this.blockSize;
                    break;
                }
            }
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(l3 += this.minLocation);
        if (this.cacheStream != null) {
            AuParser auParser = this;
            synchronized (auParser) {
                this.cacheStream.abortRead();
            }
        }
        return time;
    }

    class AuTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame;
        private SettableTime frameToTime = new SettableTime();

        AuTrack(AudioFormat audioFormat, boolean bl, Time time, int n2, int n3) {
            this(audioFormat, bl, time, n2, n3, 0L, Long.MAX_VALUE);
        }

        AuTrack(AudioFormat audioFormat, boolean bl, Time time, int n2, int n3, long l2, long l3) {
            super(AuParser.this, audioFormat, bl, AuParser.this.duration, time, n2, n3, AuParser.this.stream, l2, l3);
            double d2 = audioFormat.getSampleRate();
            int n4 = audioFormat.getChannels();
            int n5 = audioFormat.getSampleSizeInBits();
            long l4 = this.duration.getNanoseconds();
        }
    }
}

