/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.dsound;

import com.sun.media.protocol.dsound.DSound;
import javax.media.format.AudioFormat;

public class DSoundST
extends DSound
implements Runnable {
    private static final int REQ_OPEN = 1;
    private static final int REQ_FLUSH = 2;
    private static final int REQ_START = 3;
    private static final int REQ_STOP = 4;
    private static final int REQ_CLOSE = 5;
    private static final int REQ_READ = 6;
    protected boolean failure = false;
    protected Thread requestThread = null;
    protected Integer requestLock = new Integer(0);
    protected int request = 0;
    protected int result;
    protected byte[] data;
    protected int offset;
    protected int len;

    public DSoundST(AudioFormat audioFormat, int n2) {
        super(audioFormat, n2);
    }

    public void close() {
        this.waitForRequest(5);
    }

    public void flush() {
        this.waitForRequest(2);
    }

    public void open() {
        if (this.requestThread == null) {
            this.requestThread = new Thread(this);
            this.requestThread.start();
        }
        this.waitForRequest(1);
        if (this.failure) {
            throw new Error("Error opening DSound for capture");
        }
    }

    public int read(byte[] byArray, int n2, int n3) {
        this.data = byArray;
        this.offset = n2;
        this.len = n3;
        this.waitForRequest(6);
        return this.result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = false;
        while (!bl) {
            Integer n2 = this.requestLock;
            synchronized (n2) {
                while (this.request == 0) {
                    try {
                        this.requestLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.request > 0) {
                switch (this.request) {
                    case 1: {
                        try {
                            super.open();
                        }
                        catch (Error error) {
                            this.failure = true;
                        }
                        break;
                    }
                    case 3: {
                        super.start();
                        break;
                    }
                    case 4: {
                        super.stop();
                        break;
                    }
                    case 6: {
                        this.result = super.read(this.data, this.offset, this.len);
                        break;
                    }
                    case 2: {
                        super.flush();
                        break;
                    }
                    case 5: {
                        super.close();
                        bl = true;
                        break;
                    }
                }
            }
            n2 = this.requestLock;
            synchronized (n2) {
                this.request = 0;
                this.requestLock.notifyAll();
            }
        }
    }

    public void start() {
        this.waitForRequest(3);
    }

    public void stop() {
        this.waitForRequest(4);
    }

    private void waitForRequest(int n2) {
        Integer n3 = this.requestLock;
        synchronized (n3) {
            this.request = n2;
            this.requestLock.notifyAll();
            while (this.request > 0) {
                try {
                    this.requestLock.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

