/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPAPPPacket
extends RTCPPacket {
    int ssrc;
    int name;
    int subtype;
    byte[] data;

    public RTCPAPPPacket(int n2, int n3, int n4, byte[] byArray) {
        this.ssrc = n2;
        this.name = n3;
        this.subtype = n4;
        this.data = byArray;
        this.type = 204;
        this.received = false;
        if ((byArray.length & 3) != 0) {
            throw new IllegalArgumentException("Bad data length");
        }
        if (n4 < 0 || n4 > 31) {
            throw new IllegalArgumentException("Bad subtype");
        }
    }

    public RTCPAPPPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 204;
    }

    void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.subtype);
        dataOutputStream.writeByte(204);
        dataOutputStream.writeShort(2 + (this.data.length >> 2));
        dataOutputStream.writeInt(this.ssrc);
        dataOutputStream.writeInt(this.name);
        dataOutputStream.write(this.data);
    }

    public int calcLength() {
        return 12 + this.data.length;
    }

    public String nameString(int n2) {
        return "" + (char)(n2 >>> 24) + (char)(n2 >>> 16 & 0xFF) + (char)(n2 >>> 8 & 0xFF) + (char)(n2 & 0xFF);
    }

    public String toString() {
        return "\tRTCP APP Packet from SSRC " + this.ssrc + " with name " + this.nameString(this.name) + " and subtype " + this.subtype + "\n\tData (length " + this.data.length + "): " + new String(this.data) + "\n";
    }
}

