/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.RTPMediaThread;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.TimeoutEvent;

public class SSRCCacheCleaner
implements Runnable {
    private SSRCCache cache;
    private RTPMediaThread thread;
    private static final int DEATHTIME = 1800000;
    private static final int TIMEOUT_MULTIPLIER = 5;
    boolean timeToClean = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean killed = false;
    private StreamSynch streamSynch;
    static /* synthetic */ Class class$com$sun$media$rtp$util$RTPMediaThread;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public SSRCCacheCleaner(SSRCCache sSRCCache, StreamSynch streamSynch) {
        Object object;
        this.cache = sSRCCache;
        this.streamSynch = streamSynch;
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                if (((String)object).endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = jdk12CreateThreadRunnableAction.conswithname;
                this.thread = (RTPMediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$rtp$util$RTPMediaThread != null ? class$com$sun$media$rtp$util$RTPMediaThread : (class$com$sun$media$rtp$util$RTPMediaThread = SSRCCacheCleaner.class$("com.sun.media.rtp.util.RTPMediaThread")), this, "SSRC Cache Cleaner"));
                Constructor constructor = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(this.thread, new Integer(MediaThread.getControlPriority())));
            }
            catch (Exception exception) {}
        } else {
            this.thread = new RTPMediaThread(this, "SSRC Cache Cleaner");
            this.thread.useControlPriority();
        }
        this.thread.setDaemon(true);
        this.thread.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized void cleannow() {
        long l2 = System.currentTimeMillis();
        if (this.cache.ourssrc == null) {
            return;
        }
        double d2 = this.cache.calcReportInterval(this.cache.ourssrc.sender, true);
        Enumeration enumeration = this.cache.cache.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            SSRCInfo sSRCInfo = (SSRCInfo)enumeration.nextElement();
            if (sSRCInfo.ours) continue;
            if (sSRCInfo.byeReceived) {
                if (l2 - sSRCInfo.byeTime < 1000L) {
                    try {
                        Thread.sleep(1000L - l2 + sSRCInfo.byeTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    l2 = System.currentTimeMillis();
                }
                sSRCInfo.byeTime = 0L;
                sSRCInfo.byeReceived = false;
                this.cache.remove(sSRCInfo.ssrc);
                this.streamSynch.remove(sSRCInfo.ssrc);
                boolean bl = false;
                object = sSRCInfo.sourceInfo;
                if (object != null && ((RTPSourceInfo)object).getStreamCount() == 0) {
                    bl = true;
                }
                ByeEvent byeEvent = null;
                if (sSRCInfo instanceof RecvSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.byereason, bl);
                }
                if (sSRCInfo instanceof PassiveSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo.sourceInfo, null, sSRCInfo.byereason, bl);
                }
                this.cache.eventhandler.postEvent(byeEvent);
                continue;
            }
            if (!((double)sSRCInfo.lastHeardFrom + d2 <= (double)l2)) continue;
            InactiveReceiveStreamEvent inactiveReceiveStreamEvent = null;
            if (!sSRCInfo.inactivesent) {
                boolean bl = false;
                RTPSourceInfo rTPSourceInfo = sSRCInfo.sourceInfo;
                if (rTPSourceInfo != null && rTPSourceInfo.getStreamCount() == 1) {
                    bl = true;
                }
                if (sSRCInfo instanceof ReceiveStream) {
                    inactiveReceiveStreamEvent = new InactiveReceiveStreamEvent(this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo), bl);
                } else if ((double)sSRCInfo.lastHeardFrom + (d2 *= 5.0) <= (double)l2) {
                    inactiveReceiveStreamEvent = new InactiveReceiveStreamEvent(this.cache.sm, sSRCInfo.sourceInfo, null, bl);
                }
                if (inactiveReceiveStreamEvent == null) continue;
                this.cache.eventhandler.postEvent(inactiveReceiveStreamEvent);
                sSRCInfo.quiet = true;
                sSRCInfo.inactivesent = true;
                sSRCInfo.setAlive(false);
                continue;
            }
            if (sSRCInfo.lastHeardFrom + 1800000L > l2) continue;
            object = null;
            this.cache.remove(sSRCInfo.ssrc);
            boolean bl = false;
            RTPSourceInfo rTPSourceInfo = sSRCInfo.sourceInfo;
            if (rTPSourceInfo != null && rTPSourceInfo.getStreamCount() == 0) {
                bl = true;
            }
            object = sSRCInfo instanceof ReceiveStream ? new TimeoutEvent(this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo), bl) : new TimeoutEvent(this.cache.sm, sSRCInfo.sourceInfo, null, bl);
            this.cache.eventhandler.postEvent((RTPEvent)object);
        }
    }

    public synchronized void run() {
        try {
            while (true) {
                if (!this.timeToClean && !this.killed) {
                    this.wait();
                    continue;
                }
                if (this.killed) {
                    return;
                }
                this.cleannow();
                this.timeToClean = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void setClean() {
        this.timeToClean = true;
        this.notifyAll();
    }

    public synchronized void stop() {
        this.killed = true;
        this.notifyAll();
    }
}

