/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.ui.BasicComp;
import com.sun.media.ui.DefaultControlPanel;
import com.sun.media.ui.ToolTip;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.MediaTimeSetEvent;
import javax.media.Player;
import javax.media.Time;

public class ProgressSlider
extends BasicComp
implements MouseListener,
MouseMotionListener,
Runnable,
ComponentListener,
ControllerListener {
    Image imageGrabber;
    Image imageGrabberDown;
    int grabberWidth;
    int grabberHeight;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder = 0;
    int rightBorder = 0;
    int sliderWidth;
    MediaThread timer = null;
    protected boolean justSeeked = false;
    protected boolean stopTimer = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private Player player;
    private DefaultControlPanel controlPanel;
    private ToolTip toolTip = null;
    private double progressCaching = 1.0;
    private boolean resetMediaTime = false;
    Object disposeLock = new Object();
    Object syncStop = new Object();
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public ProgressSlider(String string, DefaultControlPanel defaultControlPanel, Player player) {
        super(string);
        this.player = player;
        this.controlPanel = defaultControlPanel;
        this.imageGrabber = BasicComp.fetchImage("grabber.gif");
        this.imageGrabberDown = BasicComp.fetchImage("grabber-pressed.gif");
        this.grabberWidth = this.imageGrabber.getWidth(this);
        this.grabberHeight = this.imageGrabber.getHeight(this);
        this.rightBorder = this.leftBorder = this.grabberWidth / 2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.grabberPosition = 0;
        this.grabbed = false;
        this.entered = false;
        this.height = 18;
        this.width = 20;
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.addComponentListener(this);
        this.player.addControllerListener(this);
    }

    public void addNotify() {
        Object object;
        super.addNotify();
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = this;
                Constructor constructor = jdk12CreateThreadRunnableAction.cons;
                this.timer = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$util$MediaThread != null ? class$com$sun$media$util$MediaThread : (class$com$sun$media$util$MediaThread = ProgressSlider.class$("com.sun.media.util.MediaThread")), this));
                this.timer.setName("Progress Slider thread");
                constructor = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(this.timer, new Integer(MediaThread.getControlPriority())));
                this.timer.start();
            }
            catch (Exception exception) {}
        } else {
            this.timer = new MediaThread(this);
            this.timer.setName("Progress Slider thread");
            this.timer.useControlPriority();
            this.timer.start();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        if (dimension.width - this.leftBorder - this.rightBorder < 1) {
            return;
        }
        this.grabberPosition = (int)((float)this.grabberPosition * ((float)(dimension.width - this.leftBorder - this.rightBorder) / (float)(this.width - this.leftBorder - this.rightBorder)));
        this.width = dimension.width;
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof CachingControlEvent) {
            CachingControl cachingControl = ((CachingControlEvent)controllerEvent).getCachingControl();
            long l2 = cachingControl.getContentLength();
            long l3 = cachingControl.getContentProgress();
            this.progressCaching = (double)l3 / (double)l2;
            this.repaint();
        } else if (controllerEvent instanceof MediaTimeSetEvent) {
            this.resetMediaTime = true;
        }
    }

    public synchronized void dispose() {
        Object object = this.syncStop;
        synchronized (object) {
            if (this.timer != null) {
                this.stopTimer = true;
            }
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeComponentListener(this);
        object = this.disposeLock;
        synchronized (object) {
            if (this.toolTip != null) {
                this.toolTip.dispose();
                this.toolTip = null;
            }
        }
        this.timer = null;
        this.player = null;
    }

    private String formatTime(long l2) {
        int n2 = (int)(l2 / 1000000000L);
        int n3 = n2 / 3600;
        int n4 = (n2 - n3 * 3600) / 60;
        n2 = n2 - n3 * 3600 - n4 * 60;
        l2 = l2 % 1000000000L / 10000000L;
        int n5 = n3 / 10;
        int n6 = n4 / 10;
        int n7 = n2 / 10;
        long l3 = l2 / 10L;
        String string = new String("" + n5 + (n3 %= 10) + ":" + n6 + (n4 %= 10) + ":" + n7 + (n2 %= 10) + "." + l3 + (l2 %= 10L));
        return string;
    }

    private String formatTime(Time time) {
        String string = new String("<unknown>");
        if (time == null || time == Time.TIME_UNKNOWN || time == Duration.DURATION_UNKNOWN) {
            return string;
        }
        long l2 = time.getNanoseconds();
        string = this.formatTime(l2);
        return string;
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, this.height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled() || this.player == null) {
            return;
        }
        int n2 = this.mouseToSlider(mouseEvent.getX());
        if (n2 != this.grabberPosition) {
            this.grabberPosition = n2;
            float f2 = this.sliderToSeek(this.grabberPosition);
            if (this.player.getState() != 600) {
                this.sliderSeek(f2);
            }
            long l2 = (long)(f2 * (float)this.player.getDuration().getNanoseconds());
            this.updateToolTip(l2);
            this.repaint();
        }
    }

    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        this.entered = true;
        if (this.toolTip == null && this.isEnabled() && this.player != null) {
            this.toolTip = new ToolTip("time/duration");
            this.updateToolTip(this.player.getMediaNanoseconds());
            if (this.isShowing()) {
                Point point = this.getLocationOnScreen();
                point.y += this.height + 4;
                ((Component)this.toolTip).setLocation(point);
                this.toolTip.show();
            }
        }
        this.repaint();
    }

    public synchronized void mouseExited(MouseEvent mouseEvent) {
        if (this.toolTip != null && !this.grabbed) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.entered = false;
        this.repaint();
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        if (this.toolTip != null && this.isShowing()) {
            Dimension dimension = this.toolTip.getSize();
            Point point = this.getLocationOnScreen();
            point.x += mouseEvent.getX() - dimension.width - 2;
            point.y += mouseEvent.getY();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.grabbed = true;
        this.grabberPosition = this.mouseToSlider(mouseEvent.getX());
        this.repaint();
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.grabbed = false;
        this.grabberPosition = this.mouseToSlider(mouseEvent.getX());
        float f2 = this.sliderToSeek(this.grabberPosition);
        this.sliderSeek(f2);
        if (this.toolTip != null && !this.entered) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
        this.repaint();
    }

    public int mouseToSlider(int n2) {
        if (n2 < this.leftBorder) {
            n2 = this.leftBorder;
        }
        if (n2 > this.width - this.rightBorder) {
            n2 = this.width - this.rightBorder;
        }
        return n2 -= this.leftBorder;
    }

    public void paint(Graphics graphics) {
        if (this.isEnabled()) {
            int n2 = this.height / 2 - 2;
            int n3 = this.height / 2 - this.grabberHeight / 2;
            graphics.setColor(this.getBackground().darker());
            graphics.drawRect(this.leftBorder, n2, this.sliderWidth, 3);
            graphics.setColor(this.getBackground());
            int n4 = this.grabberWidth;
            graphics.draw3DRect(this.leftBorder, n2, (int)((double)(this.sliderWidth - n4) * this.progressCaching + (double)n4), 3, false);
            if (this.grabbed || this.entered) {
                graphics.drawImage(this.imageGrabberDown, this.grabberPosition + this.leftBorder - this.grabberWidth / 2, n3, this);
            } else {
                graphics.drawImage(this.imageGrabber, this.grabberPosition + this.leftBorder - this.grabberWidth / 2, n3, this);
            }
        } else if (this.player != null) {
            String string = this.formatTime(this.player.getMediaNanoseconds());
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            graphics.drawString(string, 2, 2 + fontMetrics.getAscent());
        }
    }

    public void removeNotify() {
        Object object;
        if (this.timer != null) {
            object = this.syncStop;
            synchronized (object) {
                this.stopTimer = true;
                this.timer = null;
            }
        }
        object = this.disposeLock;
        synchronized (object) {
            if (this.toolTip != null) {
                ((Component)this.toolTip).setVisible(false);
            }
        }
        super.removeNotify();
    }

    public void run() {
        int n2 = 0;
        int n3 = -1;
        boolean bl = true;
        while (!this.stopTimer) {
            try {
                if (this.player != null && this.player.getState() == 600) {
                    bl = true;
                    n3 = -1;
                } else if (this.player != null && n3 < 5) {
                    ++n3;
                    bl = true;
                } else if (this.resetMediaTime) {
                    bl = true;
                    this.resetMediaTime = false;
                } else {
                    bl = false;
                }
                try {
                    long l2;
                    if (bl && (l2 = this.player.getDuration().getNanoseconds()) > 0L) {
                        long l3 = this.player.getMediaNanoseconds();
                        this.seek((float)l3 / (float)l2);
                        if (!this.grabbed) {
                            this.updateToolTip(l3);
                        }
                    }
                }
                catch (Exception exception) {}
                int n4 = this.isEnabled() ? 200 : 1000;
                try {
                    Thread.sleep(n4);
                }
                catch (Exception exception) {}
                if (++n2 == 1000 / n4) {
                    n2 = 0;
                    this.controlPanel.update();
                }
                if (!this.justSeeked) continue;
                this.justSeeked = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {}
        }
    }

    public void seek(float f2) {
        if (this.justSeeked) {
            return;
        }
        if (!this.grabbed) {
            int n2 = (int)(f2 * (float)this.sliderWidth);
            if (n2 > this.sliderWidth) {
                n2 = this.sliderWidth;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.grabberPosition != n2 || !this.isEnabled()) {
                this.grabberPosition = n2;
                this.repaint();
            }
        }
    }

    private void sliderSeek(float f2) {
        if (this.player == null) {
            return;
        }
        long l2 = (long)(f2 * (float)this.player.getDuration().getNanoseconds());
        this.justSeeked = true;
        if (l2 >= 0L) {
            this.player.setMediaTime(new Time(l2));
            this.controlPanel.resetPauseCount();
            this.controlPanel.update();
        }
    }

    public float sliderToSeek(int n2) {
        float f2 = (float)n2 / (float)this.sliderWidth;
        return f2;
    }

    public void updateToolTip(long l2) {
        if (this.toolTip == null || this.player == null) {
            return;
        }
        Time time = this.player.getDuration();
        String string = new String(String.valueOf(this.formatTime(l2)) + " / " + this.formatTime(time));
        this.toolTip.setText(string);
    }
}

