/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.ui.PlayerWindow;
import com.sun.media.util.JMFI18N;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.media.Processor;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionManager;
import jmapps.rtp.TransmissionStatsDialog;

class TransmitPlayerWindow
extends PlayerWindow
implements ActionListener,
WindowListener {
    private Vector vectorMngrSessions = new Vector();
    private Vector vectorStreams = new Vector();
    private Vector vectorStreamLabels = new Vector();
    private MenuBar menuBar = null;
    private Menu menuStats = null;
    private MenuItem menuItemStats = null;
    private TransmissionStatsDialog dlgTransmissionStats = null;
    private static final String MENU_STATS = JMFI18N.getResource("jmstudio.menu.stats");
    private static final String MENU_STATS_TRANSMISSION = JMFI18N.getResource("jmstudio.menu.player.transmission");

    public TransmitPlayerWindow(Processor processor) {
        super(processor, JMFI18N.getResource("jmstudio.playerwindow.transcoding"), true);
        this.addWindowListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(MENU_STATS_TRANSMISSION)) {
            if (this.dlgTransmissionStats == null) {
                this.dlgTransmissionStats = new TransmissionStatsDialog((Frame)this, this.vectorMngrSessions, this.vectorStreamLabels);
            }
            this.dlgTransmissionStats.setVisible(true);
            this.dlgTransmissionStats.toFront();
        }
    }

    public void addNotify() {
        this.createMenuStats();
        super.addNotify();
    }

    public void addSessionManager(SessionManager sessionManager, SendStream sendStream, String string) {
        this.vectorMngrSessions.addElement(sessionManager);
        this.vectorStreams.addElement(sendStream);
        this.vectorStreamLabels.addElement(string);
        this.createMenuStats();
    }

    private synchronized void createMenuBar() {
        this.menuBar = this.getMenuBar();
        if (this.menuBar == null) {
            this.menuBar = new MenuBar();
            this.setMenuBar(this.menuBar);
        }
    }

    private synchronized void createMenuStats() {
        if (this.menuItemStats != null) {
            return;
        }
        this.createMenuBar();
        if (this.menuStats == null) {
            this.menuStats = new Menu(MENU_STATS);
            this.menuBar.add(this.menuStats);
        }
        this.menuItemStats = new MenuItem(MENU_STATS_TRANSMISSION);
        this.menuStats.add(this.menuItemStats);
        this.menuItemStats.setActionCommand(MENU_STATS_TRANSMISSION);
        this.menuItemStats.addActionListener(this);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.dlgTransmissionStats != null) {
            this.dlgTransmissionStats.dispose();
            this.dlgTransmissionStats = null;
        }
        int n2 = this.vectorStreams.size();
        int n3 = 0;
        while (n3 < n2) {
            SendStream sendStream = (SendStream)this.vectorStreams.elementAt(n3);
            sendStream.close();
            ++n3;
        }
        n2 = this.vectorMngrSessions.size();
        n3 = 0;
        while (n3 < n2) {
            SessionManager sessionManager = (SessionManager)this.vectorMngrSessions.elementAt(n3);
            sessionManager.closeSession("Transmission terminated");
            ++n3;
        }
        this.vectorMngrSessions.removeAllElements();
        this.vectorStreams.removeAllElements();
        this.vectorStreamLabels.removeAllElements();
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

