/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.ui.TabControl;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.SessionManager;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;

public class TransmissionStatsDialog
extends JMDialog {
    private Vector vectorMngrSessions;
    private Vector vectorStreamLabels;
    private UpdateThread threadUpdate = null;
    private Label[] fieldTotalRtpPacketsSent;
    private Label[] fieldTotalBytesSent;
    private Label[] fieldRtcpPacketsSent;
    private Label[] fieldLocalCollisions;
    private Label[] fieldRemoteCollisions;
    private Label[] fieldFailedTransmissions;
    private static final String LABEL_TOTAL_RTP_PACKETS_SENT = JMFI18N.getResource("jmstudio.transmitstats.totalrtppacketssent");
    private static final String LABEL_TOTAL_BYTES_SENT = JMFI18N.getResource("jmstudio.transmitstats.totalbytessent");
    private static final String LABEL_RTCP_PACKETS_SENT = JMFI18N.getResource("jmstudio.transmitstats.rtcppacketssent");
    private static final String LABEL_LOCAL_COLLISIONS = JMFI18N.getResource("jmstudio.transmitstats.localcollisions");
    private static final String LABEL_REMOTE_COLLISIONS = JMFI18N.getResource("jmstudio.transmitstats.remotecollisions");
    private static final String LABEL_FAILED_TRANSMISSIONS = JMFI18N.getResource("jmstudio.transmitstats.failedtransmissions");

    public TransmissionStatsDialog(Frame frame, Vector vector, Vector vector2) {
        super(frame, JMFI18N.getResource("jmstudio.transmitstats.title"), false);
        this.vectorStreamLabels = vector2;
        this.vectorMngrSessions = vector;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(JMDialog.ACTION_CLOSE)) {
            this.setAction(JMDialog.ACTION_CLOSE);
            this.setVisible(false);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.threadUpdate == null) {
            this.threadUpdate = new UpdateThread();
        }
        this.threadUpdate.start();
    }

    private JMPanel createStreamPanel(int n2) {
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        JMPanel jMPanel2 = new JMPanel(new BorderLayout(6, 6));
        jMPanel.add((Component)jMPanel2, "North");
        JMPanel jMPanel3 = new JMPanel(new GridLayout(0, 1, 6, 6));
        jMPanel2.add((Component)jMPanel3, "West");
        JMPanel jMPanel4 = new JMPanel(new GridLayout(0, 1, 6, 6));
        jMPanel2.add((Component)jMPanel4, "Center");
        Label label = new Label(LABEL_TOTAL_RTP_PACKETS_SENT);
        jMPanel3.add(label);
        this.fieldTotalRtpPacketsSent[n2] = new Label("000000000000");
        jMPanel4.add(this.fieldTotalRtpPacketsSent[n2]);
        label = new Label(LABEL_TOTAL_BYTES_SENT);
        jMPanel3.add(label);
        this.fieldTotalBytesSent[n2] = new Label();
        jMPanel4.add(this.fieldTotalBytesSent[n2]);
        label = new Label(LABEL_RTCP_PACKETS_SENT);
        jMPanel3.add(label);
        this.fieldRtcpPacketsSent[n2] = new Label();
        jMPanel4.add(this.fieldRtcpPacketsSent[n2]);
        label = new Label(LABEL_LOCAL_COLLISIONS);
        jMPanel3.add(label);
        this.fieldLocalCollisions[n2] = new Label();
        jMPanel4.add(this.fieldLocalCollisions[n2]);
        label = new Label(LABEL_REMOTE_COLLISIONS);
        jMPanel3.add(label);
        this.fieldRemoteCollisions[n2] = new Label();
        jMPanel4.add(this.fieldRemoteCollisions[n2]);
        label = new Label(LABEL_FAILED_TRANSMISSIONS);
        jMPanel3.add(label);
        this.fieldFailedTransmissions[n2] = new Label();
        jMPanel4.add(this.fieldFailedTransmissions[n2]);
        return jMPanel;
    }

    protected void init() throws Exception {
        JMPanel jMPanel;
        this.setLayout(new BorderLayout(6, 6));
        JMPanel jMPanel2 = new JMPanel(new BorderLayout(6, 6));
        jMPanel2.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)jMPanel2, "Center");
        TabControl tabControl = new TabControl(0);
        jMPanel2.add((Component)tabControl, "Center");
        int n2 = Math.min(this.vectorMngrSessions.size(), this.vectorStreamLabels.size());
        this.fieldTotalRtpPacketsSent = new Label[n2];
        this.fieldTotalBytesSent = new Label[n2];
        this.fieldRtcpPacketsSent = new Label[n2];
        this.fieldLocalCollisions = new Label[n2];
        this.fieldRemoteCollisions = new Label[n2];
        this.fieldFailedTransmissions = new Label[n2];
        int n3 = 0;
        while (n3 < n2) {
            jMPanel = this.createStreamPanel(n3);
            tabControl.addPage(jMPanel, this.vectorStreamLabels.elementAt(n3).toString());
            ++n3;
        }
        jMPanel = new JMPanel(new BorderLayout(6, 6));
        jMPanel2.add((Component)jMPanel, "South");
        JMPanel jMPanel3 = this.createButtonPanel(new String[]{JMDialog.ACTION_CLOSE});
        jMPanel.add((Component)jMPanel3, "East");
        this.pack();
        this.setResizable(false);
        this.updateFields();
    }

    public void removeNotify() {
        if (this.threadUpdate != null) {
            this.threadUpdate.terminate();
            this.threadUpdate = null;
        }
        super.removeNotify();
    }

    private void updateFields() {
        int n2 = Math.min(this.vectorMngrSessions.size(), this.vectorStreamLabels.size());
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = this.vectorMngrSessions.elementAt(n3);
            if (e2 instanceof SessionManager) {
                SessionManager sessionManager = (SessionManager)e2;
                GlobalTransmissionStats globalTransmissionStats = sessionManager.getGlobalTransmissionStats();
                this.fieldTotalRtpPacketsSent[n3].setText(String.valueOf(globalTransmissionStats.getRTPSent()));
                this.fieldTotalBytesSent[n3].setText(String.valueOf(globalTransmissionStats.getBytesSent()));
                this.fieldRtcpPacketsSent[n3].setText(String.valueOf(globalTransmissionStats.getRTCPSent()));
                this.fieldLocalCollisions[n3].setText(String.valueOf(globalTransmissionStats.getLocalColls()));
                this.fieldRemoteCollisions[n3].setText(String.valueOf(globalTransmissionStats.getRemoteColls()));
                this.fieldFailedTransmissions[n3].setText(String.valueOf(globalTransmissionStats.getTransmitFailed()));
            }
            ++n3;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setAction(JMDialog.ACTION_CLOSE);
        this.setVisible(false);
    }

    private class UpdateThread
    extends Thread {
        private boolean boolTerminate = false;

        public void run() {
            while (!this.boolTerminate) {
                try {
                    Thread.sleep(1000L);
                    TransmissionStatsDialog.this.updateFields();
                }
                catch (Exception exception) {}
            }
        }

        public void terminate() {
            this.boolTerminate = true;
        }
    }
}

