/*
 * Decompiled with CFR 0.152.
 */
package jmapps.util;

import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;

public class StateHelper
implements ControllerListener {
    Player player = null;
    boolean configured = false;
    boolean realized = false;
    boolean prefetched = false;
    boolean eom = false;
    boolean failed = false;
    boolean closed = false;

    public StateHelper(Player player) {
        this.player = player;
        player.addControllerListener(this);
    }

    public void close() {
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.close();
            while (!this.closed) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.player.removeControllerListener(this);
    }

    public boolean configure() {
        return this.configure(Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configure(int n2) {
        long l2 = System.currentTimeMillis();
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            if (!(this.player instanceof Processor)) {
                return false;
            }
            ((Processor)this.player).configure();
            do {
                if (this.configured) return this.configured;
                if (this.failed) return this.configured;
                try {
                    this.wait(n2);
                }
                catch (InterruptedException interruptedException) {}
            } while (System.currentTimeMillis() - l2 <= (long)n2);
            return this.configured;
        }
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof RealizeCompleteEvent) {
            this.realized = true;
        } else if (controllerEvent instanceof ConfigureCompleteEvent) {
            this.configured = true;
        } else if (controllerEvent instanceof PrefetchCompleteEvent) {
            this.prefetched = true;
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            this.eom = true;
        } else if (controllerEvent instanceof ControllerErrorEvent) {
            this.failed = true;
        } else if (controllerEvent instanceof ControllerClosedEvent) {
            this.closed = true;
        } else {
            return;
        }
        this.notifyAll();
    }

    public boolean playToEndOfMedia(int n2) {
        long l2 = System.currentTimeMillis();
        this.eom = false;
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.start();
            while (!this.eom && !this.failed) {
                try {
                    this.wait(n2);
                }
                catch (InterruptedException interruptedException) {}
                if (System.currentTimeMillis() - l2 > (long)n2) break;
            }
        }
        return this.eom && !this.failed;
    }

    public boolean prefetch(int n2) {
        long l2 = System.currentTimeMillis();
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.prefetch();
            while (!this.prefetched && !this.failed) {
                try {
                    this.wait(n2);
                }
                catch (InterruptedException interruptedException) {}
                if (System.currentTimeMillis() - l2 > (long)n2) break;
            }
        }
        return this.prefetched && !this.failed;
    }

    public boolean realize() {
        return this.realize(Integer.MAX_VALUE);
    }

    public boolean realize(int n2) {
        long l2 = System.currentTimeMillis();
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.realize();
            while (!this.realized && !this.failed) {
                try {
                    this.wait(n2);
                }
                catch (InterruptedException interruptedException) {}
                if (System.currentTimeMillis() - l2 > (long)n2) break;
            }
        }
        return this.realized;
    }
}

