/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;

public class SVGTextPathElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public String getLocalName() {
        return "textPath";
    }

    public TextPath createTextPath(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context;
        Object object;
        Shape shape;
        String string;
        Element element2;
        block13: {
            String string2 = XLinkSupport.getXLinkHref(element);
            element2 = bridgeContext.getReferencedElement(element, string2);
            if (element2 == null || !element2.getTagName().equals("path")) {
                throw new BridgeException(element, "uri.badTarget", new Object[]{string2});
            }
            string = element2.getAttributeNS(null, "d");
            shape = null;
            if (string.length() != 0) {
                object = new AWTPathProducer();
                ((AWTPathProducer)object).setWindingRule(CSSUtilities.convertFillRule(element2));
                try {
                    try {
                        PathParser pathParser = new PathParser();
                        pathParser.setPathHandler((PathHandler)object);
                        pathParser.parse(string);
                    }
                    catch (ParseException parseException) {
                        throw new BridgeException(element2, "attribute.malformed", new Object[]{"d"});
                    }
                    context = null;
                    shape = ((AWTPathProducer)object).getShape();
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    shape = ((AWTPathProducer)object).getShape();
                    throw throwable;
                }
            }
            throw new BridgeException(element2, "attribute.missing", new Object[]{"d"});
        }
        string = element2.getAttributeNS(null, "transform");
        if (string.length() != 0) {
            object = SVGUtilities.convertTransform(element2, "transform", string);
            shape = ((AffineTransform)object).createTransformedShape(shape);
        }
        object = new TextPath(new GeneralPath(shape));
        string = element.getAttributeNS(null, "startOffset");
        if (string.length() > 0) {
            float f = 0.0f;
            int n = string.indexOf("%");
            if (n != -1) {
                float f2 = ((TextPath)object).lengthOfPath();
                String string3 = string.substring(0, n);
                float f3 = 0.0f;
                try {
                    f3 = SVGUtilities.convertSVGNumber(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    f3 = -1.0f;
                }
                if (f3 < 0.0f) {
                    throw new BridgeException(element, "attribute.malformed", new Object[]{"startOffset", string});
                }
                f = (float)((double)(f3 * f2) / 100.0);
            } else {
                context = UnitProcessor.createContext(bridgeContext, element);
                f = UnitProcessor.svgOtherLengthToUserSpace(string, "startOffset", context);
            }
            ((TextPath)object).setStartOffset(f);
        }
        return object;
    }
}

