/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class FilterFactory
extends AbstractValueFactory {
    protected AbstractValueFactory.URIFactory uriFactory = new AbstractValueFactory.URIFactory(this, this.getParser());

    public FilterFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "filter";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 24: {
                return new ImmutableString(20, lexicalUnit.getStringValue());
            }
            case 35: {
                if (!lexicalUnit.getStringValue().equalsIgnoreCase("none")) break;
                return ValueConstants.NONE_VALUE;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        if (s == 21 && string.equalsIgnoreCase("none")) {
            return ValueConstants.NONE_VALUE;
        }
        if (s == 20) {
            return new ImmutableString(s, string);
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string, this.getPropertyName()});
    }
}

