/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class RedRable
extends AbstractRable {
    CachableRed src;

    public RedRable(CachableRed cachableRed) {
        super((Filter)null);
        this.src = cachableRed;
    }

    public CachableRed getSource() {
        return this.src;
    }

    public Object getProperty(String string) {
        return this.src.getProperty(string);
    }

    public String[] getPropertyNames() {
        return this.src.getPropertyNames();
    }

    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds();
    }

    public RenderedImage createDefaultRendering() {
        return this.getSource();
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        Rectangle rectangle = (shape = renderContext.getAreaOfInterest()) != null ? shape.getBounds() : this.getBounds2D().getBounds();
        AffineTransform affineTransform = renderContext.getTransform();
        CachableRed cachableRed = this.getSource();
        if (!rectangle.intersects(cachableRed.getBounds())) {
            return null;
        }
        rectangle = rectangle.intersection(cachableRed.getBounds());
        Rectangle rectangle2 = affineTransform.createTransformedShape(rectangle).getBounds();
        return new AffineRed(cachableRed, affineTransform, renderingHints);
    }
}

