/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser.style;

import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.style.CSSValueFactory;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSValue;

public class StyleAttributeParser
implements Localizable {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.parser.style.resources.Messages";
    static final LocalizableSupport LOCALIZABLE_SUPPORT = new LocalizableSupport("org.apache.batik.parser.style.resources.Messages");
    protected Parser parser;
    protected ErrorHandler errorHandler;
    protected Map factories = new HashMap(5);

    public StyleAttributeParser(String string) throws ParseException {
        try {
            this.parser = (Parser)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new ParseException(this.formatMessage("creation.exception", new Object[]{exception.getMessage()}), exception);
        }
    }

    public void setLocale(Locale locale) {
        this.parser.setLocale(locale);
        LOCALIZABLE_SUPPORT.setLocale(locale);
    }

    public Locale getLocale() {
        Locale locale = LOCALIZABLE_SUPPORT.getLocale();
        return locale == null ? Locale.getDefault() : locale;
    }

    public String formatMessage(String string, Object[] objectArray) {
        return LOCALIZABLE_SUPPORT.formatMessage(string, objectArray);
    }

    public CSSValue parse(Reader reader, String string, String string2) throws ParseException {
        Map map = (Map)this.factories.get(string = string == null ? "" : string);
        if (map == null) {
            throw new ParseException(this.formatMessage("unknown.attribute", new Object[]{string, string2}), -1, -1);
        }
        CSSValueFactory cSSValueFactory = (CSSValueFactory)map.get(string2);
        if (cSSValueFactory == null) {
            throw new ParseException(this.formatMessage("unknown.attribute", new Object[]{string, string2}), -1, -1);
        }
        try {
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(new InputSource(reader));
            return cSSValueFactory.createCSSValue(lexicalUnit);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ParseException(this.formatMessage("parser.exception", new Object[]{exception.getMessage()}), exception);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.parser.setErrorHandler(this.errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void putCSSValueFactory(String string, String string2, CSSValueFactory cSSValueFactory) {
        HashMap<String, CSSValueFactory> hashMap = (HashMap<String, CSSValueFactory>)this.factories.get(string = string == null ? "" : string);
        if (hashMap == null) {
            hashMap = new HashMap<String, CSSValueFactory>(5);
            this.factories.put(string, hashMap);
        }
        hashMap.put(string2, cSSValueFactory);
    }

    public void removeCSSValueFactory(String string, String string2) {
        Map map = (Map)this.factories.get(string = string == null ? "" : string);
        if (map != null) {
            map.remove(string2);
        }
    }
}

