/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.StaticRendererFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.LengthKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.apache.batik.transcoder.keys.Rectangle2DKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;

public abstract class ImageTranscoder
extends XMLAbstractTranscoder {
    protected UserAgent userAgent = new ImageTranscoderUserAgent();
    protected static final Set FEATURES = new HashSet();
    public static final TranscodingHints.Key KEY_WIDTH;
    public static final TranscodingHints.Key KEY_HEIGHT;
    public static final TranscodingHints.Key KEY_AOI;
    public static final TranscodingHints.Key KEY_LANGUAGE;
    public static final TranscodingHints.Key KEY_MEDIA;
    public static final TranscodingHints.Key KEY_ALTERNATE_STYLESHEET;
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI;
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM;
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR;

    protected ImageTranscoder() {
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, "svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, ExtensibleSVGDOMImplementation.getDOMImplementation());
        this.hints.put(KEY_MEDIA, "screen");
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        AffineTransform affineTransform;
        float f;
        float f2;
        GraphicsNode graphicsNode;
        Object object;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException(Messages.formatMessage("notsvg", null));
        }
        SVGDocument sVGDocument = (SVGDocument)document;
        if (this.hints.containsKey(KEY_ALTERNATE_STYLESHEET)) {
            object = (String)this.hints.get(KEY_ALTERNATE_STYLESHEET);
            ((SVGOMDocument)sVGDocument).enableAlternateStyleSheet((String)object);
        }
        object = sVGDocument.getRootElement();
        DefaultSVGContext defaultSVGContext = new DefaultSVGContext();
        defaultSVGContext.setPixelToMM(this.userAgent.getPixelToMM());
        ((SVGOMDocument)document).setSVGContext(defaultSVGContext);
        GVTBuilder gVTBuilder = new GVTBuilder();
        StaticRendererFactory staticRendererFactory = new StaticRendererFactory();
        BridgeContext bridgeContext = new BridgeContext(this.userAgent);
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, sVGDocument);
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException(bridgeException);
        }
        float f3 = (float)bridgeContext.getDocumentSize().getWidth();
        float f4 = (float)bridgeContext.getDocumentSize().getHeight();
        bridgeContext = null;
        gVTBuilder = null;
        float f5 = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f5 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float f6 = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            f6 = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (f5 > 0.0f && f6 > 0.0f) {
            f2 = f5;
            f = f6;
        } else if (f6 > 0.0f) {
            f2 = f3 * f6 / f4;
            f = f6;
        } else if (f5 > 0.0f) {
            f2 = f5;
            f = f4 * f5 / f3;
        } else {
            f2 = f3;
            f = f4;
        }
        String string2 = null;
        try {
            string2 = new URL(string).getRef();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            affineTransform = ViewBox.getViewTransform(string2, (Element)object, f2, f);
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException(bridgeException);
        }
        if (affineTransform.isIdentity() && (f2 != f3 || f != f4)) {
            float f7 = Math.max(f3, f4);
            float f8 = Math.max(f2, f);
            float f9 = f8 / f7;
            affineTransform = AffineTransform.getScaleInstance(f9, f9);
        }
        if (this.hints.containsKey(KEY_AOI)) {
            Rectangle2D rectangle2D = (Rectangle2D)this.hints.get(KEY_AOI);
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
            AffineTransform affineTransform2 = new AffineTransform();
            double d = (double)f2 / rectangle2D.getWidth();
            double d2 = (double)f / rectangle2D.getHeight();
            affineTransform2.scale(d, d2);
            double d3 = -rectangle2D.getX();
            double d4 = -rectangle2D.getY();
            affineTransform2.translate(d3, d4);
            affineTransform.preConcatenate(affineTransform2);
        }
        int n = (int)f2;
        int n2 = (int)f;
        ImageRenderer imageRenderer = staticRendererFactory.createImageRenderer();
        imageRenderer.updateOffScreen(n, n2);
        imageRenderer.setTransform(affineTransform);
        imageRenderer.setTree(graphicsNode);
        graphicsNode = null;
        try {
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f2, f);
            imageRenderer.repaint(affineTransform.createInverse().createTransformedShape(float_));
            BufferedImage bufferedImage = imageRenderer.getOffScreen();
            imageRenderer = null;
            BufferedImage bufferedImage2 = this.createImage(n, n2);
            Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage2);
            if (this.hints.containsKey(KEY_BACKGROUND_COLOR)) {
                Paint paint = (Paint)this.hints.get(KEY_BACKGROUND_COLOR);
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.dispose();
            }
            if (bufferedImage != null) {
                graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
            }
            bufferedImage = null;
            this.writeImage(bufferedImage2, transcoderOutput);
        }
        catch (Exception exception) {
            throw new TranscoderException(exception);
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXSVGDocumentFactory(string);
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public abstract void writeImage(BufferedImage var1, TranscoderOutput var2) throws TranscoderException;

    static {
        FEATURES.add("org.w3c.svg");
        FEATURES.add("org.w3c.svg.lang");
        FEATURES.add("org.w3c.svg.static");
        KEY_WIDTH = new LengthKey();
        KEY_HEIGHT = new LengthKey();
        KEY_AOI = new Rectangle2DKey();
        KEY_LANGUAGE = new StringKey();
        KEY_MEDIA = new StringKey();
        KEY_ALTERNATE_STYLESHEET = new StringKey();
        KEY_USER_STYLESHEET_URI = new StringKey();
        KEY_PIXEL_TO_MM = new FloatKey();
        KEY_BACKGROUND_COLOR = new PaintKey();
    }

    protected class ImageTranscoderUserAgent
    implements UserAgent {
        protected Set extensions = new HashSet();

        protected ImageTranscoderUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public void displayError(String string) {
            try {
                ImageTranscoder.this.handler.error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception exception) {
            try {
                ImageTranscoder.this.handler.error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String string) {
            try {
                ImageTranscoder.this.handler.warning(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public float getPixelToMM() {
            if (ImageTranscoder.this.hints.containsKey(KEY_PIXEL_TO_MM)) {
                return ((Float)ImageTranscoder.this.hints.get(KEY_PIXEL_TO_MM)).floatValue();
            }
            return 0.26458332f;
        }

        public String getLanguages() {
            if (ImageTranscoder.this.hints.containsKey(KEY_LANGUAGE)) {
                return (String)ImageTranscoder.this.hints.get(KEY_LANGUAGE);
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            return (String)ImageTranscoder.this.hints.get(KEY_USER_STYLESHEET_URI);
        }

        public String getXMLParserClassName() {
            if (ImageTranscoder.this.hints.containsKey(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME)) {
                return (String)ImageTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            return (Boolean)ImageTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING);
        }

        public String getMedia() {
            return (String)ImageTranscoder.this.hints.get(KEY_MEDIA);
        }

        public EventDispatcher getEventDispatcher() {
            return null;
        }

        public void openLink(SVGAElement sVGAElement) {
        }

        public void setSVGCursor(Cursor cursor) {
        }

        public void runThread(Thread thread) {
        }

        public AffineTransform getTransform() {
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return new Point();
        }

        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        public boolean supportExtension(String string) {
            return this.extensions.contains(string);
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            Iterator iterator = bridgeExtension.getImplementedExtensions();
            while (iterator.hasNext()) {
                this.extensions.add(iterator.next());
            }
        }

        public void handleElement(Element element, Object object) {
        }
    }
}

