/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.Serializable;
import java.util.Stack;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.RecordStore;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;

public class WMFPainter {
    private static final String WMF_FILE_EXTENSION = ".wmf";
    private static final int INPUT_BUFFER_SIZE = 30720;
    private static BasicStroke solid = new BasicStroke(1.0f, 0, 1);
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    private RecordStore currentStore;
    private transient boolean bReadingWMF = true;
    private transient BufferedInputStream bufStream = null;

    public WMFPainter(RecordStore recordStore) {
        this.setRecordStore(recordStore);
    }

    public void paint(Graphics graphics) {
        int n = 10;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        Font font = null;
        Stack<Serializable> stack = new Stack<Serializable>();
        int n8 = this.currentStore.getNumRecords();
        int n9 = this.currentStore.getNumObjects();
        int n10 = this.currentStore.getVpX();
        int n11 = this.currentStore.getVpY();
        int n12 = this.currentStore.getVpW();
        int n13 = this.currentStore.getVpH();
        if (!this.currentStore.isReading()) {
            GdiObject gdiObject;
            graphics.setPaintMode();
            n5 = -1;
            n6 = -1;
            n7 = -1;
            Color color = null;
            Color color2 = null;
            int n14 = 0;
            while (n14 < n9) {
                gdiObject = this.currentStore.getObject(n14);
                gdiObject.Clear();
                ++n14;
            }
            int n15 = n12;
            int n16 = n13;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n15, n16);
            graphics.setColor(Color.black);
            double d = (double)n15 / (double)n12;
            double d2 = (double)n16 / (double)n13;
            int n17 = 0;
            while (n17 < n8) {
                MetaRecord metaRecord = this.currentStore.getRecord(n17);
                block5 : switch (metaRecord.functionId) {
                    case 523: {
                        n10 = -metaRecord.ElementAt(0).intValue();
                        this.currentStore.setVpX(n10);
                        n11 = -metaRecord.ElementAt(1).intValue();
                        this.currentStore.setVpY(n11);
                        break;
                    }
                    case 0: 
                    case 524: {
                        n12 = metaRecord.ElementAt(0);
                        this.currentStore.setVpW(n12);
                        n13 = metaRecord.ElementAt(1);
                        this.currentStore.setVpH(n13);
                        d = (double)n15 / (double)n12;
                        d2 = (double)n16 / (double)n13;
                        break;
                    }
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 1040: 
                    case 1042: {
                        break;
                    }
                    case 262: {
                        break;
                    }
                    case 762: {
                        Color color3;
                        int n18 = 0;
                        try {
                            n18 = metaRecord.ElementAt(5);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n19 = metaRecord.ElementAt(0);
                        if (n19 == 5) {
                            color3 = new Color(255, 255, 255);
                            n18 = n9 + 8;
                            this.addObjectAt(this.currentStore, 4, color3, n18);
                        } else {
                            color3 = new Color(metaRecord.ElementAt(1), metaRecord.ElementAt(2), metaRecord.ElementAt(3));
                            this.addObjectAt(this.currentStore, 1, color3, n18);
                        }
                        n2 = metaRecord.ElementAt(4);
                        break;
                    }
                    case 764: {
                        int n20 = 0;
                        try {
                            n20 = metaRecord.ElementAt(5);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n21 = metaRecord.ElementAt(0);
                        if (n21 == 0) {
                            this.addObjectAt(this.currentStore, 2, new Color(metaRecord.ElementAt(1), metaRecord.ElementAt(2), metaRecord.ElementAt(3)), n20);
                            break;
                        }
                        this.addObjectAt(this.currentStore, 5, new Color(0, 0, 0), n20);
                        break;
                    }
                    case 763: {
                        int n22 = metaRecord.ElementAt(1) > 0 ? 2 : 0;
                        n22 |= metaRecord.ElementAt(2) > 400 ? 1 : 0;
                        int n23 = (int)(d2 * (double)metaRecord.ElementAt(0).intValue());
                        String string = ((StringRecord)metaRecord).text;
                        if (n23 < 0) {
                            n23 = (int)((double)n23 * -1.3);
                        }
                        int n24 = 0;
                        try {
                            n24 = metaRecord.ElementAt(3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        n = n23;
                        font = new Font(string, n22, n23);
                        this.addObjectAt(this.currentStore, 3, font, n24);
                        break;
                    }
                    case 247: 
                    case 248: 
                    case 322: 
                    case 505: 
                    case 765: 
                    case 1790: 
                    case 1791: {
                        this.addObjectAt(this.currentStore, 6, new Integer(0), 0);
                        break;
                    }
                    case 53: 
                    case 55: 
                    case 313: 
                    case 564: 
                    case 1078: {
                        break;
                    }
                    case 301: {
                        int n25 = metaRecord.ElementAt(0);
                        if ((n25 & Integer.MIN_VALUE) != 0) break;
                        if (n25 >= n9) {
                            switch (n25 -= n9) {
                                case 5: {
                                    n5 = -1;
                                    break block5;
                                }
                                case 8: {
                                    n6 = -1;
                                    break block5;
                                }
                            }
                            break;
                        }
                        gdiObject = this.currentStore.getObject(n25);
                        if (!gdiObject.used) break;
                        switch (gdiObject.type) {
                            case 1: {
                                graphics.setColor((Color)gdiObject.obj);
                                n6 = n25;
                                break;
                            }
                            case 2: {
                                graphics.setColor((Color)gdiObject.obj);
                                n5 = n25;
                                break;
                            }
                            case 3: {
                                font = (Font)gdiObject.obj;
                                graphics.setFont(font);
                                n7 = n25;
                                break;
                            }
                            case 4: {
                                n6 = -1;
                                break;
                            }
                            case 5: {
                                n5 = -1;
                            }
                        }
                        break;
                    }
                    case 496: {
                        int n25 = metaRecord.ElementAt(0);
                        gdiObject = this.currentStore.getObject(n25);
                        if (n25 == n5) {
                            n5 = -1;
                        } else if (n25 == n6) {
                            n6 = -1;
                        } else if (n25 == n7) {
                            n7 = -1;
                        }
                        gdiObject.Clear();
                        break;
                    }
                    case 1336: {
                        int n26 = metaRecord.ElementAt(0);
                        int[] nArray = new int[n26];
                        int n27 = 0;
                        while (n27 < n26) {
                            nArray[n27] = metaRecord.ElementAt(n27 + 1);
                            ++n27;
                        }
                        int n28 = n26 + 1;
                        int n29 = 0;
                        while (n29 < n26) {
                            int n30 = nArray[n29];
                            int[] nArray2 = new int[n30];
                            int[] nArray3 = new int[n30];
                            int n31 = 0;
                            while (n31 < n30) {
                                nArray2[n31] = (int)(d * (double)(n10 + metaRecord.ElementAt(n28 + n31 * 2)));
                                nArray3[n31] = (int)(d2 * (double)(n11 + metaRecord.ElementAt(n28 + n31 * 2 + 1)));
                                ++n31;
                            }
                            n28 += n30;
                            if (n5 >= 0) {
                                this.setBrushColor(this.currentStore, graphics, n5);
                                graphics.fillPolygon(nArray2, nArray3, n30);
                            }
                            this.setPenColor(this.currentStore, graphics, n6);
                            graphics.drawPolygon(nArray2, nArray3, n30);
                            ++n29;
                        }
                        break;
                    }
                    case 804: {
                        int n32 = metaRecord.ElementAt(0);
                        int[] nArray = new int[n32 + 1];
                        int[] nArray4 = new int[n32 + 1];
                        int n33 = 0;
                        while (n33 < n32) {
                            nArray[n33] = (int)(d * (double)(n10 + metaRecord.ElementAt(n33 * 2 + 1)));
                            nArray4[n33] = (int)(d2 * (double)(n11 + metaRecord.ElementAt(n33 * 2 + 2)));
                            ++n33;
                        }
                        nArray[n32] = nArray[0];
                        nArray4[n32] = nArray4[0];
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillPolygon(nArray, nArray4, n32);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawPolygon(nArray, nArray4, n32 + 1);
                        break;
                    }
                    case 532: {
                        n3 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        n4 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        break;
                    }
                    case 531: {
                        int n34 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n35 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawLine(n3, n4, n34, n35);
                        n3 = n34;
                        n4 = n35;
                        break;
                    }
                    case 805: {
                        this.setPenColor(this.currentStore, graphics, n6);
                        int n36 = metaRecord.ElementAt(0);
                        int n37 = (int)(d * (double)(n10 + metaRecord.ElementAt(1)));
                        int n38 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(2)));
                        int n39 = 1;
                        while (n39 < n36) {
                            int n40 = (int)(d * (double)(n10 + metaRecord.ElementAt(n39 * 2 + 1)));
                            int n41 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(n39 * 2 + 2)));
                            graphics.drawLine(n37, n38, n40, n41);
                            n37 = n40;
                            n38 = n41;
                            ++n39;
                        }
                        break;
                    }
                    case 1051: {
                        int n42 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n43 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n44 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n45 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillRect(n42, n44, n43 - n42 - 1, n45 - n44 - 1);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawRect(n42, n44, n43 - n42 - 1, n45 - n44 - 1);
                        break;
                    }
                    case 1564: {
                        int n46 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n47 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n48 = (int)(d * (double)metaRecord.ElementAt(4).intValue());
                        int n49 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n50 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        int n51 = (int)(d2 * (double)metaRecord.ElementAt(5).intValue());
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillRoundRect(n46, n49, n47 - n46, n50 - n49, n48, n51);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawRoundRect(n46, n49, n47 - n46, n50 - n49, n48, n51);
                        break;
                    }
                    case 1048: {
                        int n52 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n53 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n54 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n55 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillOval(n52, n54, n53 - n52, n55 - n54);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawOval(n52, n54, n53 - n52 - 1, n55 - n54 - 1);
                        break;
                    }
                    case 521: {
                        color = new Color(metaRecord.ElementAt(0), metaRecord.ElementAt(1), metaRecord.ElementAt(2));
                        break;
                    }
                    case 513: {
                        color2 = new Color(metaRecord.ElementAt(0), metaRecord.ElementAt(1), metaRecord.ElementAt(2));
                        break;
                    }
                    case 1313: 
                    case 1583: 
                    case 2610: {
                        Cloneable cloneable;
                        float f;
                        float f2;
                        try {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            int n56 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                            int n57 = (int)((double)n + d2 * (double)(n11 + metaRecord.ElementAt(1)));
                            if (color != null) {
                                graphics.setColor(color);
                            } else {
                                graphics.setColor(Color.black);
                            }
                            StringRecord stringRecord = (StringRecord)metaRecord;
                            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                            GeneralPath generalPath = new GeneralPath(1);
                            TextLayout textLayout = new TextLayout(stringRecord.text, font, fontRenderContext);
                            double_.y += (double)textLayout.getAscent();
                            if (bl || stringRecord.text.startsWith("Sono una scala verticale di prevalenza")) {
                                AffineTransform affineTransform = new AffineTransform();
                                f2 = (float)textLayout.getBounds().getWidth();
                                f = (float)textLayout.getBounds().getHeight();
                                cloneable = new AffineTransform();
                                ((AffineTransform)cloneable).translate(n56, n57);
                                ((AffineTransform)cloneable).rotate(Math.toRadians(270.0));
                                ((AffineTransform)cloneable).translate(0.0, f);
                                Shape shape = textLayout.getOutline((AffineTransform)cloneable);
                                generalPath.append(affineTransform.createTransformedShape(shape), false);
                                graphics2D.draw(shape);
                                break;
                            }
                            graphics.drawString(stringRecord.text, n56, n57);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 2071: 
                    case 2074: {
                        int n58 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n59 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n60 = (int)(d * (double)metaRecord.ElementAt(4).intValue());
                        int n61 = (int)(d * (double)metaRecord.ElementAt(6).intValue());
                        int n62 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n63 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        int n64 = (int)(d2 * (double)metaRecord.ElementAt(5).intValue());
                        int n65 = (int)(d2 * (double)metaRecord.ElementAt(7).intValue());
                        this.setBrushColor(this.currentStore, graphics, n5);
                        int n66 = n58 + (n59 - n58) / 2;
                        int n67 = n62 + (n63 - n62) / 2;
                        int n68 = (int)Math.atan((n64 - n67) / (n60 - n66));
                        int n69 = (int)Math.atan((n65 - n67) / (n61 - n66));
                        if (metaRecord.functionId == 2071) {
                            graphics.drawArc(n58, n62, n59 - n58, n63 - n62, n68, n69);
                            break;
                        }
                        graphics.fillArc(n58, n62, n59 - n58, n63 - n62, n68, n69);
                        break;
                    }
                    case 2096: {
                        break;
                    }
                    case 30: {
                        stack.push(new Integer(n2));
                        stack.push(new Integer(n3));
                        stack.push(new Integer(n4));
                        stack.push(new Integer(n5));
                        stack.push(new Integer(n6));
                        stack.push(new Integer(n7));
                        stack.push(color);
                        stack.push(color2);
                        break;
                    }
                    case 295: {
                        color2 = (Color)stack.pop();
                        color = (Color)stack.pop();
                        n7 = (Integer)stack.pop();
                        n6 = (Integer)stack.pop();
                        n5 = (Integer)stack.pop();
                        n4 = (Integer)stack.pop();
                        n3 = (Integer)stack.pop();
                        n2 = (Integer)stack.pop();
                        break;
                    }
                    case 4096: {
                        Cloneable cloneable;
                        float f;
                        float f2;
                        try {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            this.setPenColor(this.currentStore, graphics, n6);
                            int n70 = metaRecord.ElementAt(0);
                            int n71 = (n70 - 1) / 3;
                            f2 = (float)(d * (double)(n10 + metaRecord.ElementAt(1)));
                            f = (float)(d2 * (double)(n11 + metaRecord.ElementAt(2)));
                            cloneable = new GeneralPath(1);
                            ((Path2D.Float)cloneable).moveTo(f2, f);
                            int n72 = 0;
                            while (n72 < n71) {
                                float f3 = (float)(d * (double)(n10 + metaRecord.ElementAt(n72 * 6 + 3)));
                                float f4 = (float)(d2 * (double)(n11 + metaRecord.ElementAt(n72 * 6 + 4)));
                                float f5 = (float)(d * (double)(n10 + metaRecord.ElementAt(n72 * 6 + 5)));
                                float f6 = (float)(d2 * (double)(n11 + metaRecord.ElementAt(n72 * 6 + 6)));
                                float f7 = (float)(d * (double)(n10 + metaRecord.ElementAt(n72 * 6 + 7)));
                                float f8 = (float)(d2 * (double)(n11 + metaRecord.ElementAt(n72 * 6 + 8)));
                                ((Path2D.Float)cloneable).curveTo(f3, f4, f5, f6, f7, f8);
                                f2 = f7;
                                f = f8;
                                ++n72;
                            }
                            graphics2D.setStroke(solid);
                            graphics2D.draw((Shape)((Object)cloneable));
                        }
                        catch (Exception exception) {
                            System.out.println("Unable to draw static text as a 2D graphics context is required");
                        }
                        break;
                    }
                }
                ++n17;
            }
        }
    }

    private void setPenColor(RecordStore recordStore, Graphics graphics, int n) {
        if (n >= 0) {
            GdiObject gdiObject = recordStore.getObject(n);
            graphics.setColor((Color)gdiObject.obj);
            n = -1;
        }
    }

    private void setBrushColor(RecordStore recordStore, Graphics graphics, int n) {
        if (n >= 0) {
            GdiObject gdiObject = recordStore.getObject(n);
            graphics.setColor((Color)gdiObject.obj);
            n = -1;
        }
    }

    public void setRecordStore(RecordStore recordStore) {
        if (recordStore == null) {
            throw new IllegalArgumentException();
        }
        this.currentStore = recordStore;
    }

    public RecordStore getRecordStore() {
        return this.currentStore;
    }

    private void addObject(RecordStore recordStore, int n, Object object) {
        recordStore.addObject(n, object);
    }

    private void addObjectAt(RecordStore recordStore, int n, Object object, int n2) {
        recordStore.addObjectAt(n, object, n2);
    }
}

