/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.metadata.search.client.applet.model.CVContentHandler;
import mpi.metadata.search.model.AbstractCVUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppletCVUtil
implements AbstractCVUtil {
    private final List nodeIds;
    private final String servlet;

    public AppletCVUtil(String queryServlet, List nodeIds) {
        this.servlet = queryServlet;
        this.nodeIds = nodeIds;
    }

    public List getEntriesForPath(String path) throws Exception {
        StringBuffer sb = new StringBuffer("?request=getOccurrences&path=" + URLEncoder.encode(path, "UTF-8"));
        if (this.nodeIds != null) {
            for (int i = 0; i < this.nodeIds.size(); ++i) {
                sb.append("&nodeid=" + URLEncoder.encode((String)this.nodeIds.get(i), "UTF-8"));
            }
        }
        URLConnection servletConnection = AppletCVUtil.getServletConnection(this.servlet + sb.toString());
        ArrayList entries = new ArrayList();
        try {
            InputStream instr = servletConnection.getInputStream();
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(instr, (DefaultHandler)new CVContentHandler(entries));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return entries;
    }

    public static URLConnection getServletConnection(String requestURL) throws MalformedURLException, IOException {
        System.out.println("Opening connection to URL: " + requestURL);
        URL url = new URL(requestURL);
        URLConnection servletConnection = url.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(false);
        servletConnection.setUseCaches(true);
        servletConnection.setRequestProperty("Content-Type", "text/xml");
        return servletConnection;
    }
}

