/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.model;

import java.net.URL;
import java.net.URLConnection;
import mpi.metadata.search.client.model.MDClient2Server;
import mpi.metadata.search.model.MDResult;
import mpi.search.result.model.Match;

public class MDAppletResult
extends MDResult {
    private String sessionId;
    private URL servletURL;
    private int first = 1;
    private int matchCount;

    public int[] getLastReadChunk() {
        return new int[]{this.first, this.data.size()};
    }

    public Match getMatch(int matchNumber) {
        if (super.getMatch(matchNumber) == null) {
            try {
                this.readMatchesTill(matchNumber);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.getMatch(matchNumber);
    }

    public void setMatchCount(int matchCount) {
        this.matchCount = matchCount;
    }

    public int getRealSize() {
        return Math.max(super.getRealSize(), this.matchCount);
    }

    public void setSessionId(String id) {
        this.sessionId = id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setServletUrl(URL sessionURL) {
        this.servletURL = sessionURL;
    }

    public URL getServletUrl() {
        return this.servletURL;
    }

    public void pageUp() {
        int realIndex = Math.min(this.matchCount, (this.pageOffset + 2) * this.pageSize);
        if (this.data.size() < realIndex) {
            try {
                this.readMatchesTill(realIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.pageUp();
    }

    private void readMatchesTill(int matchNumber) throws Exception {
        if (this.servletURL == null) {
            throw new Exception("Session URL is lost - can't get matches");
        }
        this.first = this.data.size() + 1;
        URL urlServlet = new URL(this.servletURL.toString() + ";jsessionid=" + this.sessionId + "?action=getMatches&first=" + this.first + "&last=" + matchNumber);
        URLConnection servletConnection = MDClient2Server.getServletConnection(urlServlet);
        MDClient2Server.receiveMatches(null, servletConnection, this, false);
    }
}

