/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.model;

import mpi.metadata.search.client.applet.model.MDAppletResult;
import mpi.metadata.search.model.MDMatch;
import mpi.metadata.search.model.MDResult;
import mpi.metadata.search.model.MDSearchDomain;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MDAppletResultContentHandler
extends DefaultHandler {
    private final MDResult result;
    private final boolean firstCall;
    private String elementTextContent = "";
    private MDMatch match;
    private MDSearchDomain searchDomain;

    public MDAppletResultContentHandler(MDSearchDomain searchDomain, MDResult result, boolean firstCall) {
        this.result = result;
        this.firstCall = firstCall;
        this.searchDomain = searchDomain;
    }

    public void startDocument() throws SAXException {
        this.elementTextContent = "";
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("Match")) {
            this.match = new MDMatch();
            this.match.setSearchDomain(this.searchDomain);
        }
        this.elementTextContent = "";
    }

    protected String getTextContent() {
        return this.elementTextContent.trim();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("Id")) {
            this.match.setId(this.getTextContent());
        } else if (qName.equals("Name")) {
            this.match.setName(this.getTextContent());
        } else if (qName.equals("Title")) {
            this.match.setTitle(this.getTextContent());
        } else if (qName.equals("TreePath")) {
            this.match.setTreePath(this.getTextContent());
        } else if (qName.equals("URL")) {
            this.match.setURL(this.getTextContent());
        } else if (qName.equals("ActorCode")) {
            this.match.setActorCode(this.getTextContent());
        } else if (this.firstCall && qName.equals("MatchCount") && this.result instanceof MDAppletResult) {
            int matchCount = Integer.parseInt(this.getTextContent());
            ((MDAppletResult)this.result).setMatchCount(matchCount);
        } else if (this.firstCall && qName.equals("SelectedSessionCount")) {
            int selectedSessionCount = Integer.parseInt(this.getTextContent());
            this.result.addSelectedSessionCount(selectedSessionCount);
        } else if (qName.equals("Match")) {
            this.result.addMatch(this.match);
        } else if (this.firstCall && qName.equals("SessionId") && this.result instanceof MDAppletResult) {
            ((MDAppletResult)this.result).setSessionId(this.getTextContent());
        } else if (qName.equals("SearchTime")) {
            try {
                long searchTime = Long.parseLong(this.getTextContent());
                this.result.setSearchTime(searchTime);
            }
            catch (Exception e) {}
        } else if (qName.equals("Error")) {
            throw new SAXException(this.getTextContent());
        }
    }

    public void characters(char[] ch, int start, int end) {
        this.elementTextContent = this.elementTextContent + new String(ch, start, end);
    }
}

