/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import mpi.metadata.search.client.applet.model.MDAppletResult;
import mpi.metadata.search.client.model.MDClient2Server;
import mpi.metadata.search.model.MDQuery;
import mpi.search.model.ProgressListener;
import mpi.search.model.SearchEngine;
import mpi.search.query.model.Query;

public class MDAppletSearchEngine
implements SearchEngine {
    private ProgressListener progressListener;
    private URL servletUrl;
    private long sessionAndCatalogCount;

    public MDAppletSearchEngine(ProgressListener progressListener, URL servletURL, long sessionAndCatalogCount) {
        this.progressListener = progressListener;
        this.servletUrl = servletURL;
        this.sessionAndCatalogCount = sessionAndCatalogCount;
    }

    public void performSearch(Query query) throws Exception {
        if (this.progressListener != null) {
            this.progressListener.setIndeterminate(true);
        }
        URL newServletUrl = this.servletUrl;
        try {
            newServletUrl = new URL(this.servletUrl.toString() + ";jsessionid=" + ((MDAppletResult)query.getResult()).getSessionId());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        MDQuery mdqry = (MDQuery)query;
        mdqry.setSessionAndCatalogCount(this.sessionAndCatalogCount);
        System.out.println("Servlet url : " + this.servletUrl);
        URLConnection servletConnection = MDClient2Server.getServletConnection(newServletUrl, mdqry);
        MDAppletResult result = (MDAppletResult)query.getResult();
        result.setServletUrl(this.servletUrl);
        MDClient2Server.receiveMatches(null, servletConnection, result, true);
    }
}

