/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MDAppletTranslateAtStartupResult {
    private static final String NODE_ID_SEPARATOR = ",";
    private static final String NODE_ID_ENCODING = "UTF-8";
    private long count;
    private int timing;
    private List nodeNames = new ArrayList();
    private List nodeIds = new ArrayList();

    public static MDAppletTranslateAtStartupResult createMDAppletTranslateAtStartupResult(String nodeIdString) {
        MDAppletTranslateAtStartupResult result = new MDAppletTranslateAtStartupResult();
        result.setNodeIdsFromString(nodeIdString);
        return result;
    }

    private MDAppletTranslateAtStartupResult() {
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getTiming() {
        return this.timing;
    }

    public void setTiming(int timing) {
        this.timing = timing;
    }

    public List getNodeNames() {
        return this.nodeNames;
    }

    public void setNodeNames(List nodeNames) {
        this.nodeNames = nodeNames;
    }

    public void addNodeNames(String nodeName) {
        this.nodeNames.add(nodeName);
    }

    public List getNodeIds() {
        return this.nodeIds;
    }

    protected void setNodeIdsFromString(String nodeIdString) {
        if (nodeIdString != null && (nodeIdString = nodeIdString.trim()).length() > 0) {
            String[] nodes = nodeIdString.split(NODE_ID_SEPARATOR);
            this.nodeIds = nodes != null ? Arrays.asList(nodes) : new ArrayList();
        }
    }

    public String getNodeIdString() throws UnsupportedEncodingException {
        String nodeIdString = "";
        Iterator it = this.nodeIds.iterator();
        while (it.hasNext()) {
            String nodeId = (String)it.next();
            nodeIdString = nodeIdString + URLEncoder.encode(nodeId, NODE_ID_ENCODING);
            nodeIdString = nodeIdString + NODE_ID_SEPARATOR;
        }
        return nodeIdString;
    }
}

