/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.viewer;

import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import mpi.search.result.model.Match;

public class MDResultListCellRenderer
extends DefaultListCellRenderer {
    private Color highlightColor;
    private Hashtable tooltipHash = new Hashtable();

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof Match && component instanceof JComponent) {
            if (this.tooltipHash.containsKey(value)) {
                ((JComponent)component).setToolTipText((String)this.tooltipHash.get(value));
                if (!isSelected && this.highlightColor != null) {
                    component.setBackground(this.highlightColor);
                }
            } else {
                ((JComponent)component).setToolTipText(null);
            }
        }
        return component;
    }

    public void put(Match match, String tooltipText) {
        if (tooltipText != null && tooltipText.length() > 0) {
            this.tooltipHash.put(match, tooltipText);
        }
    }

    public void reset() {
        this.tooltipHash.clear();
    }
}

