/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import mpi.metadata.search.client.applet.model.MDAppletTranslateAtStartupResult;
import mpi.metadata.search.client.applet.viewer.MDAppletResultViewer;
import mpi.metadata.search.client.applet.viewer.MDSearchAppletPanel;
import mpi.metadata.search.client.model.MDClient2Server;

public class MDSearchApplet
extends JApplet {
    public static final Color BACKGROUND_COLOR = new Color(255, 255, 242);
    private DisplaySplashPanel splashUIState;
    private DisplaySearchPanel searchUIState;
    private JPanel contentpane = new JPanel();
    private MDAppletTranslateAtStartupResult result;

    public void init() {
        this.splashUIState = new DisplaySplashPanel();
        this.searchUIState = new DisplaySearchPanel(this);
        UIManager.put("Panel.background", BACKGROUND_COLOR);
        this.setContentPane(this.contentpane);
        this.changeUIState(this.splashUIState);
        this.setVisible(true);
        SwingWorker worker = new SwingWorker(){
            private MDAppletTranslateAtStartupResult result;

            protected Object doInBackground() throws Exception {
                try {
                    URL servletURL = new URL(MDSearchApplet.this.getCodeBase(), "servlet");
                    String nodeString = MDSearchApplet.this.getParameter("nodes");
                    this.result = MDAppletTranslateAtStartupResult.createMDAppletTranslateAtStartupResult(nodeString);
                    MDClient2Server.getTranslateAtStartupResult(servletURL, this.result);
                }
                catch (Exception ex) {
                    System.err.println("Failed to translate at startup");
                    ex.printStackTrace();
                    throw ex;
                }
                return null;
            }

            public void done() {
                MDSearchApplet.this.setResult(this.result);
                MDSearchApplet.this.changeUIState(MDSearchApplet.this.searchUIState);
            }
        };
        worker.execute();
    }

    protected MDAppletTranslateAtStartupResult getResult() {
        return this.result;
    }

    protected void setResult(MDAppletTranslateAtStartupResult result) {
        this.result = result;
    }

    protected void changeUIState(Runnable newUIState) {
        if (SwingUtilities.isEventDispatchThread()) {
            newUIState.run();
        } else {
            SwingUtilities.invokeLater(newUIState);
        }
    }

    private class DisplaySearchPanel
    implements Runnable {
        private MDSearchApplet parent;

        public DisplaySearchPanel(MDSearchApplet parent) {
            this.parent = parent;
        }

        public void run() {
            MDSearchAppletPanel appletPanel = new MDSearchAppletPanel(this.parent);
            MDAppletResultViewer resultViewer = new MDAppletResultViewer(appletPanel){

                public Dimension getPreferredSize() {
                    return new Dimension(480, 100);
                }
            };
            appletPanel.setResultViewer(resultViewer);
            JScrollPane scrollPane = new JScrollPane(appletPanel);
            scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            scrollPane.setVerticalScrollBarPolicy(21);
            MDSearchApplet.this.contentpane.removeAll();
            MDSearchApplet.this.contentpane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            MDSearchApplet.this.contentpane.add((Component)scrollPane, c);
            MDSearchApplet.this.contentpane.invalidate();
            MDSearchApplet.this.contentpane.updateUI();
        }
    }

    private class DisplaySplashPanel
    implements Runnable {
        private DisplaySplashPanel() {
        }

        public void run() {
            JPanel pnlLoading = new JPanel();
            JLabel lbl = new JLabel("Initializing metadata search. Please wait...");
            lbl.setHorizontalAlignment(0);
            pnlLoading.setLayout(new BorderLayout());
            pnlLoading.add((Component)lbl, "Center");
            MDSearchApplet.this.contentpane.removeAll();
            MDSearchApplet.this.contentpane.setLayout(new BorderLayout());
            MDSearchApplet.this.contentpane.add((Component)pnlLoading, "Center");
            MDSearchApplet.this.contentpane.invalidate();
            MDSearchApplet.this.contentpane.updateUI();
        }
    }
}

