/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.applet.viewer;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import mpi.metadata.search.client.applet.model.AppletCVUtil;
import mpi.metadata.search.client.applet.model.MDAppletResult;
import mpi.metadata.search.client.applet.model.MDAppletSearchEngine;
import mpi.metadata.search.client.applet.model.MDAppletTranslateAtStartupResult;
import mpi.metadata.search.client.applet.viewer.MDSearchApplet;
import mpi.metadata.search.client.model.MDSearchConfig;
import mpi.metadata.search.client.viewer.MDAbstractSearchPanel;
import mpi.metadata.search.model.MDMatch;
import mpi.metadata.search.model.MDResult;
import mpi.metadata.search.model.MDSearchDomain;
import mpi.search.model.DefaultSearchController;
import mpi.search.result.model.Match;
import mpi.vocabs.IMDIVocab;

public class MDSearchAppletPanel
extends MDAbstractSearchPanel {
    private static final String showActionName = "Show Session";
    private static final String showTreeActionName = "Show Session with Tree";
    private static final String contentSearchActionName = "Content search";
    private Action contentSearchAction;
    private final MDSearchApplet applet;
    private String sessionId;
    private String contentSearch;
    private URL servletURL = null;
    private MDAppletTranslateAtStartupResult translateAtStartupResult;

    public MDSearchAppletPanel(MDSearchApplet applet) {
        super(MDSearchConfig.getDefaultSearchStructure());
        this.applet = applet;
        this.translateAtStartupResult = applet.getResult();
        this.sessionId = applet.getParameter("sessionId");
        IMDIVocab.useCache = false;
        ArrayList<String> actionNameVector = new ArrayList<String>();
        actionNameVector.add(showTreeActionName);
        actionNameVector.add(showActionName);
        this.contentSearch = applet.getParameter("contentSearch");
        if (this.contentSearch != null && !this.contentSearch.equals("") && !this.contentSearch.equals("null")) {
            actionNameVector.add(contentSearchActionName);
        }
        try {
            final URL helpURL = new URL(applet.getParameter("help"));
            this.helpAction = new AbstractAction("Help"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MDSearchAppletPanel.this.applet.getAppletContext().showDocument(helpURL, "helpFrame");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        actionNames = actionNameVector.toArray(new String[0]);
        try {
            this.servletURL = new URL(applet.getCodeBase(), "servlet");
            this.setSelectedNodes(this.translateAtStartupResult.getNodeIds().size());
            this.setSelectedNodesInfo(this.translateAtStartupResult.getNodeNames(), this.translateAtStartupResult.getCount());
            this.corpusStructureServiceTextField.setEditable(false);
            this.corpusStructureServiceTextField.setBorder(null);
            this.contentSearchAction = new AbstractAction(contentSearchActionName){

                public void actionPerformed(ActionEvent e) {
                    MDSearchAppletPanel.this.callContentSearch();
                }
            };
            this.contentSearchAction.putValue("ShortDescription", "Annotation content search");
            this.contentSearchAction.setEnabled(false);
            this.userActions = this.contentSearch != null && !this.contentSearch.equals("") && !this.contentSearch.equals("null") ? new Action[]{this.exportAction, this.printAction, this.contentSearchAction} : new Action[]{this.exportAction, this.printAction};
            this.makeLayout();
            this.advancedQueryPanel.setCVUtil(new AppletCVUtil(this.servletURL.toString(), applet.getResult().getNodeIds()));
            this.corpusStructureServicePanel.setVisible(false);
            this.searchEngine = new DefaultSearchController(this, new MDAppletSearchEngine(this.progressViewer, this.servletURL, this.translateAtStartupResult.getCount()));
            this.searchEngine.setProgressListener(this.progressViewer);
            this.setQueryPanel("Keyword search");
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, "Servlet URL\n" + e.getMessage() + "\nCannot perform search", "Fatal error", 0);
        }
    }

    public void handleMatch(Match match, String parameter) {
        String servlet = null;
        String target = "";
        String nodeId = "";
        try {
            nodeId = ((MDMatch)match).getId().replaceAll("#", "%23");
        }
        catch (Exception e) {
            // empty catch block
        }
        String searchSession = ((MDAppletResult)this.queryManager.getCurrentQuery().getResult()).getSessionId();
        if (showActionName.equals(parameter)) {
            servlet = this.servletURL + ";jsessionid=" + searchSession + "?request=show&nodeid=" + nodeId;
            target = "IMDI";
        } else if (showTreeActionName.equals(parameter)) {
            servlet = this.servletURL + ";jsessionid=" + searchSession + "?request=showTree&nodeid=" + nodeId;
            target = "IMDI";
        } else if (contentSearchActionName.equals(parameter) && this.contentSearch != null) {
            servlet = this.contentSearch + "?nodeid=" + nodeId;
            target = "ANNEX";
        }
        if (servlet != null) {
            try {
                URL servletURL = new URL(servlet);
                this.applet.getAppletContext().showDocument(servletURL, target);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Could not connect to URL " + servlet);
            }
        }
    }

    protected MDSearchDomain[] getSearchDomains() {
        return new MDSearchDomain[]{new MDSearchDomain("", this.applet.getResult().getNodeIds())};
    }

    protected void setSelectedNodes(int count) {
        this.selectedNodesInfoLabel.setText("  within " + count + " selected " + (count == 1 ? "corpus" : "corpora"));
    }

    protected void setSelectedNodesInfo(List selectedNodes, long count) {
        String txt = "";
        if (selectedNodes != null && selectedNodes.size() > 0) {
            Iterator it = selectedNodes.iterator();
            while (it.hasNext()) {
                String node = (String)it.next();
                if ((txt = txt + node).length() >= 49) break;
                txt = txt + ",";
            }
            if (txt.endsWith(",")) {
                txt = txt.substring(0, txt.length() - 1);
            }
            txt = txt + " [" + count;
            txt = count > 1L ? txt + " sessions/catalogs]" : txt + " session/catalog]";
        }
        this.selectedNodesInfoLabel.setText(this.selectedNodesInfoLabel.getText() + ": " + txt);
    }

    protected MDResult createResult() {
        MDAppletResult result = new MDAppletResult();
        result.setSessionId(this.sessionId);
        return result;
    }

    public void executionStopped() {
        super.executionStopped();
        String maybeNewSessionId = ((MDAppletResult)this.queryManager.getCurrentQuery().getResult()).getSessionId();
        if (maybeNewSessionId.equals(this.sessionId)) {
            this.sessionId = maybeNewSessionId;
        }
    }

    protected void updateActions() {
        super.updateActions();
        this.contentSearchAction.setEnabled(this.exportAction.isEnabled());
    }

    private void callContentSearch() {
        if (this.contentSearch != null) {
            try {
                String metadataServletUrl = ((MDAppletResult)this.queryManager.getCurrentQuery().getResult()).getServletUrl().toString();
                URL contentServletUrl = new URL(this.contentSearch + "?MDSearchSessionURL=" + metadataServletUrl + ";jsessionid=" + this.sessionId);
                try {
                    this.applet.getAppletContext().showDocument(contentServletUrl, "ANNEX");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Could not connect to URL " + this.servletURL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

